/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.io.SocketSettings;
import swim.io.TcpSettings;
import swim.io.TlsSettings;
import swim.io.http.HttpSettingsForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class HttpSettings
implements Debug {
    protected final SocketSettings socketSettings;
    protected final int maxMessageSize;
    private static int hashSeed;
    private static HttpSettings standard;
    private static Form<HttpSettings> form;

    public HttpSettings(SocketSettings socketSettings, int maxMessageSize) {
        this.socketSettings = socketSettings;
        this.maxMessageSize = maxMessageSize;
    }

    public final SocketSettings socketSettings() {
        return this.socketSettings;
    }

    public HttpSettings socketSettings(SocketSettings socketSettings) {
        return this.copy(socketSettings, this.maxMessageSize);
    }

    public final TcpSettings tcpSettings() {
        return this.socketSettings.tcpSettings();
    }

    public HttpSettings tcpSettings(TcpSettings tcpSettings) {
        return this.socketSettings(this.socketSettings.tcpSettings(tcpSettings));
    }

    public final TlsSettings tlsSettings() {
        return this.socketSettings.tlsSettings();
    }

    public HttpSettings tlsSettings(TlsSettings tlsSettings) {
        return this.socketSettings(this.socketSettings.tlsSettings(tlsSettings));
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public HttpSettings maxMessageSize(int maxMessageSize) {
        return this.copy(this.socketSettings, maxMessageSize);
    }

    protected HttpSettings copy(SocketSettings socketSettings, int maxMessageSize) {
        return new HttpSettings(socketSettings, maxMessageSize);
    }

    public Value toValue() {
        return HttpSettings.form().mold((Object)this).toValue();
    }

    public boolean canEqual(Object other) {
        return other instanceof HttpSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpSettings) {
            HttpSettings that = (HttpSettings)other;
            return that.canEqual(this) && this.socketSettings.equals((Object)that.socketSettings) && this.maxMessageSize == that.maxMessageSize;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.socketSettings.hashCode()), (int)this.maxMessageSize));
    }

    public void debug(Output<?> output) {
        output = output.write("HttpSettings").write(46).write("standard").write(40).write(41).write(46).write("socketSettings").write(40).debug((Object)this.socketSettings).write(41).write(46).write("maxMessageSize").write(40).debug((Object)this.maxMessageSize).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static HttpSettings standard() {
        if (standard == null) {
            int maxMessageSize;
            try {
                maxMessageSize = Integer.parseInt(System.getProperty("swim.http.max.message.size"));
            }
            catch (NumberFormatException error) {
                maxMessageSize = 0x1000000;
            }
            standard = new HttpSettings(SocketSettings.standard(), maxMessageSize);
        }
        return standard;
    }

    public static HttpSettings from(SocketSettings socketSettings) {
        return HttpSettings.standard().socketSettings(socketSettings);
    }

    @Kind
    public static Form<HttpSettings> form() {
        if (form == null) {
            form = new HttpSettingsForm();
        }
        return form;
    }
}

