/*
 * Decompiled with CFR 0.152.
 */
package swim.deflate;

import swim.codec.Binary;
import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.deflate.Adler32;
import swim.deflate.CRC32;
import swim.deflate.DeflateException;
import swim.deflate.GzHeader;

public class Deflate<O>
extends Encoder<Encoder<?, O>, O>
implements Cloneable {
    public Encoder<?, O> input;
    protected int flush;
    public long total_in;
    public byte[] next_out;
    public int next_out_index;
    public int avail_out;
    public long total_out;
    int data_type;
    int adler;
    int status;
    byte[] pending_buf;
    int pending_out;
    int pending;
    int wrap;
    GzHeader gzhead;
    int gzindex;
    int last_flush;
    int w_size;
    int w_bits;
    int w_mask;
    byte[] window;
    OutputBuffer<?> window_buffer;
    int window_size;
    short[] prev;
    short[] head;
    int ins_h;
    int hash_size;
    int hash_bits;
    int hash_mask;
    int hash_shift;
    int block_start;
    int match_length;
    int prev_match;
    int match_available;
    int strstart;
    int match_start;
    int lookahead;
    int prev_length;
    int max_chain_length;
    int max_lazy_match;
    int level;
    int strategy;
    int good_match;
    int nice_match;
    short[] dyn_ltree = new short[1146];
    short[] dyn_dtree = new short[122];
    short[] bl_tree = new short[78];
    Tree l_desc;
    Tree d_desc;
    Tree bl_desc;
    short[] bl_count = new short[16];
    short[] next_code = new short[16];
    int[] heap = new int[573];
    int heap_len;
    int heap_max;
    byte[] depth = new byte[573];
    byte[] l_buf;
    int lit_bufsize;
    int last_lit;
    int d_buf;
    int opt_len;
    int static_len;
    int matches;
    int insert;
    short bi_buf;
    int bi_valid;
    public static final int Z_NO_FLUSH = 0;
    public static final int Z_PARTIAL_FLUSH = 1;
    public static final int Z_SYNC_FLUSH = 2;
    public static final int Z_FULL_FLUSH = 3;
    public static final int Z_FINISH = 4;
    public static final int Z_BLOCK = 5;
    public static final int Z_TREES = 6;
    public static final int Z_OK = 0;
    public static final int Z_STREAM_END = 1;
    public static final int Z_NEED_DICT = 2;
    public static final int Z_ERRNO = -1;
    public static final int Z_STREAM_ERROR = -2;
    public static final int Z_DATA_ERROR = -3;
    public static final int Z_MEM_ERROR = -4;
    public static final int Z_BUF_ERROR = -5;
    public static final int Z_VERSION_ERROR = -6;
    public static final int Z_NO_WRAP = 0;
    public static final int Z_WRAP_ZLIB = 1;
    public static final int Z_WRAP_GZIP = 2;
    public static final int Z_NO_COMPRESSION = 0;
    public static final int Z_BEST_SPEED = 1;
    public static final int Z_BEST_COMPRESSION = 9;
    public static final int Z_DEFAULT_COMPRESSION = -1;
    public static final int Z_FILTERED = 1;
    public static final int Z_HUFFMAN_ONLY = 2;
    public static final int Z_RLE = 3;
    public static final int Z_FIXED = 4;
    public static final int Z_DEFAULT_STRATEGY = 0;
    public static final int Z_BINARY = 0;
    public static final int Z_TEXT = 1;
    public static final int Z_UNKNOWN = 2;
    public static final int MAX_WBITS = 15;
    public static final int DEF_MEM_LEVEL = 8;
    public static final int OS_UNKNOWN = 255;
    public static final int OS_CODE = 255;
    static final int Z_DEFLATED = 8;
    static final int LENGTH_CODES = 29;
    static final int LITERALS = 256;
    static final int L_CODES = 286;
    static final int D_CODES = 30;
    static final int BL_CODES = 19;
    static final int HEAP_SIZE = 573;
    static final int MAX_BITS = 15;
    static final int END_BLOCK = 256;
    static final int BUF_SIZE = 16;
    static final int INIT_STATE = 42;
    static final int EXTRA_STATE = 69;
    static final int NAME_STATE = 73;
    static final int COMMENT_STATE = 91;
    static final int HCRC_STATE = 103;
    static final int BUSY_STATE = 113;
    static final int FINISH_STATE = 666;
    static final int STORED_BLOCK = 0;
    static final int STATIC_TREES = 1;
    static final int DYN_TREES = 2;
    static final int MIN_MATCH = 3;
    static final int MAX_MATCH = 258;
    static final int MIN_LOOKAHEAD = 262;
    static final int TOO_FAR = 4096;
    static final int MAX_MEM_LEVEL = 9;
    static final int NEED_MORE = 0;
    static final int BLOCK_DONE = 1;
    static final int FINISH_STARTED = 2;
    static final int FINISH_DONE = 3;
    static final int PRESET_DICT = 32;
    static final int STORED = 0;
    static final int FAST = 1;
    static final int SLOW = 2;
    static final Config[] configuration_table = new Config[]{new Config(0, 0, 0, 0, 0), new Config(4, 4, 8, 4, 1), new Config(4, 5, 16, 8, 1), new Config(4, 6, 32, 32, 1), new Config(4, 4, 16, 16, 2), new Config(8, 16, 32, 32, 2), new Config(8, 16, 128, 128, 2), new Config(8, 32, 128, 256, 2), new Config(32, 128, 258, 1024, 2), new Config(32, 258, 258, 4096, 2)};
    static final String[] z_errmsg = new String[]{"need dictionary", "stream end", "", "file error", "stream error", "data error", "insufficient memory", "buffer error", "incompatible version", ""};
    static final int MAX_BL_BITS = 7;
    static final int REP_3_6 = 16;
    static final int REPZ_3_10 = 17;
    static final int REPZ_11_138 = 18;
    static final int[] extra_lbits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0};
    static final int[] extra_dbits = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    static final int[] extra_blbits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 7};
    static final byte[] bl_order = new byte[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    static final int DIST_CODE_LEN = 512;
    static final byte[] dist_code = new byte[]{0, 1, 2, 3, 4, 4, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 0, 0, 16, 17, 18, 18, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29};
    static final byte[] length_code = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28};
    static final int[] base_length = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 14, 16, 20, 24, 28, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 0};
    static final int[] base_dist = new int[]{0, 1, 2, 3, 4, 6, 8, 12, 16, 24, 32, 48, 64, 96, 128, 192, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096, 6144, 8192, 12288, 16384, 24576};
    static final short[] static_ltree = new short[]{12, 8, 140, 8, 76, 8, 204, 8, 44, 8, 172, 8, 108, 8, 236, 8, 28, 8, 156, 8, 92, 8, 220, 8, 60, 8, 188, 8, 124, 8, 252, 8, 2, 8, 130, 8, 66, 8, 194, 8, 34, 8, 162, 8, 98, 8, 226, 8, 18, 8, 146, 8, 82, 8, 210, 8, 50, 8, 178, 8, 114, 8, 242, 8, 10, 8, 138, 8, 74, 8, 202, 8, 42, 8, 170, 8, 106, 8, 234, 8, 26, 8, 154, 8, 90, 8, 218, 8, 58, 8, 186, 8, 122, 8, 250, 8, 6, 8, 134, 8, 70, 8, 198, 8, 38, 8, 166, 8, 102, 8, 230, 8, 22, 8, 150, 8, 86, 8, 214, 8, 54, 8, 182, 8, 118, 8, 246, 8, 14, 8, 142, 8, 78, 8, 206, 8, 46, 8, 174, 8, 110, 8, 238, 8, 30, 8, 158, 8, 94, 8, 222, 8, 62, 8, 190, 8, 126, 8, 254, 8, 1, 8, 129, 8, 65, 8, 193, 8, 33, 8, 161, 8, 97, 8, 225, 8, 17, 8, 145, 8, 81, 8, 209, 8, 49, 8, 177, 8, 113, 8, 241, 8, 9, 8, 137, 8, 73, 8, 201, 8, 41, 8, 169, 8, 105, 8, 233, 8, 25, 8, 153, 8, 89, 8, 217, 8, 57, 8, 185, 8, 121, 8, 249, 8, 5, 8, 133, 8, 69, 8, 197, 8, 37, 8, 165, 8, 101, 8, 229, 8, 21, 8, 149, 8, 85, 8, 213, 8, 53, 8, 181, 8, 117, 8, 245, 8, 13, 8, 141, 8, 77, 8, 205, 8, 45, 8, 173, 8, 109, 8, 237, 8, 29, 8, 157, 8, 93, 8, 221, 8, 61, 8, 189, 8, 125, 8, 253, 8, 19, 9, 275, 9, 147, 9, 403, 9, 83, 9, 339, 9, 211, 9, 467, 9, 51, 9, 307, 9, 179, 9, 435, 9, 115, 9, 371, 9, 243, 9, 499, 9, 11, 9, 267, 9, 139, 9, 395, 9, 75, 9, 331, 9, 203, 9, 459, 9, 43, 9, 299, 9, 171, 9, 427, 9, 107, 9, 363, 9, 235, 9, 491, 9, 27, 9, 283, 9, 155, 9, 411, 9, 91, 9, 347, 9, 219, 9, 475, 9, 59, 9, 315, 9, 187, 9, 443, 9, 123, 9, 379, 9, 251, 9, 507, 9, 7, 9, 263, 9, 135, 9, 391, 9, 71, 9, 327, 9, 199, 9, 455, 9, 39, 9, 295, 9, 167, 9, 423, 9, 103, 9, 359, 9, 231, 9, 487, 9, 23, 9, 279, 9, 151, 9, 407, 9, 87, 9, 343, 9, 215, 9, 471, 9, 55, 9, 311, 9, 183, 9, 439, 9, 119, 9, 375, 9, 247, 9, 503, 9, 15, 9, 271, 9, 143, 9, 399, 9, 79, 9, 335, 9, 207, 9, 463, 9, 47, 9, 303, 9, 175, 9, 431, 9, 111, 9, 367, 9, 239, 9, 495, 9, 31, 9, 287, 9, 159, 9, 415, 9, 95, 9, 351, 9, 223, 9, 479, 9, 63, 9, 319, 9, 191, 9, 447, 9, 127, 9, 383, 9, 255, 9, 511, 9, 0, 7, 64, 7, 32, 7, 96, 7, 16, 7, 80, 7, 48, 7, 112, 7, 8, 7, 72, 7, 40, 7, 104, 7, 24, 7, 88, 7, 56, 7, 120, 7, 4, 7, 68, 7, 36, 7, 100, 7, 20, 7, 84, 7, 52, 7, 116, 7, 3, 8, 131, 8, 67, 8, 195, 8, 35, 8, 163, 8, 99, 8, 227, 8};
    static final short[] static_dtree = new short[]{0, 5, 16, 5, 8, 5, 24, 5, 4, 5, 20, 5, 12, 5, 28, 5, 2, 5, 18, 5, 10, 5, 26, 5, 6, 5, 22, 5, 14, 5, 30, 5, 1, 5, 17, 5, 9, 5, 25, 5, 5, 5, 21, 5, 13, 5, 29, 5, 3, 5, 19, 5, 11, 5, 27, 5, 7, 5, 23, 5};
    static final StaticTree static_l_desc = new StaticTree(static_ltree, extra_lbits, 257, 286, 15);
    static final StaticTree static_d_desc = new StaticTree(static_dtree, extra_dbits, 0, 30, 15);
    static final StaticTree static_bl_desc = new StaticTree(null, extra_blbits, 0, 19, 7);

    public Deflate(Encoder<?, O> input, int wrap, int level, int windowBits, int memLevel, int strategy) {
        this.input = input;
        this.l_desc = new Tree();
        this.d_desc = new Tree();
        this.bl_desc = new Tree();
        this.deflateInit(wrap, level, windowBits, memLevel, strategy);
    }

    public Deflate(Encoder<?, O> input, int wrap, int level, int windowBits, int memlevel) {
        this(input, wrap, level, windowBits, memlevel, 0);
    }

    public Deflate(Encoder<?, O> input, int wrap, int level, int windowBits) {
        this(input, wrap, level, windowBits, 8, 0);
    }

    public Deflate(Encoder<?, O> input, int wrap, int level) {
        this(input, wrap, level, 15, 8, 0);
    }

    public Deflate(Encoder<?, O> input, int wrap) {
        this(input, wrap, -1, 15, 8, 0);
    }

    public Deflate(Encoder<?, O> input) {
        this(input, 0, -1, 15, 8, 0);
    }

    public Deflate(int wrap, int level, int windowBits, int memLevel, int strategy) {
        this(null, wrap, level, windowBits, memLevel, strategy);
    }

    public Deflate(int wrap, int level, int windowBits, int memlevel) {
        this(null, wrap, level, windowBits, memlevel, 0);
    }

    public Deflate(int wrap, int level, int windowBits) {
        this(null, wrap, level, windowBits, 8, 0);
    }

    public Deflate(int wrap, int level) {
        this(null, wrap, level, 15, 8, 0);
    }

    public Deflate(int wrap) {
        this(null, wrap, -1, 15, 8, 0);
    }

    public Deflate() {
        this(null, 0, -1, 15, 8, 0);
    }

    Deflate(Deflate<O> from) {
        this.input = from.input;
        this.flush = from.flush;
        this.total_in = from.total_in;
        this.next_out = from.next_out;
        this.next_out_index = from.next_out_index;
        this.avail_out = from.avail_out;
        this.total_out = from.total_out;
        this.data_type = from.data_type;
        this.adler = from.adler;
        this.status = from.status;
        this.pending_buf = this.pending_buf;
        this.pending_out = from.pending_out;
        this.pending = from.pending;
        this.wrap = from.wrap;
        if (this.gzhead != null) {
            this.gzhead = from.gzhead.clone();
        }
        this.gzindex = from.gzindex;
        this.last_flush = from.last_flush;
        this.w_size = from.w_size;
        this.w_bits = from.w_bits;
        this.w_mask = from.w_mask;
        if (from.window != null) {
            this.window = new byte[from.window.length];
            System.arraycopy(from.window, 0, this.window, 0, this.window.length);
            this.window_buffer = Binary.outputBuffer((byte[])this.window);
        }
        this.window_size = from.window_size;
        if (from.prev != null) {
            this.prev = new short[from.prev.length];
            System.arraycopy(from.prev, 0, this.prev, 0, this.prev.length);
        }
        if (from.head != null) {
            this.head = new short[from.head.length];
            System.arraycopy(from.head, 0, this.head, 0, this.head.length);
        }
        this.ins_h = from.ins_h;
        this.hash_size = from.hash_size;
        this.hash_bits = from.hash_bits;
        this.hash_mask = from.hash_mask;
        this.hash_shift = from.hash_shift;
        this.block_start = from.block_start;
        this.match_length = from.match_length;
        this.prev_match = from.prev_match;
        this.match_available = from.match_available;
        this.strstart = from.strstart;
        this.match_start = from.match_start;
        this.lookahead = from.lookahead;
        this.prev_length = from.prev_length;
        this.max_chain_length = from.max_chain_length;
        this.max_lazy_match = from.max_lazy_match;
        this.level = from.level;
        this.strategy = from.strategy;
        this.good_match = from.good_match;
        this.nice_match = from.nice_match;
        System.arraycopy(from.dyn_ltree, 0, this.dyn_ltree, 0, this.dyn_ltree.length);
        System.arraycopy(from.dyn_dtree, 0, this.dyn_dtree, 0, this.dyn_dtree.length);
        System.arraycopy(from.bl_tree, 0, this.bl_tree, 0, this.bl_tree.length);
        this.l_desc = from.l_desc.clone();
        this.d_desc = from.d_desc.clone();
        this.bl_desc = from.bl_desc.clone();
        System.arraycopy(from.bl_count, 0, this.bl_count, 0, this.bl_count.length);
        System.arraycopy(from.next_code, 0, this.next_code, 0, this.next_code.length);
        System.arraycopy(from.heap, 0, this.heap, 0, this.heap.length);
        this.heap_len = from.heap_len;
        this.heap_max = from.heap_max;
        System.arraycopy(from.depth, 0, this.depth, 0, this.depth.length);
        if (from.l_buf != null) {
            this.l_buf = new byte[from.l_buf.length];
            System.arraycopy(from.l_buf, 0, this.l_buf, 0, this.l_buf.length);
        }
        this.lit_bufsize = from.lit_bufsize;
        this.last_lit = from.last_lit;
        this.d_buf = from.d_buf;
        this.opt_len = from.opt_len;
        this.static_len = from.static_len;
        this.matches = from.matches;
        this.insert = from.insert;
        this.bi_buf = from.bi_buf;
        this.bi_valid = from.bi_valid;
    }

    protected void deflateInit(int wrap, int level, int windowBits, int memLevel, int strategy) {
        if (level == -1) {
            level = 6;
        }
        if (this.flush < 0 || this.flush > 5 || memLevel < 1 || memLevel > 9 || windowBits < 8 || windowBits > 15 || level < 0 || level > 9 || strategy < 0 || strategy > 4) {
            throw new DeflateException(-2);
        }
        if (windowBits == 8) {
            windowBits = 9;
        }
        this.wrap = wrap;
        this.gzhead = null;
        this.w_bits = windowBits;
        this.w_size = 1 << this.w_bits;
        this.w_mask = this.w_size - 1;
        this.hash_bits = memLevel + 7;
        this.hash_size = 1 << this.hash_bits;
        this.hash_mask = this.hash_size - 1;
        this.hash_shift = (this.hash_bits + 3 - 1) / 3;
        this.window = new byte[this.w_size * 2];
        this.window_buffer = Binary.outputBuffer((byte[])this.window);
        this.prev = new short[this.w_size];
        this.head = new short[this.hash_size];
        this.lit_bufsize = 1 << memLevel + 6;
        this.pending_buf = new byte[this.lit_bufsize * 3];
        this.d_buf = this.lit_bufsize;
        this.l_buf = new byte[this.lit_bufsize];
        this.level = level;
        this.strategy = strategy;
        this.deflateReset();
    }

    public void deflateResetKeep() {
        this.total_out = 0L;
        this.total_in = 0L;
        this.data_type = 2;
        this.pending = 0;
        this.pending_out = 0;
        if (this.wrap < 0) {
            this.wrap = -this.wrap;
        }
        int n = this.status = this.wrap != 0 ? 42 : 113;
        this.adler = this.wrap == 1 ? Adler32.adler32(0, null, 0, 0) : (this.wrap == 2 ? CRC32.crc32(0, null, 0, 0) : 0);
        this.last_flush = 0;
        this.tr_init();
    }

    public void deflateReset() {
        this.deflateResetKeep();
        this.lm_init();
    }

    public void deflateParams(int level, int strategy) {
        block6: {
            if (level == -1) {
                level = 6;
            }
            if (level < 0 || level > 9 || strategy < 0 || strategy > 4) {
                throw new DeflateException(-2);
            }
            if (strategy != this.strategy && Deflate.configuration_table[this.level].func != Deflate.configuration_table[level].func && this.total_in != 0L) {
                try {
                    this.deflate(1);
                }
                catch (DeflateException e) {
                    if (e.code() == -5 && this.pending == 0) break block6;
                    throw e;
                }
            }
        }
        if (this.level != level) {
            this.level = level;
            this.max_lazy_match = Deflate.configuration_table[level].max_lazy;
            this.good_match = Deflate.configuration_table[level].good_length;
            this.nice_match = Deflate.configuration_table[level].nice_length;
            this.max_chain_length = Deflate.configuration_table[level].max_chain;
        }
        this.strategy = strategy;
    }

    public Deflate<O> clone() {
        return new Deflate<O>(this);
    }

    public Deflate<O> flush(int flush) {
        if (flush < 0 || flush > 5) {
            throw new DeflateException(-2);
        }
        this.flush = flush;
        return this;
    }

    protected void flush_pending() {
        this.tr_flush_bits();
        int len = this.pending;
        if (len > this.avail_out) {
            len = this.avail_out;
        }
        if (len == 0) {
            return;
        }
        System.arraycopy(this.pending_buf, this.pending_out, this.next_out, this.next_out_index, len);
        this.next_out_index += len;
        this.pending_out += len;
        this.total_out += (long)len;
        this.avail_out -= len;
        this.pending -= len;
        if (this.pending == 0) {
            this.pending_out = 0;
        }
    }

    public Deflate<O> feed(Encoder<?, O> input) {
        this.input = input;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Encoder<Encoder<?, O>, O> pull(OutputBuffer<?> output) {
        this.next_out = output.array();
        this.next_out_index = output.arrayOffset() + output.index();
        this.avail_out = output.remaining();
        try {
            boolean needsMore = this.deflate(this.flush);
            output.index(this.next_out_index - output.arrayOffset());
            if (this.input.isDone() && !needsMore) {
                Encoder encoder = this.input.asDone();
                return encoder;
            }
            if (this.input.isError()) {
                Encoder encoder = this.input.asError();
                return encoder;
            }
            if (output.isDone()) {
                Encoder encoder = Deflate.error((Throwable)new EncoderException("truncated"));
                return encoder;
            }
            if (output.isError()) {
                Encoder encoder = Deflate.error((Throwable)output.trap());
                return encoder;
            }
            Deflate deflate = this;
            return deflate;
        }
        catch (DeflateException cause) {
            Encoder encoder = Deflate.error((Throwable)cause);
            return encoder;
        }
        finally {
            this.next_out = null;
            this.next_out_index = 0;
            this.avail_out = 0;
        }
    }

    public boolean deflate(int flush) {
        byte val;
        int beg;
        if (flush > 5 || flush < 0) {
            throw new DeflateException(-2);
        }
        if (this.next_out == null || this.status == 666 && flush != 4) {
            throw new DeflateException(-2);
        }
        if (this.avail_out == 0) {
            throw new DeflateException(-5);
        }
        int old_flush = this.last_flush;
        this.last_flush = flush;
        if (this.status == 42) {
            if (this.wrap == 2) {
                this.adler = CRC32.crc32(0, null, 0, 0);
                this.put_byte(31);
                this.put_byte(139);
                this.put_byte(8);
                if (this.gzhead == null) {
                    this.put_byte(0);
                    this.put_byte(0);
                    this.put_byte(0);
                    this.put_byte(0);
                    this.put_byte(0);
                    this.put_byte(this.level == 9 ? 2 : (this.strategy >= 2 || this.level < 2 ? 4 : 0));
                    this.put_byte(255);
                    this.status = 113;
                } else {
                    this.put_byte((this.gzhead.text ? 1 : 0) + (this.gzhead.hcrc ? 2 : 0) + (this.gzhead.extra == null ? 0 : 4) + (this.gzhead.name == null ? 0 : 8) + (this.gzhead.comment == null ? 0 : 16));
                    this.put_byte(this.gzhead.time);
                    this.put_byte(this.gzhead.time >> 8);
                    this.put_byte(this.gzhead.time >> 16);
                    this.put_byte(this.gzhead.time >> 24);
                    this.put_byte(this.level == 9 ? 2 : (this.strategy >= 2 || this.level < 2 ? 4 : 0));
                    this.put_byte(this.gzhead.os);
                    if (this.gzhead.extra != null) {
                        this.put_byte(this.gzhead.extra_len);
                        this.put_byte(this.gzhead.extra_len >> 8);
                    }
                    if (this.gzhead.hcrc) {
                        this.adler = CRC32.crc32(this.adler, this.pending_buf, this.pending_out, this.pending);
                    }
                    this.gzindex = 0;
                    this.status = 69;
                }
            } else {
                int header = 8 + (this.w_bits - 8 << 4) << 8;
                int level_flags = this.strategy >= 2 || this.level < 2 ? 0 : (this.level < 6 ? 1 : (this.level == 6 ? 2 : 3));
                header |= level_flags << 6;
                if (this.strstart != 0) {
                    header |= 0x20;
                }
                header += 31 - header % 31;
                this.status = 113;
                this.putShortMSB(header);
                if (this.strstart != 0) {
                    this.putShortMSB(this.adler >>> 16);
                    this.putShortMSB(this.adler & 0xFFFF);
                }
                this.adler = Adler32.adler32(0, null, 0, 0);
            }
        }
        if (this.status == 69) {
            if (this.gzhead.extra != null) {
                beg = this.pending;
                while (this.gzindex < (this.gzhead.extra_len & 0xFFFF)) {
                    if (this.pending == this.pending_buf.length) {
                        if (this.gzhead.hcrc && this.pending > beg) {
                            this.adler = CRC32.crc32(this.adler, this.pending_buf, beg, this.pending - beg);
                        }
                        this.flush_pending();
                        beg = this.pending;
                        if (this.pending == this.pending_buf.length) break;
                    }
                    this.put_byte(this.gzhead.extra[this.gzindex]);
                    ++this.gzindex;
                }
                if (this.gzhead.hcrc && this.pending > beg) {
                    this.adler = CRC32.crc32(this.adler, this.pending_buf, beg, this.pending - beg);
                }
                if (this.gzindex == this.gzhead.extra_len) {
                    this.gzindex = 0;
                    this.status = 73;
                }
            } else {
                this.status = 73;
            }
        }
        if (this.status == 73) {
            if (this.gzhead.name != null) {
                beg = this.pending;
                do {
                    if (this.pending == this.pending_buf.length) {
                        if (this.gzhead.hcrc && this.pending > beg) {
                            this.adler = CRC32.crc32(this.adler, this.pending_buf, beg, this.pending - beg);
                        }
                        this.flush_pending();
                        beg = this.pending;
                        if (this.pending == this.pending_buf.length) {
                            val = 1;
                            break;
                        }
                    }
                    val = this.gzhead.name[this.gzindex++];
                    this.put_byte(val);
                } while (val != 0);
                if (this.gzhead.hcrc && this.pending > beg) {
                    this.adler = CRC32.crc32(this.adler, this.pending_buf, beg, this.pending - beg);
                }
                if (val == 0) {
                    this.gzindex = 0;
                    this.status = 91;
                }
            } else {
                this.status = 91;
            }
        }
        if (this.status == 91) {
            if (this.gzhead.comment != null) {
                beg = this.pending;
                do {
                    if (this.pending == this.pending_buf.length) {
                        if (this.gzhead.hcrc && this.pending > beg) {
                            this.adler = CRC32.crc32(this.adler, this.pending_buf, beg, this.pending - beg);
                        }
                        this.flush_pending();
                        beg = this.pending;
                        if (this.pending == this.pending_buf.length) {
                            val = 1;
                            break;
                        }
                    }
                    val = this.gzhead.comment[this.gzindex++];
                    this.put_byte(val);
                } while (val != 0);
                if (this.gzhead.hcrc && this.pending > beg) {
                    this.adler = CRC32.crc32(this.adler, this.pending_buf, beg, this.pending - beg);
                }
                if (val == 0) {
                    this.status = 103;
                }
            } else {
                this.status = 103;
            }
        }
        if (this.status == 103) {
            if (this.gzhead.hcrc) {
                if (this.pending + 2 > this.pending_buf.length) {
                    this.flush_pending();
                }
                if (this.pending + 2 <= this.pending_buf.length) {
                    this.put_byte(this.adler);
                    this.put_byte(this.adler >>> 8);
                    this.adler = CRC32.crc32(0, null, 0, 0);
                    this.status = 113;
                }
            } else {
                this.status = 113;
            }
        }
        if (this.pending != 0) {
            this.flush_pending();
            if (this.avail_out == 0) {
                this.last_flush = -1;
                return true;
            }
        } else if (this.input.isDone() && flush <= old_flush && flush != 4) {
            throw new DeflateException(-5);
        }
        if (this.status == 666 && !this.input.isDone()) {
            throw new DeflateException(-5);
        }
        if (!this.input.isDone() || this.lookahead != 0 || flush != 0 && this.status != 666) {
            int bstate;
            switch (Deflate.configuration_table[this.level].func) {
                case 0: {
                    bstate = this.deflate_stored(flush);
                    break;
                }
                case 1: {
                    bstate = this.deflate_fast(flush);
                    break;
                }
                case 2: {
                    bstate = this.deflate_slow(flush);
                    break;
                }
                default: {
                    bstate = -1;
                }
            }
            if (bstate == 2 || bstate == 3) {
                this.status = 666;
            }
            if (bstate == 0 || bstate == 2) {
                if (this.avail_out == 0) {
                    this.last_flush = -1;
                }
                return true;
            }
            if (bstate == 1) {
                if (flush == 1) {
                    this.tr_align();
                } else if (flush != 5) {
                    this.tr_stored_block(0, 0, false);
                    if (flush == 3) {
                        for (int i = 0; i < this.hash_size; ++i) {
                            this.head[i] = 0;
                        }
                        if (this.lookahead == 0) {
                            this.strstart = 0;
                            this.block_start = 0;
                            this.insert = 0;
                        }
                    }
                }
                this.flush_pending();
                if (this.avail_out == 0) {
                    this.last_flush = -1;
                    return false;
                }
            }
        }
        assert (this.avail_out > 0) : "bug2";
        if (this.wrap <= 0) {
            return false;
        }
        if (flush != 4) {
            return true;
        }
        if (this.wrap == 2) {
            this.put_byte(this.adler);
            this.put_byte(this.adler >>> 8);
            this.put_byte(this.adler >>> 16);
            this.put_byte(this.adler >>> 24);
            this.put_byte((int)this.total_in);
            this.put_byte((int)this.total_in >>> 8);
            this.put_byte((int)this.total_in >>> 16);
            this.put_byte((int)this.total_in >>> 24);
        } else {
            this.putShortMSB(this.adler >>> 16);
            this.putShortMSB(this.adler & 0xFFFF);
        }
        this.flush_pending();
        if (this.wrap > 0) {
            this.wrap = -this.wrap;
        }
        return false;
    }

    protected void deflateEnd() {
        if (this.status != 42 && this.status != 113 && this.status != 666) {
            throw new DeflateException(-2);
        }
        this.pending_buf = null;
        this.l_buf = null;
        this.head = null;
        this.prev = null;
        this.window = null;
        this.window_buffer = null;
        if (this.status == 113) {
            throw new DeflateException(-3);
        }
    }

    protected int read_buf(byte[] buf, int start, int size) {
        this.window_buffer.index(start).limit(start + size).isPart(true);
        this.input = this.input.pull(this.window_buffer);
        int len = this.window_buffer.index() - start;
        if (len == 0) {
            return 0;
        }
        if (this.wrap == 1) {
            this.adler = Adler32.adler32(this.adler, buf, start, len);
        } else if (this.wrap == 2) {
            this.adler = CRC32.crc32(this.adler, buf, start, len);
        }
        this.total_in += (long)len;
        return len;
    }

    final void lm_init() {
        this.window_size = 2 * this.w_size;
        for (int i = 0; i < this.hash_size; ++i) {
            this.head[i] = 0;
        }
        this.max_lazy_match = Deflate.configuration_table[this.level].max_lazy;
        this.good_match = Deflate.configuration_table[this.level].good_length;
        this.nice_match = Deflate.configuration_table[this.level].nice_length;
        this.max_chain_length = Deflate.configuration_table[this.level].max_chain;
        this.strstart = 0;
        this.block_start = 0;
        this.lookahead = 0;
        this.prev_length = 2;
        this.match_length = 2;
        this.match_available = 0;
        this.ins_h = 0;
    }

    final int longest_match(int cur_match) {
        int chain_length = this.max_chain_length;
        int scan = this.strstart;
        int best_len = this.prev_length;
        int nice_match = this.nice_match;
        int limit = this.strstart > this.w_size - 262 ? this.strstart - (this.w_size - 262) : 0;
        int strend = this.strstart + 258;
        byte scan_end1 = this.window[scan + best_len - 1];
        byte scan_end = this.window[scan + best_len];
        assert (this.hash_bits >= 8) : "Code too clever";
        if (this.prev_length >= this.good_match) {
            chain_length >>>= 2;
        }
        if (nice_match > this.lookahead) {
            nice_match = this.lookahead;
        }
        assert (this.strstart <= this.window_size - 262) : "need lookahead";
        do {
            assert (cur_match < this.strstart) : "no future";
            int match = cur_match;
            if (this.window[match + best_len] != scan_end || this.window[match + best_len - 1] != scan_end1 || this.window[match] != this.window[scan] || this.window[++match] != this.window[scan + 1]) continue;
            assert (this.window[scan += 2] == this.window[++match]) : "match[2]?";
            while (this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && scan < strend) {
            }
            assert (scan <= this.window_size - 1) : "wild scan";
            int len = 258 - (strend - scan);
            scan = strend - 258;
            if (len <= best_len) continue;
            this.match_start = cur_match;
            best_len = len;
            if (len >= nice_match) break;
            scan_end1 = this.window[scan + best_len - 1];
            scan_end = this.window[scan + best_len];
        } while ((cur_match = this.prev[cur_match & this.w_mask] & 0xFFFF) > limit && --chain_length != 0);
        if (best_len <= this.lookahead) {
            return best_len;
        }
        return this.lookahead;
    }

    protected void fill_window() {
        assert (this.lookahead < 262) : "already enough lookahead";
        do {
            int n;
            int more = this.window_size - this.lookahead - this.strstart;
            if (this.strstart >= this.w_size + (this.w_size - 262)) {
                int m;
                System.arraycopy(this.window, this.w_size, this.window, 0, this.w_size);
                this.match_start -= this.w_size;
                this.strstart -= this.w_size;
                this.block_start -= this.w_size;
                int p = n = this.hash_size;
                do {
                    short s = this.head[p] = (m = this.head[--p] & 0xFFFF) >= this.w_size ? (short)(m - this.w_size) : (short)0;
                } while (--n != 0);
                p = n = this.w_size;
                do {
                    short s = this.prev[p] = (m = this.prev[--p] & 0xFFFF) >= this.w_size ? (short)(m - this.w_size) : (short)0;
                } while (--n != 0);
                more += this.w_size;
            }
            if (this.input.isDone()) break;
            assert (more >= 2) : "more < 2";
            n = this.read_buf(this.window, this.strstart + this.lookahead, more);
            if (n == 0) break;
            this.lookahead += n;
            if (this.lookahead + this.insert < 3) continue;
            int str = this.strstart - this.insert;
            this.ins_h = this.window[str] & 0xFF;
            this.ins_h = (this.ins_h << this.hash_shift ^ this.window[str + 1] & 0xFF) & this.hash_mask;
            while (this.insert != 0) {
                this.ins_h = (this.ins_h << this.hash_shift ^ this.window[str + 2] & 0xFF) & this.hash_mask;
                this.prev[str & this.w_mask] = this.head[this.ins_h];
                this.head[this.ins_h] = (short)str;
                ++str;
                --this.insert;
                if (this.lookahead + this.insert >= 3) continue;
            }
        } while (this.lookahead < 262 && !this.input.isDone());
        assert (this.strstart <= this.window_size - 262) : "not enough room for search";
    }

    final void flush_block_only(boolean eof) {
        this.tr_flush_block(this.block_start >= 0 ? this.block_start : -1, this.strstart - this.block_start, eof);
        this.block_start = this.strstart;
        this.flush_pending();
    }

    protected int deflate_stored(int flush) {
        block12: {
            int max_block_size = 65535;
            if (max_block_size > this.pending_buf.length - 5) {
                max_block_size = this.pending_buf.length - 5;
            }
            while (true) {
                if (this.lookahead <= 1) {
                    assert (this.strstart < this.w_size + (this.w_size - 262) || this.block_start >= this.w_size) : "slide too late";
                    this.fill_window();
                    if (this.lookahead == 0 && flush == 0) {
                        return 0;
                    }
                    if (this.lookahead == 0) break block12;
                }
                assert (this.block_start >= 0) : "block gone";
                this.strstart += this.lookahead;
                this.lookahead = 0;
                int max_start = this.block_start + max_block_size;
                if (this.strstart == 0 || this.strstart >= max_start) {
                    this.lookahead = this.strstart - max_start;
                    this.strstart = max_start;
                    this.flush_block_only(false);
                    if (this.avail_out == 0) {
                        return 0;
                    }
                }
                if (this.strstart - this.block_start < this.w_size - 262) continue;
                this.flush_block_only(false);
                if (this.avail_out == 0) break;
            }
            return 0;
        }
        this.insert = 0;
        if (flush == 4) {
            this.flush_block_only(true);
            if (this.avail_out == 0) {
                return 0;
            }
            return 3;
        }
        if (this.strstart > this.block_start) {
            this.flush_block_only(false);
            if (this.avail_out == 0) {
                return 0;
            }
        }
        return 1;
    }

    protected int deflate_fast(int flush) {
        block14: {
            while (true) {
                boolean bflush;
                if (this.lookahead < 262) {
                    this.fill_window();
                    if (this.lookahead < 262 && flush == 0) {
                        return 0;
                    }
                    if (this.lookahead == 0) break block14;
                }
                int hash_head = 0;
                if (this.lookahead >= 3) {
                    this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 2] & 0xFF) & this.hash_mask;
                    this.prev[this.strstart & this.w_mask] = this.head[this.ins_h];
                    hash_head = this.head[this.ins_h] & 0xFFFF;
                    this.head[this.ins_h] = (short)this.strstart;
                }
                if (hash_head != 0 && (this.strstart - hash_head & 0xFFFF) <= this.w_size - 262) {
                    this.match_length = this.longest_match(hash_head);
                }
                if (this.match_length >= 3) {
                    bflush = this.tr_tally(this.strstart - this.match_start, this.match_length - 3);
                    this.lookahead -= this.match_length;
                    if (this.match_length <= this.max_lazy_match && this.lookahead >= 3) {
                        --this.match_length;
                        do {
                            ++this.strstart;
                            this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 2] & 0xFF) & this.hash_mask;
                            this.prev[this.strstart & this.w_mask] = this.head[this.ins_h];
                            hash_head = this.head[this.ins_h] & 0xFFFF;
                            this.head[this.ins_h] = (short)this.strstart;
                        } while (--this.match_length != 0);
                        ++this.strstart;
                    } else {
                        this.strstart += this.match_length;
                        this.match_length = 0;
                        this.ins_h = this.window[this.strstart] & 0xFF;
                        this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 1] & 0xFF) & this.hash_mask;
                    }
                } else {
                    bflush = this.tr_tally(0, this.window[this.strstart] & 0xFF);
                    --this.lookahead;
                    ++this.strstart;
                }
                if (!bflush) continue;
                this.flush_block_only(false);
                if (this.avail_out == 0) break;
            }
            return 0;
        }
        int n = this.insert = this.strstart < 2 ? this.strstart : 2;
        if (flush == 4) {
            this.flush_block_only(true);
            if (this.avail_out == 0) {
                return 0;
            }
            return 3;
        }
        if (this.last_lit != 0) {
            this.flush_block_only(false);
            if (this.avail_out == 0) {
                return 0;
            }
        }
        return 1;
    }

    protected int deflate_slow(int flush) {
        boolean bflush;
        while (true) {
            if (this.lookahead < 262) {
                this.fill_window();
                if (this.lookahead < 262 && flush == 0) {
                    return 0;
                }
                if (this.lookahead == 0) break;
            }
            int hash_head = 0;
            if (this.lookahead >= 3) {
                this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 2] & 0xFF) & this.hash_mask;
                this.prev[this.strstart & this.w_mask] = this.head[this.ins_h];
                hash_head = this.head[this.ins_h] & 0xFFFF;
                this.head[this.ins_h] = (short)this.strstart;
            }
            this.prev_length = this.match_length;
            this.prev_match = this.match_start;
            this.match_length = 2;
            if (hash_head != 0 && this.prev_length < this.max_lazy_match && (this.strstart - hash_head & 0xFFFF) <= this.w_size - 262) {
                this.match_length = this.longest_match(hash_head);
                if (this.match_length <= 5 && (this.strategy == 1 || this.match_length == 3 && this.strstart - this.match_start > 4096)) {
                    this.match_length = 2;
                }
            }
            if (this.prev_length >= 3 && this.match_length <= this.prev_length) {
                int max_insert = this.strstart + this.lookahead - 3;
                bflush = this.tr_tally(this.strstart - 1 - this.prev_match, this.prev_length - 3);
                this.lookahead -= this.prev_length - 1;
                this.prev_length -= 2;
                do {
                    if (++this.strstart > max_insert) continue;
                    this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 2] & 0xFF) & this.hash_mask;
                    this.prev[this.strstart & this.w_mask] = this.head[this.ins_h];
                    hash_head = this.head[this.ins_h] & 0xFFFF;
                    this.head[this.ins_h] = (short)this.strstart;
                } while (--this.prev_length != 0);
                this.match_available = 0;
                this.match_length = 2;
                ++this.strstart;
                if (!bflush) continue;
                this.flush_block_only(false);
                if (this.avail_out != 0) continue;
                return 0;
            }
            if (this.match_available != 0) {
                bflush = this.tr_tally(0, this.window[this.strstart - 1] & 0xFF);
                if (bflush) {
                    this.flush_block_only(false);
                }
                ++this.strstart;
                --this.lookahead;
                if (this.avail_out != 0) continue;
                return 0;
            }
            this.match_available = 1;
            ++this.strstart;
            --this.lookahead;
        }
        assert (flush != 0) : "no flush?";
        if (this.match_available != 0) {
            bflush = this.tr_tally(0, this.window[this.strstart - 1] & 0xFF);
            this.match_available = 0;
        }
        int n = this.insert = this.strstart < 2 ? this.strstart : 2;
        if (flush == 4) {
            this.flush_block_only(true);
            if (this.avail_out == 0) {
                return 0;
            }
            return 3;
        }
        if (this.last_lit != 0) {
            this.flush_block_only(false);
            if (this.avail_out == 0) {
                return 0;
            }
        }
        return 1;
    }

    protected int deflate_rle(int flush) {
        block14: {
            while (true) {
                boolean bflush;
                if (this.lookahead <= 258) {
                    this.fill_window();
                    if (this.lookahead <= 258 && flush == 0) {
                        return 0;
                    }
                    if (this.lookahead == 0) break block14;
                }
                this.match_length = 0;
                if (this.lookahead >= 3 && this.strstart > 0) {
                    int scan = this.strstart - 1;
                    int prev = this.window[scan] & 0xFF;
                    if (prev == (this.window[++scan] & 0xFF) && prev == (this.window[++scan] & 0xFF) && prev == (this.window[++scan] & 0xFF)) {
                        int strend = this.strstart + 258;
                        while (prev == (this.window[++scan] & 0xFF) && prev == (this.window[++scan] & 0xFF) && prev == (this.window[++scan] & 0xFF) && prev == (this.window[++scan] & 0xFF) && prev == (this.window[++scan] & 0xFF) && prev == (this.window[++scan] & 0xFF) && prev == (this.window[++scan] & 0xFF) && prev == (this.window[++scan] & 0xFF) && scan < strend) {
                        }
                        this.match_length = 258 - (strend - scan);
                        if (this.match_length > this.lookahead) {
                            this.match_length = this.lookahead;
                        }
                    }
                    assert (scan <= this.window_size - 1) : "wild scan";
                }
                if (this.match_length >= 3) {
                    bflush = this.tr_tally(1, this.match_length - 3);
                    this.lookahead -= this.match_length;
                    this.strstart += this.match_length;
                    this.match_length = 0;
                } else {
                    bflush = this.tr_tally(0, this.window[this.strstart] & 0xFF);
                    --this.lookahead;
                    ++this.strstart;
                }
                if (!bflush) continue;
                this.flush_block_only(false);
                if (this.avail_out == 0) break;
            }
            return 0;
        }
        this.insert = 0;
        if (flush == 4) {
            this.flush_block_only(true);
            if (this.avail_out == 0) {
                return 0;
            }
            return 3;
        }
        if (this.last_lit != 0) {
            this.flush_block_only(false);
            if (this.avail_out == 0) {
                return 0;
            }
        }
        return 1;
    }

    protected int deflate_huff(int flush) {
        block8: {
            while (true) {
                if (this.lookahead == 0) {
                    this.fill_window();
                    if (this.lookahead == 0) {
                        if (flush == 0) {
                            return 0;
                        }
                        break block8;
                    }
                }
                this.match_length = 0;
                boolean bflush = this.tr_tally(0, this.window[this.strstart] & 0xFF);
                --this.lookahead;
                ++this.strstart;
                if (!bflush) continue;
                this.flush_block_only(false);
                if (this.avail_out == 0) break;
            }
            return 0;
        }
        this.insert = 0;
        if (flush == 4) {
            this.flush_block_only(true);
            if (this.avail_out == 0) {
                return 0;
            }
            return 3;
        }
        if (this.last_lit != 0) {
            this.flush_block_only(false);
            if (this.avail_out == 0) {
                return 0;
            }
        }
        return 1;
    }

    final void send_bits(int value, int length) {
        if (this.bi_valid > 16 - length) {
            this.bi_buf = (short)(this.bi_buf | value << this.bi_valid & 0xFFFF);
            this.put_short(this.bi_buf);
            this.bi_buf = (short)(value >>> 16 - this.bi_valid);
            this.bi_valid += length - 16;
        } else {
            this.bi_buf = (short)(this.bi_buf | value << this.bi_valid & 0xFFFF);
            this.bi_valid += length;
        }
    }

    final void tr_init() {
        this.l_desc.dyn_tree = this.dyn_ltree;
        this.l_desc.stat_desc = static_l_desc;
        this.d_desc.dyn_tree = this.dyn_dtree;
        this.d_desc.stat_desc = static_d_desc;
        this.bl_desc.dyn_tree = this.bl_tree;
        this.bl_desc.stat_desc = static_bl_desc;
        this.bi_buf = 0;
        this.bi_valid = 0;
        this.init_block();
    }

    final void init_block() {
        int n;
        for (n = 0; n < 286; ++n) {
            this.dyn_ltree[n * 2] = 0;
        }
        for (n = 0; n < 30; ++n) {
            this.dyn_dtree[n * 2] = 0;
        }
        for (n = 0; n < 19; ++n) {
            this.bl_tree[n * 2] = 0;
        }
        this.dyn_ltree[512] = 1;
        this.static_len = 0;
        this.opt_len = 0;
        this.matches = 0;
        this.last_lit = 0;
    }

    static boolean smaller(short[] tree, int n, int m, byte[] depth) {
        short nFreq = tree[n * 2];
        short mFreq = tree[m * 2];
        return nFreq < mFreq || nFreq == mFreq && depth[n] <= depth[m];
    }

    final void pqdownheap(short[] tree, int k) {
        int v = this.heap[k];
        for (int j = k << 1; j <= this.heap_len; j <<= 1) {
            if (j < this.heap_len && Deflate.smaller(tree, this.heap[j + 1], this.heap[j], this.depth)) {
                ++j;
            }
            if (Deflate.smaller(tree, v, this.heap[j], this.depth)) break;
            this.heap[k] = this.heap[j];
            k = j;
        }
        this.heap[k] = v;
    }

    final void scan_tree(short[] tree, int max_code) {
        short prevlen = -1;
        short nextlen = tree[1];
        int count = 0;
        int max_count = 7;
        int min_count = 4;
        if (nextlen == 0) {
            max_count = 138;
            min_count = 3;
        }
        tree[(max_code + 1) * 2 + 1] = -1;
        for (int n = 0; n <= max_code; ++n) {
            short curlen = nextlen;
            nextlen = tree[(n + 1) * 2 + 1];
            if (++count < max_count && curlen == nextlen) continue;
            if (count < min_count) {
                int n2 = curlen * 2;
                this.bl_tree[n2] = (short)(this.bl_tree[n2] + count);
            } else if (curlen != 0) {
                if (curlen != prevlen) {
                    int n3 = curlen * 2;
                    this.bl_tree[n3] = (short)(this.bl_tree[n3] + 1);
                }
                this.bl_tree[32] = (short)(this.bl_tree[32] + 1);
            } else if (count <= 10) {
                this.bl_tree[34] = (short)(this.bl_tree[34] + 1);
            } else {
                this.bl_tree[36] = (short)(this.bl_tree[36] + 1);
            }
            count = 0;
            prevlen = curlen;
            if (nextlen == 0) {
                max_count = 138;
                min_count = 3;
                continue;
            }
            if (curlen == nextlen) {
                max_count = 6;
                min_count = 3;
                continue;
            }
            max_count = 7;
            min_count = 4;
        }
    }

    final void send_tree(short[] tree, int max_code) {
        short prevlen = -1;
        short nextlen = tree[1];
        int count = 0;
        int max_count = 7;
        int min_count = 4;
        if (nextlen == 0) {
            max_count = 138;
            min_count = 3;
        }
        for (int n = 0; n <= max_code; ++n) {
            short curlen = nextlen;
            nextlen = tree[(n + 1) * 2 + 1];
            if (++count < max_count && curlen == nextlen) continue;
            if (count < min_count) {
                do {
                    this.send_code(curlen, this.bl_tree);
                } while (--count != 0);
            } else if (curlen != 0) {
                if (curlen != prevlen) {
                    this.send_code(curlen, this.bl_tree);
                    --count;
                }
                assert (count >= 3 && count <= 6) : "3_6?";
                this.send_code(16, this.bl_tree);
                this.send_bits(count - 3, 2);
            } else if (count <= 10) {
                this.send_code(17, this.bl_tree);
                this.send_bits(count - 3, 3);
            } else {
                this.send_code(18, this.bl_tree);
                this.send_bits(count - 11, 7);
            }
            count = 0;
            prevlen = curlen;
            if (nextlen == 0) {
                max_count = 138;
                min_count = 3;
                continue;
            }
            if (curlen == nextlen) {
                max_count = 6;
                min_count = 3;
                continue;
            }
            max_count = 7;
            min_count = 4;
        }
    }

    final int build_bl_tree() {
        int max_blindex;
        this.scan_tree(this.dyn_ltree, this.l_desc.max_code);
        this.scan_tree(this.dyn_dtree, this.d_desc.max_code);
        this.bl_desc.build_tree(this);
        for (max_blindex = 18; max_blindex >= 3 && this.bl_tree[bl_order[max_blindex] * 2 + 1] == 0; --max_blindex) {
        }
        this.opt_len += 3 * (max_blindex + 1) + 5 + 5 + 4;
        return max_blindex;
    }

    final void send_all_trees(int lcodes, int dcodes, int blcodes) {
        assert (lcodes >= 257 && dcodes >= 1 && blcodes >= 4) : "not enough codes";
        assert (lcodes <= 286 && dcodes <= 30 && blcodes <= 19) : "too many codes";
        this.send_bits(lcodes - 257, 5);
        this.send_bits(dcodes - 1, 5);
        this.send_bits(blcodes - 4, 4);
        for (int rank = 0; rank < blcodes; ++rank) {
            this.send_bits(this.bl_tree[bl_order[rank] * 2 + 1], 3);
        }
        this.send_tree(this.dyn_ltree, lcodes - 1);
        this.send_tree(this.dyn_dtree, dcodes - 1);
    }

    final void tr_stored_block(int buf, int stored_len, boolean eof) {
        this.send_bits(0 + (eof ? 1 : 0), 3);
        this.copy_block(buf, stored_len, true);
    }

    final void tr_flush_bits() {
        this.bi_flush();
    }

    final void tr_align() {
        this.send_bits(2, 3);
        this.send_code(256, static_ltree);
        this.bi_flush();
    }

    final void tr_flush_block(int buf, int stored_len, boolean eof) {
        int static_lenb;
        int opt_lenb;
        int max_blindex = 0;
        if (this.level > 0) {
            if (this.data_type == 2) {
                this.data_type = this.detect_data_type();
            }
            this.l_desc.build_tree(this);
            this.d_desc.build_tree(this);
            max_blindex = this.build_bl_tree();
            opt_lenb = this.opt_len + 3 + 7 >>> 3;
            static_lenb = this.static_len + 3 + 7 >>> 3;
            if (static_lenb <= opt_lenb) {
                opt_lenb = static_lenb;
            }
        } else {
            opt_lenb = static_lenb = stored_len + 5;
        }
        if (stored_len + 4 <= opt_lenb && buf != -1) {
            this.tr_stored_block(buf, stored_len, eof);
        } else if (this.strategy == 4 || static_lenb == opt_lenb) {
            this.send_bits(2 + (eof ? 1 : 0), 3);
            this.compress_block(static_ltree, static_dtree);
        } else {
            this.send_bits(4 + (eof ? 1 : 0), 3);
            this.send_all_trees(this.l_desc.max_code + 1, this.d_desc.max_code + 1, max_blindex + 1);
            this.compress_block(this.dyn_ltree, this.dyn_dtree);
        }
        this.init_block();
        if (eof) {
            this.bi_windup();
        }
    }

    final boolean tr_tally(int dist, int lc) {
        this.pending_buf[this.d_buf + this.last_lit * 2] = (byte)(dist >>> 8);
        this.pending_buf[this.d_buf + this.last_lit * 2 + 1] = (byte)dist;
        this.l_buf[this.last_lit++] = (byte)lc;
        if (dist == 0) {
            int n = lc * 2;
            this.dyn_ltree[n] = (short)(this.dyn_ltree[n] + 1);
        } else {
            ++this.matches;
            assert (--dist < this.w_size - 262 && lc <= 255 && Deflate.d_code(dist) < 30) : "tr_tally: bad match";
            int n = (length_code[lc] + 256 + 1) * 2;
            this.dyn_ltree[n] = (short)(this.dyn_ltree[n] + 1);
            int n2 = Deflate.d_code(dist) * 2;
            this.dyn_dtree[n2] = (short)(this.dyn_dtree[n2] + 1);
        }
        return this.last_lit == this.lit_bufsize - 1;
    }

    final void compress_block(short[] ltree, short[] dtree) {
        int lx = 0;
        if (this.last_lit != 0) {
            do {
                int dist = (this.pending_buf[this.d_buf + lx * 2] & 0xFF) << 8 | this.pending_buf[this.d_buf + lx * 2 + 1] & 0xFF;
                int lc = this.l_buf[lx++] & 0xFF;
                if (dist == 0) {
                    this.send_code(lc, ltree);
                } else {
                    int code = length_code[lc];
                    this.send_code(code + 256 + 1, ltree);
                    int extra = extra_lbits[code];
                    if (extra != 0) {
                        this.send_bits(lc -= base_length[code], extra);
                    }
                    code = Deflate.d_code(--dist);
                    assert (code < 30) : "bad d_code";
                    this.send_code(code, dtree);
                    extra = extra_dbits[code];
                    if (extra != 0) {
                        this.send_bits(dist -= base_dist[code], extra);
                    }
                }
                assert (this.pending < this.lit_bufsize + 2 * lx) : "pendingBuf overflow";
            } while (lx < this.last_lit);
        }
        this.send_code(256, ltree);
    }

    final int detect_data_type() {
        int black_mask = -201342849;
        int n = 0;
        while (n <= 31) {
            if ((black_mask & 1) != 0 && this.dyn_ltree[n * 2] != 0) {
                return 0;
            }
            ++n;
            black_mask >>>= 1;
        }
        if (this.dyn_ltree[18] != 0 || this.dyn_ltree[20] != 0 || this.dyn_ltree[26] != 0) {
            return 1;
        }
        for (n = 32; n < 256; ++n) {
            if (this.dyn_ltree[n * 2] == 0) continue;
            return 1;
        }
        return 0;
    }

    static int bi_reverse(int code, int len) {
        int res = 0;
        do {
            res |= code & 1;
            code >>>= 1;
            res <<= 1;
        } while (--len > 0);
        return res >>> 1;
    }

    final void bi_flush() {
        if (this.bi_valid == 16) {
            this.put_short(this.bi_buf);
            this.bi_buf = 0;
            this.bi_valid = 0;
        } else if (this.bi_valid >= 8) {
            this.put_byte(this.bi_buf);
            this.bi_buf = (short)(this.bi_buf >>> 8);
            this.bi_valid -= 8;
        }
    }

    final void bi_windup() {
        if (this.bi_valid > 8) {
            this.put_short(this.bi_buf);
        } else if (this.bi_valid > 0) {
            this.put_byte(this.bi_buf);
        }
        this.bi_buf = 0;
        this.bi_valid = 0;
    }

    final void copy_block(int buf, int len, boolean header) {
        this.bi_windup();
        if (header) {
            this.put_short(len);
            this.put_short(~len);
        }
        System.arraycopy(this.window, buf, this.pending_buf, this.pending, len);
        this.pending += len;
    }

    final void send_code(int c, short[] tree) {
        int c2 = c * 2;
        this.send_bits(tree[c2] & 0xFFFF, tree[c2 + 1] & 0xFFFF);
    }

    final void putShortMSB(int w) {
        this.put_byte(w >>> 8);
        this.put_byte(w);
    }

    final void put_short(int w) {
        this.put_byte(w);
        this.put_byte(w >>> 8);
    }

    final void put_byte(int b) {
        this.pending_buf[this.pending++] = (byte)b;
    }

    static int d_code(int dist) {
        return dist < 256 ? dist_code[dist] : dist_code[256 + (dist >>> 7)];
    }

    static final class Config {
        final int good_length;
        final int max_lazy;
        final int nice_length;
        final int max_chain;
        final int func;

        Config(int good_length, int max_lazy, int nice_length, int max_chain, int func) {
            this.good_length = good_length;
            this.max_lazy = max_lazy;
            this.nice_length = nice_length;
            this.max_chain = max_chain;
            this.func = func;
        }
    }

    static final class StaticTree {
        final short[] static_tree;
        final int[] extra_bits;
        final int extra_base;
        final int elems;
        final int max_length;

        StaticTree(short[] static_tree, int[] extra_bits, int extra_base, int elems, int max_length) {
            this.static_tree = static_tree;
            this.extra_bits = extra_bits;
            this.extra_base = extra_base;
            this.elems = elems;
            this.max_length = max_length;
        }
    }

    static final class Tree
    implements Cloneable {
        short[] dyn_tree;
        int max_code;
        StaticTree stat_desc;

        Tree() {
        }

        Tree(Tree from) {
            if (from.dyn_tree != null) {
                this.dyn_tree = new short[from.dyn_tree.length];
                System.arraycopy(from.dyn_tree, 0, this.dyn_tree, 0, this.dyn_tree.length);
            }
            this.max_code = from.max_code;
            this.stat_desc = from.stat_desc;
        }

        public Tree clone() {
            return new Tree(this);
        }

        void gen_bitlen(Deflate<?> s) {
            int n;
            int h;
            int bits;
            short[] tree = this.dyn_tree;
            short[] stree = this.stat_desc.static_tree;
            int[] extra = this.stat_desc.extra_bits;
            int base = this.stat_desc.extra_base;
            int max_length = this.stat_desc.max_length;
            int overflow = 0;
            for (bits = 0; bits <= 15; ++bits) {
                s.bl_count[bits] = 0;
            }
            tree[s.heap[s.heap_max] * 2 + 1] = 0;
            for (h = s.heap_max + 1; h < 573; ++h) {
                n = s.heap[h];
                bits = tree[tree[n * 2 + 1] * 2 + 1] + 1;
                if (bits > max_length) {
                    bits = max_length;
                    ++overflow;
                }
                tree[n * 2 + 1] = (short)bits;
                if (n > this.max_code) continue;
                int n2 = bits;
                s.bl_count[n2] = (short)(s.bl_count[n2] + 1);
                int xbits = 0;
                if (n >= base) {
                    xbits = extra[n - base];
                }
                short f = tree[n * 2];
                s.opt_len += f * (bits + xbits);
                if (stree == null) continue;
                s.static_len += f * (stree[n * 2 + 1] + xbits);
            }
            if (overflow == 0) {
                return;
            }
            do {
                bits = max_length - 1;
                while (s.bl_count[bits] == 0) {
                    --bits;
                }
                int n3 = bits;
                s.bl_count[n3] = (short)(s.bl_count[n3] - 1);
                int n4 = bits + 1;
                s.bl_count[n4] = (short)(s.bl_count[n4] + 2);
                int n5 = max_length;
                s.bl_count[n5] = (short)(s.bl_count[n5] - 1);
            } while ((overflow -= 2) > 0);
            for (bits = max_length; bits != 0; --bits) {
                n = s.bl_count[bits];
                while (n != 0) {
                    int m;
                    if ((m = s.heap[--h]) > this.max_code) continue;
                    if (tree[m * 2 + 1] != bits) {
                        s.opt_len += (bits - tree[m * 2 + 1]) * tree[m * 2];
                        tree[m * 2 + 1] = (short)bits;
                    }
                    --n;
                }
            }
        }

        static void gen_codes(short[] tree, int max_code, short[] bl_count, short[] next_code) {
            short code = 0;
            next_code[0] = 0;
            for (int bits = 1; bits <= 15; ++bits) {
                next_code[bits] = code = (short)(code + bl_count[bits - 1] << 1);
            }
            assert ((code + bl_count[15] - 1 & 0xFFFF) == Short.MAX_VALUE) : "inconsistent bit counts";
            for (int n = 0; n <= max_code; ++n) {
                short len = tree[n * 2 + 1];
                if (len == 0) continue;
                short s = len;
                short s2 = next_code[s];
                next_code[s] = (short)(s2 + 1);
                tree[n * 2] = (short)Deflate.bi_reverse(s2, len);
            }
        }

        void build_tree(Deflate<?> s) {
            int node;
            int n;
            short[] tree = this.dyn_tree;
            short[] stree = this.stat_desc.static_tree;
            int elems = this.stat_desc.elems;
            int max_code = -1;
            s.heap_len = 0;
            s.heap_max = 573;
            for (n = 0; n < elems; ++n) {
                if (tree[n * 2] != 0) {
                    s.heap[++s.heap_len] = max_code = n;
                    s.depth[n] = 0;
                    continue;
                }
                tree[n * 2 + 1] = 0;
            }
            while (s.heap_len < 2) {
                int n2 = max_code < 2 ? ++max_code : 0;
                s.heap[++s.heap_len] = n2;
                node = n2;
                tree[node * 2] = 1;
                s.depth[node] = 0;
                --s.opt_len;
                if (stree == null) continue;
                s.static_len -= stree[node * 2 + 1];
            }
            this.max_code = max_code;
            for (n = s.heap_len / 2; n >= 1; --n) {
                s.pqdownheap(tree, n);
            }
            node = elems;
            do {
                n = s.heap[1];
                s.heap[1] = s.heap[s.heap_len--];
                s.pqdownheap(tree, 1);
                int m = s.heap[1];
                s.heap[--s.heap_max] = n;
                s.heap[--s.heap_max] = m;
                tree[node * 2] = (short)(tree[n * 2] + tree[m * 2]);
                s.depth[node] = (byte)(Math.max(s.depth[n], s.depth[m]) + 1);
                short s2 = (short)node;
                tree[m * 2 + 1] = s2;
                tree[n * 2 + 1] = s2;
                s.heap[1] = node++;
                s.pqdownheap(tree, 1);
            } while (s.heap_len >= 2);
            s.heap[--s.heap_max] = s.heap[1];
            this.gen_bitlen(s);
            Tree.gen_codes(tree, max_code, s.bl_count, s.next_code);
        }
    }
}

