/*
 * Decompiled with CFR 0.152.
 */
package swim.deflate;

import swim.codec.Binary;
import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.deflate.Adler32;
import swim.deflate.CRC32;
import swim.deflate.DeflateException;
import swim.deflate.GzHeader;

public class Inflate<O>
extends Decoder<O>
implements Cloneable {
    public Decoder<O> output;
    public boolean is_last;
    public int flush;
    public byte[] next_in;
    public int next_in_index;
    public int avail_in;
    public long total_in;
    public byte[] next_out;
    public int next_out_index;
    public int avail_out;
    public long total_out;
    int data_type;
    int adler;
    int mode;
    boolean last;
    int wrap;
    boolean havedict;
    int flags;
    int dmax;
    int check;
    long total;
    GzHeader head;
    int wbits;
    int wsize;
    public int whave;
    public int wnext;
    public byte[] window;
    public InputBuffer window_buffer;
    int hold;
    int bits;
    int length;
    int offset;
    int extra;
    int lencode;
    int distcode;
    int lenbits;
    int distbits;
    int ncode;
    int nlen;
    int ndist;
    int have;
    int next;
    short[] lens = new short[320];
    short[] work = new short[288];
    int[] codes = new int[1444];
    boolean sane;
    int back;
    int was;
    public static final int Z_NO_FLUSH = 0;
    public static final int Z_PARTIAL_FLUSH = 1;
    public static final int Z_SYNC_FLUSH = 2;
    public static final int Z_FULL_FLUSH = 3;
    public static final int Z_FINISH = 4;
    public static final int Z_BLOCK = 5;
    public static final int Z_TREES = 6;
    public static final int Z_OK = 0;
    public static final int Z_STREAM_END = 1;
    public static final int Z_NEED_DICT = 2;
    public static final int Z_ERRNO = -1;
    public static final int Z_STREAM_ERROR = -2;
    public static final int Z_DATA_ERROR = -3;
    public static final int Z_MEM_ERROR = -4;
    public static final int Z_BUF_ERROR = -5;
    public static final int Z_VERSION_ERROR = -6;
    public static final int Z_NO_WRAP = 0;
    public static final int Z_WRAP_ZLIB = 1;
    public static final int Z_WRAP_GZIP = 2;
    public static final int DEF_WBITS = 15;
    static final int Z_DEFLATED = 8;
    static final int ENOUGH_LENS = 852;
    static final int ENOUGH_DISTS = 592;
    static final int ENOUGH = 1444;
    static final int HEAD = 0;
    static final int FLAGS = 1;
    static final int TIME = 2;
    static final int OS = 3;
    static final int EXLEN = 4;
    static final int EXTRA = 5;
    static final int NAME = 6;
    static final int COMMENT = 7;
    static final int HCRC = 8;
    static final int DICTID = 9;
    static final int DICT = 10;
    static final int TYPE = 11;
    static final int TYPEDO = 12;
    static final int STORED = 13;
    static final int COPY_ = 14;
    static final int COPY = 15;
    static final int TABLE = 16;
    static final int LENLENS = 17;
    static final int CODELENS = 18;
    static final int LEN_ = 19;
    static final int LEN = 20;
    static final int LENEXT = 21;
    static final int DIST = 22;
    static final int DISTEXT = 23;
    static final int MATCH = 24;
    static final int LIT = 25;
    static final int CHECK = 26;
    static final int LENGTH = 27;
    static final int DONE = 28;
    static final int BAD = 29;
    static final int MEM = 30;
    static final int SYNC = 31;
    static final int CODES = 0;
    static final int LENS = 1;
    static final int DISTS = 2;
    static final int MAXBITS = 15;
    static final short[] order = new short[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    static final short[] lbase = new short[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
    static final short[] lext = new short[]{16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78};
    static final short[] dbase = new short[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577, 0, 0};
    static final short[] dext = new short[]{16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 64, 64};
    static final int lenfix = 0;
    static final int distfix = 512;
    static final int[] fixed = new int[]{Inflate.code(96, 7, 0), Inflate.code(0, 8, 80), Inflate.code(0, 8, 16), Inflate.code(20, 8, 115), Inflate.code(18, 7, 31), Inflate.code(0, 8, 112), Inflate.code(0, 8, 48), Inflate.code(0, 9, 192), Inflate.code(16, 7, 10), Inflate.code(0, 8, 96), Inflate.code(0, 8, 32), Inflate.code(0, 9, 160), Inflate.code(0, 8, 0), Inflate.code(0, 8, 128), Inflate.code(0, 8, 64), Inflate.code(0, 9, 224), Inflate.code(16, 7, 6), Inflate.code(0, 8, 88), Inflate.code(0, 8, 24), Inflate.code(0, 9, 144), Inflate.code(19, 7, 59), Inflate.code(0, 8, 120), Inflate.code(0, 8, 56), Inflate.code(0, 9, 208), Inflate.code(17, 7, 17), Inflate.code(0, 8, 104), Inflate.code(0, 8, 40), Inflate.code(0, 9, 176), Inflate.code(0, 8, 8), Inflate.code(0, 8, 136), Inflate.code(0, 8, 72), Inflate.code(0, 9, 240), Inflate.code(16, 7, 4), Inflate.code(0, 8, 84), Inflate.code(0, 8, 20), Inflate.code(21, 8, 227), Inflate.code(19, 7, 43), Inflate.code(0, 8, 116), Inflate.code(0, 8, 52), Inflate.code(0, 9, 200), Inflate.code(17, 7, 13), Inflate.code(0, 8, 100), Inflate.code(0, 8, 36), Inflate.code(0, 9, 168), Inflate.code(0, 8, 4), Inflate.code(0, 8, 132), Inflate.code(0, 8, 68), Inflate.code(0, 9, 232), Inflate.code(16, 7, 8), Inflate.code(0, 8, 92), Inflate.code(0, 8, 28), Inflate.code(0, 9, 152), Inflate.code(20, 7, 83), Inflate.code(0, 8, 124), Inflate.code(0, 8, 60), Inflate.code(0, 9, 216), Inflate.code(18, 7, 23), Inflate.code(0, 8, 108), Inflate.code(0, 8, 44), Inflate.code(0, 9, 184), Inflate.code(0, 8, 12), Inflate.code(0, 8, 140), Inflate.code(0, 8, 76), Inflate.code(0, 9, 248), Inflate.code(16, 7, 3), Inflate.code(0, 8, 82), Inflate.code(0, 8, 18), Inflate.code(21, 8, 163), Inflate.code(19, 7, 35), Inflate.code(0, 8, 114), Inflate.code(0, 8, 50), Inflate.code(0, 9, 196), Inflate.code(17, 7, 11), Inflate.code(0, 8, 98), Inflate.code(0, 8, 34), Inflate.code(0, 9, 164), Inflate.code(0, 8, 2), Inflate.code(0, 8, 130), Inflate.code(0, 8, 66), Inflate.code(0, 9, 228), Inflate.code(16, 7, 7), Inflate.code(0, 8, 90), Inflate.code(0, 8, 26), Inflate.code(0, 9, 148), Inflate.code(20, 7, 67), Inflate.code(0, 8, 122), Inflate.code(0, 8, 58), Inflate.code(0, 9, 212), Inflate.code(18, 7, 19), Inflate.code(0, 8, 106), Inflate.code(0, 8, 42), Inflate.code(0, 9, 180), Inflate.code(0, 8, 10), Inflate.code(0, 8, 138), Inflate.code(0, 8, 74), Inflate.code(0, 9, 244), Inflate.code(16, 7, 5), Inflate.code(0, 8, 86), Inflate.code(0, 8, 22), Inflate.code(64, 8, 0), Inflate.code(19, 7, 51), Inflate.code(0, 8, 118), Inflate.code(0, 8, 54), Inflate.code(0, 9, 204), Inflate.code(17, 7, 15), Inflate.code(0, 8, 102), Inflate.code(0, 8, 38), Inflate.code(0, 9, 172), Inflate.code(0, 8, 6), Inflate.code(0, 8, 134), Inflate.code(0, 8, 70), Inflate.code(0, 9, 236), Inflate.code(16, 7, 9), Inflate.code(0, 8, 94), Inflate.code(0, 8, 30), Inflate.code(0, 9, 156), Inflate.code(20, 7, 99), Inflate.code(0, 8, 126), Inflate.code(0, 8, 62), Inflate.code(0, 9, 220), Inflate.code(18, 7, 27), Inflate.code(0, 8, 110), Inflate.code(0, 8, 46), Inflate.code(0, 9, 188), Inflate.code(0, 8, 14), Inflate.code(0, 8, 142), Inflate.code(0, 8, 78), Inflate.code(0, 9, 252), Inflate.code(96, 7, 0), Inflate.code(0, 8, 81), Inflate.code(0, 8, 17), Inflate.code(21, 8, 131), Inflate.code(18, 7, 31), Inflate.code(0, 8, 113), Inflate.code(0, 8, 49), Inflate.code(0, 9, 194), Inflate.code(16, 7, 10), Inflate.code(0, 8, 97), Inflate.code(0, 8, 33), Inflate.code(0, 9, 162), Inflate.code(0, 8, 1), Inflate.code(0, 8, 129), Inflate.code(0, 8, 65), Inflate.code(0, 9, 226), Inflate.code(16, 7, 6), Inflate.code(0, 8, 89), Inflate.code(0, 8, 25), Inflate.code(0, 9, 146), Inflate.code(19, 7, 59), Inflate.code(0, 8, 121), Inflate.code(0, 8, 57), Inflate.code(0, 9, 210), Inflate.code(17, 7, 17), Inflate.code(0, 8, 105), Inflate.code(0, 8, 41), Inflate.code(0, 9, 178), Inflate.code(0, 8, 9), Inflate.code(0, 8, 137), Inflate.code(0, 8, 73), Inflate.code(0, 9, 242), Inflate.code(16, 7, 4), Inflate.code(0, 8, 85), Inflate.code(0, 8, 21), Inflate.code(16, 8, 258), Inflate.code(19, 7, 43), Inflate.code(0, 8, 117), Inflate.code(0, 8, 53), Inflate.code(0, 9, 202), Inflate.code(17, 7, 13), Inflate.code(0, 8, 101), Inflate.code(0, 8, 37), Inflate.code(0, 9, 170), Inflate.code(0, 8, 5), Inflate.code(0, 8, 133), Inflate.code(0, 8, 69), Inflate.code(0, 9, 234), Inflate.code(16, 7, 8), Inflate.code(0, 8, 93), Inflate.code(0, 8, 29), Inflate.code(0, 9, 154), Inflate.code(20, 7, 83), Inflate.code(0, 8, 125), Inflate.code(0, 8, 61), Inflate.code(0, 9, 218), Inflate.code(18, 7, 23), Inflate.code(0, 8, 109), Inflate.code(0, 8, 45), Inflate.code(0, 9, 186), Inflate.code(0, 8, 13), Inflate.code(0, 8, 141), Inflate.code(0, 8, 77), Inflate.code(0, 9, 250), Inflate.code(16, 7, 3), Inflate.code(0, 8, 83), Inflate.code(0, 8, 19), Inflate.code(21, 8, 195), Inflate.code(19, 7, 35), Inflate.code(0, 8, 115), Inflate.code(0, 8, 51), Inflate.code(0, 9, 198), Inflate.code(17, 7, 11), Inflate.code(0, 8, 99), Inflate.code(0, 8, 35), Inflate.code(0, 9, 166), Inflate.code(0, 8, 3), Inflate.code(0, 8, 131), Inflate.code(0, 8, 67), Inflate.code(0, 9, 230), Inflate.code(16, 7, 7), Inflate.code(0, 8, 91), Inflate.code(0, 8, 27), Inflate.code(0, 9, 150), Inflate.code(20, 7, 67), Inflate.code(0, 8, 123), Inflate.code(0, 8, 59), Inflate.code(0, 9, 214), Inflate.code(18, 7, 19), Inflate.code(0, 8, 107), Inflate.code(0, 8, 43), Inflate.code(0, 9, 182), Inflate.code(0, 8, 11), Inflate.code(0, 8, 139), Inflate.code(0, 8, 75), Inflate.code(0, 9, 246), Inflate.code(16, 7, 5), Inflate.code(0, 8, 87), Inflate.code(0, 8, 23), Inflate.code(64, 8, 0), Inflate.code(19, 7, 51), Inflate.code(0, 8, 119), Inflate.code(0, 8, 55), Inflate.code(0, 9, 206), Inflate.code(17, 7, 15), Inflate.code(0, 8, 103), Inflate.code(0, 8, 39), Inflate.code(0, 9, 174), Inflate.code(0, 8, 7), Inflate.code(0, 8, 135), Inflate.code(0, 8, 71), Inflate.code(0, 9, 238), Inflate.code(16, 7, 9), Inflate.code(0, 8, 95), Inflate.code(0, 8, 31), Inflate.code(0, 9, 158), Inflate.code(20, 7, 99), Inflate.code(0, 8, 127), Inflate.code(0, 8, 63), Inflate.code(0, 9, 222), Inflate.code(18, 7, 27), Inflate.code(0, 8, 111), Inflate.code(0, 8, 47), Inflate.code(0, 9, 190), Inflate.code(0, 8, 15), Inflate.code(0, 8, 143), Inflate.code(0, 8, 79), Inflate.code(0, 9, 254), Inflate.code(96, 7, 0), Inflate.code(0, 8, 80), Inflate.code(0, 8, 16), Inflate.code(20, 8, 115), Inflate.code(18, 7, 31), Inflate.code(0, 8, 112), Inflate.code(0, 8, 48), Inflate.code(0, 9, 193), Inflate.code(16, 7, 10), Inflate.code(0, 8, 96), Inflate.code(0, 8, 32), Inflate.code(0, 9, 161), Inflate.code(0, 8, 0), Inflate.code(0, 8, 128), Inflate.code(0, 8, 64), Inflate.code(0, 9, 225), Inflate.code(16, 7, 6), Inflate.code(0, 8, 88), Inflate.code(0, 8, 24), Inflate.code(0, 9, 145), Inflate.code(19, 7, 59), Inflate.code(0, 8, 120), Inflate.code(0, 8, 56), Inflate.code(0, 9, 209), Inflate.code(17, 7, 17), Inflate.code(0, 8, 104), Inflate.code(0, 8, 40), Inflate.code(0, 9, 177), Inflate.code(0, 8, 8), Inflate.code(0, 8, 136), Inflate.code(0, 8, 72), Inflate.code(0, 9, 241), Inflate.code(16, 7, 4), Inflate.code(0, 8, 84), Inflate.code(0, 8, 20), Inflate.code(21, 8, 227), Inflate.code(19, 7, 43), Inflate.code(0, 8, 116), Inflate.code(0, 8, 52), Inflate.code(0, 9, 201), Inflate.code(17, 7, 13), Inflate.code(0, 8, 100), Inflate.code(0, 8, 36), Inflate.code(0, 9, 169), Inflate.code(0, 8, 4), Inflate.code(0, 8, 132), Inflate.code(0, 8, 68), Inflate.code(0, 9, 233), Inflate.code(16, 7, 8), Inflate.code(0, 8, 92), Inflate.code(0, 8, 28), Inflate.code(0, 9, 153), Inflate.code(20, 7, 83), Inflate.code(0, 8, 124), Inflate.code(0, 8, 60), Inflate.code(0, 9, 217), Inflate.code(18, 7, 23), Inflate.code(0, 8, 108), Inflate.code(0, 8, 44), Inflate.code(0, 9, 185), Inflate.code(0, 8, 12), Inflate.code(0, 8, 140), Inflate.code(0, 8, 76), Inflate.code(0, 9, 249), Inflate.code(16, 7, 3), Inflate.code(0, 8, 82), Inflate.code(0, 8, 18), Inflate.code(21, 8, 163), Inflate.code(19, 7, 35), Inflate.code(0, 8, 114), Inflate.code(0, 8, 50), Inflate.code(0, 9, 197), Inflate.code(17, 7, 11), Inflate.code(0, 8, 98), Inflate.code(0, 8, 34), Inflate.code(0, 9, 165), Inflate.code(0, 8, 2), Inflate.code(0, 8, 130), Inflate.code(0, 8, 66), Inflate.code(0, 9, 229), Inflate.code(16, 7, 7), Inflate.code(0, 8, 90), Inflate.code(0, 8, 26), Inflate.code(0, 9, 149), Inflate.code(20, 7, 67), Inflate.code(0, 8, 122), Inflate.code(0, 8, 58), Inflate.code(0, 9, 213), Inflate.code(18, 7, 19), Inflate.code(0, 8, 106), Inflate.code(0, 8, 42), Inflate.code(0, 9, 181), Inflate.code(0, 8, 10), Inflate.code(0, 8, 138), Inflate.code(0, 8, 74), Inflate.code(0, 9, 245), Inflate.code(16, 7, 5), Inflate.code(0, 8, 86), Inflate.code(0, 8, 22), Inflate.code(64, 8, 0), Inflate.code(19, 7, 51), Inflate.code(0, 8, 118), Inflate.code(0, 8, 54), Inflate.code(0, 9, 205), Inflate.code(17, 7, 15), Inflate.code(0, 8, 102), Inflate.code(0, 8, 38), Inflate.code(0, 9, 173), Inflate.code(0, 8, 6), Inflate.code(0, 8, 134), Inflate.code(0, 8, 70), Inflate.code(0, 9, 237), Inflate.code(16, 7, 9), Inflate.code(0, 8, 94), Inflate.code(0, 8, 30), Inflate.code(0, 9, 157), Inflate.code(20, 7, 99), Inflate.code(0, 8, 126), Inflate.code(0, 8, 62), Inflate.code(0, 9, 221), Inflate.code(18, 7, 27), Inflate.code(0, 8, 110), Inflate.code(0, 8, 46), Inflate.code(0, 9, 189), Inflate.code(0, 8, 14), Inflate.code(0, 8, 142), Inflate.code(0, 8, 78), Inflate.code(0, 9, 253), Inflate.code(96, 7, 0), Inflate.code(0, 8, 81), Inflate.code(0, 8, 17), Inflate.code(21, 8, 131), Inflate.code(18, 7, 31), Inflate.code(0, 8, 113), Inflate.code(0, 8, 49), Inflate.code(0, 9, 195), Inflate.code(16, 7, 10), Inflate.code(0, 8, 97), Inflate.code(0, 8, 33), Inflate.code(0, 9, 163), Inflate.code(0, 8, 1), Inflate.code(0, 8, 129), Inflate.code(0, 8, 65), Inflate.code(0, 9, 227), Inflate.code(16, 7, 6), Inflate.code(0, 8, 89), Inflate.code(0, 8, 25), Inflate.code(0, 9, 147), Inflate.code(19, 7, 59), Inflate.code(0, 8, 121), Inflate.code(0, 8, 57), Inflate.code(0, 9, 211), Inflate.code(17, 7, 17), Inflate.code(0, 8, 105), Inflate.code(0, 8, 41), Inflate.code(0, 9, 179), Inflate.code(0, 8, 9), Inflate.code(0, 8, 137), Inflate.code(0, 8, 73), Inflate.code(0, 9, 243), Inflate.code(16, 7, 4), Inflate.code(0, 8, 85), Inflate.code(0, 8, 21), Inflate.code(16, 8, 258), Inflate.code(19, 7, 43), Inflate.code(0, 8, 117), Inflate.code(0, 8, 53), Inflate.code(0, 9, 203), Inflate.code(17, 7, 13), Inflate.code(0, 8, 101), Inflate.code(0, 8, 37), Inflate.code(0, 9, 171), Inflate.code(0, 8, 5), Inflate.code(0, 8, 133), Inflate.code(0, 8, 69), Inflate.code(0, 9, 235), Inflate.code(16, 7, 8), Inflate.code(0, 8, 93), Inflate.code(0, 8, 29), Inflate.code(0, 9, 155), Inflate.code(20, 7, 83), Inflate.code(0, 8, 125), Inflate.code(0, 8, 61), Inflate.code(0, 9, 219), Inflate.code(18, 7, 23), Inflate.code(0, 8, 109), Inflate.code(0, 8, 45), Inflate.code(0, 9, 187), Inflate.code(0, 8, 13), Inflate.code(0, 8, 141), Inflate.code(0, 8, 77), Inflate.code(0, 9, 251), Inflate.code(16, 7, 3), Inflate.code(0, 8, 83), Inflate.code(0, 8, 19), Inflate.code(21, 8, 195), Inflate.code(19, 7, 35), Inflate.code(0, 8, 115), Inflate.code(0, 8, 51), Inflate.code(0, 9, 199), Inflate.code(17, 7, 11), Inflate.code(0, 8, 99), Inflate.code(0, 8, 35), Inflate.code(0, 9, 167), Inflate.code(0, 8, 3), Inflate.code(0, 8, 131), Inflate.code(0, 8, 67), Inflate.code(0, 9, 231), Inflate.code(16, 7, 7), Inflate.code(0, 8, 91), Inflate.code(0, 8, 27), Inflate.code(0, 9, 151), Inflate.code(20, 7, 67), Inflate.code(0, 8, 123), Inflate.code(0, 8, 59), Inflate.code(0, 9, 215), Inflate.code(18, 7, 19), Inflate.code(0, 8, 107), Inflate.code(0, 8, 43), Inflate.code(0, 9, 183), Inflate.code(0, 8, 11), Inflate.code(0, 8, 139), Inflate.code(0, 8, 75), Inflate.code(0, 9, 247), Inflate.code(16, 7, 5), Inflate.code(0, 8, 87), Inflate.code(0, 8, 23), Inflate.code(64, 8, 0), Inflate.code(19, 7, 51), Inflate.code(0, 8, 119), Inflate.code(0, 8, 55), Inflate.code(0, 9, 207), Inflate.code(17, 7, 15), Inflate.code(0, 8, 103), Inflate.code(0, 8, 39), Inflate.code(0, 9, 175), Inflate.code(0, 8, 7), Inflate.code(0, 8, 135), Inflate.code(0, 8, 71), Inflate.code(0, 9, 239), Inflate.code(16, 7, 9), Inflate.code(0, 8, 95), Inflate.code(0, 8, 31), Inflate.code(0, 9, 159), Inflate.code(20, 7, 99), Inflate.code(0, 8, 127), Inflate.code(0, 8, 63), Inflate.code(0, 9, 223), Inflate.code(18, 7, 27), Inflate.code(0, 8, 111), Inflate.code(0, 8, 47), Inflate.code(0, 9, 191), Inflate.code(0, 8, 15), Inflate.code(0, 8, 143), Inflate.code(0, 8, 79), Inflate.code(0, 9, 255), Inflate.code(16, 5, 1), Inflate.code(23, 5, 257), Inflate.code(19, 5, 17), Inflate.code(27, 5, 4097), Inflate.code(17, 5, 5), Inflate.code(25, 5, 1025), Inflate.code(21, 5, 65), Inflate.code(29, 5, 16385), Inflate.code(16, 5, 3), Inflate.code(24, 5, 513), Inflate.code(20, 5, 33), Inflate.code(28, 5, 8193), Inflate.code(18, 5, 9), Inflate.code(26, 5, 2049), Inflate.code(22, 5, 129), Inflate.code(64, 5, 0), Inflate.code(16, 5, 2), Inflate.code(23, 5, 385), Inflate.code(19, 5, 25), Inflate.code(27, 5, 6145), Inflate.code(17, 5, 7), Inflate.code(25, 5, 1537), Inflate.code(21, 5, 97), Inflate.code(29, 5, 24577), Inflate.code(16, 5, 4), Inflate.code(24, 5, 769), Inflate.code(20, 5, 49), Inflate.code(28, 5, 12289), Inflate.code(18, 5, 13), Inflate.code(26, 5, 3073), Inflate.code(22, 5, 193), Inflate.code(64, 5, 0)};

    public Inflate(Decoder<O> output, int wrap, int windowBits) {
        this.output = output;
        this.inflateInit(wrap, windowBits);
    }

    public Inflate(Decoder<O> output, int wrap) {
        this(output, wrap, 15);
    }

    public Inflate(Decoder<O> output) {
        this(output, 0, 15);
    }

    public Inflate(int wrap, int windowBits) {
        this(null, wrap, windowBits);
    }

    public Inflate(int wrap) {
        this(null, wrap, 15);
    }

    public Inflate() {
        this(null, 0, 15);
    }

    Inflate(Inflate<O> from) {
        this.output = from.output;
        this.is_last = from.is_last;
        this.flush = from.flush;
        this.next_in = from.next_in;
        this.next_in_index = from.next_in_index;
        this.avail_in = from.avail_in;
        this.total_in = from.total_in;
        this.next_out = from.next_out;
        this.next_out_index = from.next_out_index;
        this.avail_out = from.avail_out;
        this.total_out = from.total_out;
        this.data_type = from.data_type;
        this.adler = from.adler;
        this.mode = from.mode;
        this.last = from.last;
        this.wrap = from.wrap;
        this.havedict = from.havedict;
        this.flags = from.flags;
        this.dmax = from.dmax;
        this.check = from.check;
        this.total = from.total;
        if (this.head != null) {
            this.head = from.head.clone();
        }
        this.wbits = from.wbits;
        this.wsize = from.wsize;
        this.whave = from.whave;
        this.wnext = from.wnext;
        if (from.window != null) {
            this.window = new byte[from.window.length];
            System.arraycopy(from.window, 0, this.window, 0, this.window.length);
            this.window_buffer = Binary.inputBuffer((byte[])this.window);
        }
        this.hold = from.hold;
        this.bits = from.bits;
        this.length = from.length;
        this.offset = from.offset;
        this.extra = from.extra;
        this.lencode = from.lencode;
        this.distcode = from.distcode;
        this.lenbits = from.lenbits;
        this.distbits = from.distbits;
        this.ncode = from.ncode;
        this.nlen = from.nlen;
        this.ndist = from.ndist;
        this.have = from.have;
        this.next = from.next;
        System.arraycopy(from.lens, 0, this.lens, 0, this.lens.length);
        System.arraycopy(from.work, 0, this.work, 0, this.work.length);
        System.arraycopy(from.codes, 0, this.codes, 0, this.codes.length);
        this.sane = from.sane;
        this.back = from.back;
        this.was = from.was;
    }

    public void inflateResetKeep() {
        this.total = 0L;
        this.total_out = 0L;
        this.total_in = 0L;
        this.flush = 4;
        this.mode = 0;
        this.last = false;
        this.havedict = false;
        this.dmax = 32768;
        this.head = null;
        this.hold = 0;
        this.bits = 0;
        this.next = 0;
        this.distcode = 0;
        this.lencode = 0;
        this.sane = true;
        this.back = -1;
    }

    public void inflateReset() {
        this.wsize = 0;
        this.whave = 0;
        this.wnext = 0;
        this.inflateResetKeep();
    }

    public void inflateReset(int wrap, int windowBits) {
        if (windowBits != 0 && (windowBits < 8 || windowBits > 15)) {
            throw new DeflateException(-2);
        }
        if (this.window != null && this.wbits != windowBits) {
            this.window = null;
            this.window_buffer = null;
        }
        this.wrap = wrap;
        this.wbits = windowBits;
        this.inflateReset();
    }

    protected void inflateInit(int wrap, int windowBits) {
        this.window = null;
        this.window_buffer = null;
        this.inflateReset(wrap, windowBits);
    }

    public void initWindow() {
        if (this.window == null) {
            this.wsize = 1 << this.wbits;
            this.window = new byte[this.wsize * 2];
            this.window_buffer = Binary.inputBuffer((byte[])this.window);
            this.wnext = 0;
            this.whave = 0;
        }
    }

    public Inflate<O> clone() {
        return new Inflate<O>(this);
    }

    public Inflate<O> flush(int flush) {
        this.flush = flush;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Decoder<O> feed(InputBuffer input) {
        this.is_last = !input.isPart();
        this.next_in = input.array();
        this.next_in_index = input.arrayOffset() + input.index();
        this.avail_in = input.remaining();
        this.initWindow();
        this.next_out = this.window;
        try {
            boolean needsMore;
            do {
                this.next_out_index = this.wnext;
                this.avail_out = this.window.length - this.wnext;
            } while ((needsMore = this.inflate(this.flush)) && this.avail_in > 0 && this.output.isCont());
            if (this.output.isDone()) {
                Decoder<O> decoder = this.output;
                return decoder;
            }
            if (this.output.isError()) {
                Decoder decoder = this.output.asError();
                return decoder;
            }
            if (!needsMore) {
                Decoder decoder = Inflate.done();
                return decoder;
            }
            if (input.isDone()) {
                Decoder decoder = Inflate.error((Throwable)new DecoderException("truncated"));
                return decoder;
            }
            if (input.isError()) {
                Decoder decoder = Inflate.error((Throwable)input.trap());
                return decoder;
            }
            Inflate inflate = this;
            return inflate;
        }
        catch (DeflateException cause) {
            Decoder decoder = Inflate.error((Throwable)cause);
            return decoder;
        }
        finally {
            input.index(this.next_in_index - input.arrayOffset());
            this.next_out = null;
            this.next_out_index = 0;
            this.avail_out = 0;
            this.next_in = null;
            this.next_in_index = 0;
            this.avail_in = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean inflate(int flush) {
        msg = null;
        v0 = hbuf = this.wrap == 2 ? new byte[4] : null;
        if (this.next_out == null || this.next_in == null && this.avail_in != 0) {
            throw new DeflateException(-2);
        }
        if (this.mode == 11) {
            this.mode = 12;
        }
        in = this.avail_in;
        out = this.avail_out;
        ret = 0;
        block39: while (true) {
            switch (this.mode) {
                case 0: {
                    if (this.wrap == 0) {
                        this.mode = 12;
                        continue block39;
                    }
                    if (!this.NEEDBITS(16)) break block39;
                    if ((this.wrap & 2) != 0 && this.hold == 35615) {
                        this.check = CRC32.crc32(0, null, 0, 0);
                        this.CRC2(this.check, hbuf, this.hold);
                        this.INITBITS();
                        this.mode = 1;
                        continue block39;
                    }
                    this.flags = 0;
                    if (this.head != null) {
                        this.head.done = false;
                    }
                    if ((this.wrap & 1) == 0 || ((this.BITS(8) << 8) + (this.hold >>> 8)) % 31 != 0) {
                        throw new DeflateException("incorrect header check");
                    }
                    if (this.BITS(4) != 8) {
                        throw new DeflateException("unknown compression method");
                    }
                    this.DROPBITS(4);
                    len = this.BITS(4) + 8;
                    if (this.wbits == 0) {
                        this.wbits = len;
                    } else if (len > this.wbits) {
                        throw new DeflateException("invalid window size");
                    }
                    this.dmax = 1 << len;
                    this.adler = this.check = Adler32.adler32(0, null, 0, 0);
                    this.mode = (this.hold & 512) != 0 ? 9 : 11;
                    this.INITBITS();
                    continue block39;
                }
                case 1: {
                    if (!this.NEEDBITS(16)) break block39;
                    this.flags = this.hold;
                    if ((this.flags & 255) != 8) {
                        throw new DeflateException("unknown compression method");
                    }
                    if ((this.flags & 57344) != 0) {
                        throw new DeflateException("unknown header flags set");
                    }
                    if (this.head != null) {
                        v1 = this.head.text = (this.hold >>> 8 & 1) != 0;
                    }
                    if ((this.flags & 512) != 0) {
                        this.CRC2(this.check, hbuf, this.hold);
                    }
                    this.INITBITS();
                    this.mode = 2;
                }
                case 2: {
                    if (!this.NEEDBITS(32)) break block39;
                    if (this.head != null) {
                        this.head.time = this.hold;
                    }
                    if ((this.flags & 512) != 0) {
                        this.CRC4(this.check, hbuf, this.hold);
                    }
                    this.INITBITS();
                    this.mode = 3;
                }
                case 3: {
                    if (!this.NEEDBITS(16)) break block39;
                    if (this.head != null) {
                        this.head.xflags = this.hold & 255;
                        this.head.os = this.hold >>> 8;
                    }
                    if ((this.flags & 512) != 0) {
                        this.CRC2(this.check, hbuf, this.hold);
                    }
                    this.INITBITS();
                    this.mode = 4;
                }
                case 4: {
                    if ((this.flags & 1024) != 0) {
                        if (!this.NEEDBITS(16)) break block39;
                        this.length = this.hold;
                        if (this.head != null) {
                            this.head.extra_len = this.hold;
                        }
                        if ((this.flags & 512) != 0) {
                            this.CRC2(this.check, hbuf, this.hold);
                        }
                        this.INITBITS();
                    } else if (this.head != null) {
                        this.head.extra = null;
                    }
                    this.mode = 5;
                }
                case 5: {
                    if ((this.flags & 1024) != 0) {
                        copy = this.length;
                        if (copy > this.avail_in) {
                            copy = this.avail_in;
                        }
                        if (copy != 0) {
                            if (this.head != null) {
                                len = this.head.extra_len - this.length;
                                this.head.extra = new byte[copy];
                                System.arraycopy(this.next_in, this.next_in_index, this.head.extra, len, copy);
                            }
                            if ((this.flags & 512) != 0) {
                                this.check = CRC32.crc32(this.check, this.next_in, this.next_in_index, copy);
                            }
                            this.avail_in -= copy;
                            this.next_in_index += copy;
                            this.length -= copy;
                        }
                        if (this.length != 0) break block39;
                    }
                    this.length = 0;
                    this.mode = 6;
                }
                case 6: {
                    if ((this.flags & 2048) != 0) {
                        if (this.avail_in == 0) break block39;
                        copy = 0;
                        do {
                            len = this.next_in[this.next_in_index + copy++];
                            if (this.head == null || this.head.name == null || this.length >= this.head.name.length) continue;
                            this.head.name[this.length++] = (byte)len;
                        } while (len != 0 && copy < this.avail_in);
                        if ((this.flags & 512) != 0) {
                            this.check = CRC32.crc32(this.check, this.next_in, this.next_in_index, copy);
                        }
                        this.avail_in -= copy;
                        this.next_in_index += copy;
                        if (len != 0) {
                            break block39;
                        }
                    } else if (this.head != null) {
                        this.head.name = null;
                    }
                    this.length = 0;
                    this.mode = 7;
                }
                case 7: {
                    if ((this.flags & 4096) != 0) {
                        if (this.avail_in == 0) break block39;
                        copy = 0;
                        do {
                            len = this.next_in[this.next_in_index + copy++];
                            if (this.head == null || this.head.comment == null || this.length >= this.head.comment.length) continue;
                            this.head.comment[this.length++] = (byte)len;
                        } while (len != 0 && copy < this.avail_in);
                        if ((this.flags & 512) != 0) {
                            this.check = CRC32.crc32(this.check, this.next_in, this.next_in_index, copy);
                        }
                        this.avail_in -= copy;
                        this.next_in_index += copy;
                        if (len != 0) {
                            break block39;
                        }
                    } else if (this.head != null) {
                        this.head.comment = null;
                    }
                    this.mode = 8;
                }
                case 8: {
                    if ((this.flags & 512) != 0) {
                        if (!this.NEEDBITS(16)) break block39;
                        if (this.hold != (this.check & 65535)) {
                            throw new DeflateException("header crc mismatch");
                        }
                        this.INITBITS();
                    }
                    if (this.head != null) {
                        this.head.hcrc = (this.flags >>> 9 & 1) != 0;
                        this.head.done = true;
                    }
                    this.adler = this.check = CRC32.crc32(0, null, 0, 0);
                    this.mode = 11;
                    continue block39;
                }
                case 9: {
                    if (!this.NEEDBITS(32)) break block39;
                    this.adler = this.check = Integer.reverseBytes(this.hold);
                    this.INITBITS();
                    this.mode = 10;
                }
                case 10: {
                    if (!this.havedict) {
                        throw new DeflateException(2);
                    }
                    this.adler = this.check = Adler32.adler32(0, null, 0, 0);
                    this.mode = 11;
                }
                case 11: {
                    if (flush == 5 || flush == 6) break block39;
                }
                case 12: {
                    if (this.last) {
                        this.BYTEBITS();
                        this.mode = 26;
                        continue block39;
                    }
                    if (!this.NEEDBITS(3)) break block39;
                    this.last = this.BITS(1) != 0;
                    this.DROPBITS(1);
                    switch (this.BITS(2)) {
                        case 0: {
                            this.mode = 13;
                            break;
                        }
                        case 1: {
                            this.fixedtables();
                            this.mode = 19;
                            if (flush != 6) break;
                            this.DROPBITS(2);
                            break block39;
                        }
                        case 2: {
                            this.mode = 16;
                            break;
                        }
                        case 3: {
                            throw new DeflateException("invalid block type");
                        }
                    }
                    this.DROPBITS(2);
                    continue block39;
                }
                case 13: {
                    this.BYTEBITS();
                    if (!this.NEEDBITS(32)) break block39;
                    if ((this.hold & 65535) != (this.hold >>> 16 ^ 65535)) {
                        throw new DeflateException("invalid stored block lengths");
                    }
                    this.length = this.hold & 65535;
                    this.INITBITS();
                    this.mode = 14;
                    if (flush == 6) break block39;
                }
                case 14: {
                    this.mode = 15;
                }
                case 15: {
                    copy = this.length;
                    if (copy != 0) {
                        if (copy > this.avail_in) {
                            copy = this.avail_in;
                        }
                        if (copy > this.avail_out) {
                            copy = this.avail_out;
                        }
                        if (copy == 0) break block39;
                        System.arraycopy(this.next_in, this.next_in_index, this.next_out, this.next_out_index, copy);
                        this.avail_in -= copy;
                        this.next_in_index += copy;
                        this.avail_out -= copy;
                        this.next_out_index += copy;
                        this.length -= copy;
                        continue block39;
                    }
                    this.mode = 11;
                    continue block39;
                }
                case 16: {
                    if (!this.NEEDBITS(14)) break block39;
                    this.nlen = this.BITS(5) + 257;
                    this.DROPBITS(5);
                    this.ndist = this.BITS(5) + 1;
                    this.DROPBITS(5);
                    this.ncode = this.BITS(4) + 4;
                    this.DROPBITS(4);
                    if (this.nlen > 286 || this.ndist > 30) {
                        throw new DeflateException("too many length or distance symbols");
                    }
                    this.have = 0;
                    this.mode = 17;
                }
                case 17: {
                    while (this.have < this.ncode) {
                        if (!this.NEEDBITS(3)) break block39;
                        this.lens[Inflate.order[this.have++]] = (short)this.BITS(3);
                        this.DROPBITS(3);
                    }
                    while (this.have < 19) {
                        this.lens[Inflate.order[this.have++]] = 0;
                    }
                    this.lencode = this.next = 0;
                    this.lenbits = 7;
                    ret = this.inflate_table(0, 0, 19);
                    if (ret != 0) {
                        throw new DeflateException("invalid code lengths set");
                    }
                    this.have = 0;
                    this.mode = 18;
                }
                case 18: {
                    while (this.have < this.nlen + this.ndist) {
                        do {
                            here = this.codes[this.lencode + this.BITS(this.lenbits)];
                            hereOp = here >>> 24 & 255;
                            hereBits = here >>> 16 & 255;
                            hereVal = here & 65535;
                            if (hereBits <= this.bits) ** GOTO lbl257
                        } while (this.PULLBYTE());
                        break block39;
lbl257:
                        // 1 sources

                        if (hereVal < 16) {
                            this.DROPBITS(hereBits);
                            this.lens[this.have++] = (short)hereVal;
                            continue;
                        }
                        if (hereVal == 16) {
                            if (!this.NEEDBITS(hereBits + 2)) break block39;
                            this.DROPBITS(hereBits);
                            if (this.have == 0) {
                                throw new DeflateException("invalid bit length repeat");
                            }
                            len = this.lens[this.have - 1];
                            copy = 3 + this.BITS(2);
                            this.DROPBITS(2);
                        } else if (hereVal == 17) {
                            if (!this.NEEDBITS(hereBits + 3)) break block39;
                            this.DROPBITS(hereBits);
                            len = 0;
                            copy = 3 + this.BITS(3);
                            this.DROPBITS(3);
                        } else {
                            if (!this.NEEDBITS(hereBits + 7)) break block39;
                            this.DROPBITS(hereBits);
                            len = 0;
                            copy = 11 + this.BITS(7);
                            this.DROPBITS(7);
                        }
                        if (this.have + copy > this.nlen + this.ndist) {
                            throw new DeflateException("invalid bit length repeat");
                        }
                        while (copy-- != 0) {
                            this.lens[this.have++] = (short)len;
                        }
                    }
                    if (this.mode == 29) continue block39;
                    if (this.lens[256] == 0) {
                        throw new DeflateException("invalid code -- missing end-of-block");
                    }
                    this.lencode = this.next = 0;
                    this.lenbits = 9;
                    ret = this.inflate_table(1, 0, this.nlen);
                    if (ret != 0) {
                        throw new DeflateException("invalid literal/lengths set");
                    }
                    this.distcode = this.next;
                    this.distbits = 6;
                    ret = this.inflate_table(2, this.nlen, this.ndist);
                    if (ret != 0) {
                        throw new DeflateException("invalid distances set");
                    }
                    this.mode = 19;
                    if (flush == 6) break block39;
                }
                case 19: {
                    this.mode = 20;
                }
                case 20: {
                    if (this.avail_in >= 6 && this.avail_out >= 258) {
                        this.inflate_fast(out);
                        if (this.mode != 11) continue block39;
                        this.back = -1;
                        continue block39;
                    }
                    this.back = 0;
                    do {
                        here = this.codes[this.lencode + this.BITS(this.lenbits)];
                        hereOp = here >>> 24 & 255;
                        hereBits = here >>> 16 & 255;
                        hereVal = here & 65535;
                        if (hereBits <= this.bits) ** GOTO lbl320
                    } while (this.PULLBYTE());
                    break block39;
lbl320:
                    // 1 sources

                    if (hereOp == 0 || (hereOp & 240) != 0) ** GOTO lbl335
                    last = here;
                    lastOp = hereOp;
                    lastBits = hereBits;
                    lastVal = hereVal;
                    do {
                        here = this.codes[this.lencode + lastVal + (this.BITS(lastBits + lastOp) >>> lastBits)];
                        hereOp = here >>> 24 & 255;
                        hereBits = here >>> 16 & 255;
                        hereVal = here & 65535;
                        if (lastBits + hereBits <= this.bits) ** GOTO lbl333
                    } while (this.PULLBYTE());
                    break block39;
lbl333:
                    // 1 sources

                    this.DROPBITS(lastBits);
                    this.back += lastBits;
lbl335:
                    // 2 sources

                    this.DROPBITS(hereBits);
                    this.back += hereBits;
                    this.length = hereVal;
                    if (hereOp == 0) {
                        this.mode = 25;
                        continue block39;
                    }
                    if ((hereOp & 32) != 0) {
                        this.back = -1;
                        this.mode = 11;
                        continue block39;
                    }
                    if ((hereOp & 64) != 0) {
                        throw new DeflateException("invalid literal/length code");
                    }
                    this.extra = hereOp & 15;
                    this.mode = 21;
                }
                case 21: {
                    if (this.extra != 0) {
                        if (!this.NEEDBITS(this.extra)) break block39;
                        this.length += this.BITS(this.extra);
                        this.DROPBITS(this.extra);
                        this.back += this.extra;
                    }
                    this.was = this.length;
                    this.mode = 22;
                }
                case 22: {
                    do {
                        here = this.codes[this.distcode + this.BITS(this.distbits)];
                        hereOp = here >>> 24 & 255;
                        hereBits = here >>> 16 & 255;
                        hereVal = here & 65535;
                        if (hereBits <= this.bits) ** GOTO lbl366
                    } while (this.PULLBYTE());
                    break block39;
lbl366:
                    // 1 sources

                    if ((hereOp & 240) != 0) ** GOTO lbl381
                    last = here;
                    lastOp = hereOp;
                    lastBits = hereBits;
                    lastVal = hereVal;
                    do {
                        here = this.codes[this.distcode + lastVal + (this.BITS(lastBits + lastOp) >>> lastBits)];
                        hereOp = here >>> 24 & 255;
                        hereBits = here >>> 16 & 255;
                        hereVal = here & 65535;
                        if (lastBits + hereBits <= this.bits) ** GOTO lbl379
                    } while (this.PULLBYTE());
                    break block39;
lbl379:
                    // 1 sources

                    this.DROPBITS(lastBits);
                    this.back += lastBits;
lbl381:
                    // 2 sources

                    this.DROPBITS(hereBits);
                    this.back += hereBits;
                    if ((hereOp & 64) != 0) {
                        throw new DeflateException("invalid distance code");
                    }
                    this.offset = hereVal;
                    this.extra = hereOp & 15;
                    this.mode = 23;
                }
                case 23: {
                    if (this.extra != 0) {
                        if (!this.NEEDBITS(this.extra)) break block39;
                        this.offset += this.BITS(this.extra);
                        this.DROPBITS(this.extra);
                        this.back += this.extra;
                    }
                    this.mode = 24;
                }
                case 24: {
                    if (this.avail_out == 0) break block39;
                    copy = out - this.avail_out;
                    if (this.offset > copy) {
                        if ((copy = this.offset - copy) > this.whave && this.sane) {
                            throw new DeflateException("invalid distance too far back");
                        }
                        from = copy > this.wnext ? this.wsize - (copy -= this.wnext) : this.wnext - copy;
                        if (copy > this.length) {
                            copy = this.length;
                        }
                        if (copy > this.avail_out) {
                            copy = this.avail_out;
                        }
                        this.avail_out -= copy;
                        this.length -= copy;
                        do {
                            this.next_out[this.next_out_index++] = this.window[from++];
                        } while (--copy != 0);
                        from += copy;
                        this.next_out_index += copy;
                    } else {
                        from = this.next_out_index - this.offset;
                        copy = this.length;
                        if (copy > this.avail_out) {
                            copy = this.avail_out;
                        }
                        this.avail_out -= copy;
                        this.length -= copy;
                        do {
                            this.next_out[this.next_out_index++] = this.next_out[from++];
                        } while (--copy != 0);
                        from += copy;
                        this.next_out_index += copy;
                    }
                    copy = 0;
                    if (this.length != 0) continue block39;
                    this.mode = 20;
                    continue block39;
                }
                case 25: {
                    if (this.avail_out == 0) break block39;
                    this.next_out[this.next_out_index++] = (byte)this.length;
                    --this.avail_out;
                    this.mode = 20;
                    continue block39;
                }
                case 26: {
                    if (this.wrap != 0) {
                        if (!this.NEEDBITS(32)) break block39;
                        this.total_out += (long)(out -= this.avail_out);
                        this.total += (long)out;
                        if (out != 0) {
                            this.adler = this.check = this.UPDATE(this.check, this.next_out, this.next_out_index - out, out);
                        }
                        if ((this.flags != 0 ? this.hold : Integer.reverseBytes(this.hold)) != this.check) {
                            throw new DeflateException("incorrect data check");
                        }
                        if (this.output != null) {
                            this.window_buffer = this.window_buffer.index(this.next_out_index - out).limit(this.next_out_index).isPart(this.is_last == false);
                            this.output = this.output.feed(this.window_buffer);
                            if (this.window_buffer.isCont()) {
                                throw new DecoderException("truncated");
                            }
                        }
                        out = this.avail_out;
                        this.INITBITS();
                    }
                    this.mode = 27;
                }
                case 27: {
                    if (this.wrap != 0 && this.flags != 0) {
                        if (!this.NEEDBITS(32)) break block39;
                        if ((long)this.hold != this.total) {
                            throw new DeflateException("incorrect length check");
                        }
                        this.INITBITS();
                    }
                    this.mode = 28;
                }
                case 28: {
                    ret = 1;
                    break block39;
                }
                case 29: {
                    ret = -3;
                    break block39;
                }
                case 30: {
                    throw new DeflateException(-4);
                }
                default: {
                    throw new DeflateException(-2);
                }
            }
            break;
        }
        this.total_in += (long)(in -= this.avail_in);
        this.total_out += (long)(out -= this.avail_out);
        this.total += (long)out;
        if (this.wrap != 0 && out != 0) {
            this.adler = this.check = this.UPDATE(this.check, this.next_out, this.next_out_index - out, out);
        }
        if (this.wsize != 0 || out != 0 && this.mode < 29 && (this.mode < 26 || flush != 4)) {
            if (this.output != null) {
                this.window_buffer.index(this.next_out_index - out).limit(this.next_out_index).isPart(this.avail_in != 0 || this.is_last == false);
                this.output = this.output.feed(this.window_buffer);
                if (this.window_buffer.isCont()) {
                    throw new DecoderException("truncated");
                }
                this.compactwindow(this.next_out_index, out);
            } else {
                this.updatewindow(this.next_out, this.next_out_index, out);
            }
        }
        this.data_type = this.bits + (this.last != false ? 64 : 0) + (this.mode == 11 ? 128 : 0) + (this.mode == 19 || this.mode == 14 ? 256 : 0);
        if ((in == 0 && out == 0 || flush == 4) && ret == 0) {
            return true;
        }
        if (this.mode == 29) {
            throw new DeflateException(msg);
        }
        return false;
    }

    final void inflate_fast(int start) {
        int len;
        int in = this.next_in_index;
        int last = in + (this.avail_in - 5);
        int out = this.next_out_index;
        int beg = out - (start - this.avail_out);
        int end = out + (this.avail_out - 257);
        int dmax = this.dmax;
        int wsize = this.wsize;
        int whave = this.whave;
        int wnext = this.wnext;
        byte[] window = this.window;
        int hold = this.hold;
        int bits = this.bits;
        int lcode = this.lencode;
        int dcode = this.distcode;
        int lmask = (1 << this.lenbits) - 1;
        int dmask = (1 << this.distbits) - 1;
        block0: do {
            int op;
            if (bits < 15) {
                hold += (this.next_in[in++] & 0xFF) << bits;
                hold += (this.next_in[in++] & 0xFF) << (bits += 8);
                bits += 8;
            }
            int here = this.codes[lcode + (hold & lmask)];
            int hereOp = here >>> 24 & 0xFF;
            int hereBits = here >>> 16 & 0xFF;
            int hereVal = here & 0xFFFF;
            while (true) {
                op = hereBits;
                hold >>>= op;
                bits -= op;
                op = hereOp;
                if (op == 0) {
                    this.next_out[out++] = (byte)hereVal;
                    continue block0;
                }
                if ((op & 0x10) != 0) {
                    len = hereVal;
                    if ((op &= 0xF) != 0) {
                        if (bits < op) {
                            hold += (this.next_in[in++] & 0xFF) << bits;
                            bits += 8;
                        }
                        len += hold & (1 << op) - 1;
                        hold >>>= op;
                        bits -= op;
                    }
                    if (bits < 15) {
                        hold += (this.next_in[in++] & 0xFF) << bits;
                        hold += (this.next_in[in++] & 0xFF) << (bits += 8);
                        bits += 8;
                    }
                    here = this.codes[dcode + (hold & dmask)];
                    hereOp = here >>> 24 & 0xFF;
                    hereBits = here >>> 16 & 0xFF;
                    hereVal = here & 0xFFFF;
                    while (true) {
                        op = hereBits;
                        hold >>>= op;
                        bits -= op;
                        op = hereOp;
                        if ((op & 0x10) != 0) {
                            int from;
                            int dist = hereVal;
                            if (bits < (op &= 0xF)) {
                                hold += (this.next_in[in++] & 0xFF) << bits;
                                if ((bits += 8) < op) {
                                    hold += (this.next_in[in++] & 0xFF) << bits;
                                    bits += 8;
                                }
                            }
                            dist += hold & (1 << op) - 1;
                            hold >>>= op;
                            bits -= op;
                            op = out - beg;
                            if (dist > op) {
                                if ((op = dist - op) > whave && this.sane) {
                                    throw new DeflateException("invalid distance too far back");
                                }
                                from = 0;
                                if (wnext == 0) {
                                    from += wsize - op;
                                    if (op < len) {
                                        len -= op;
                                        do {
                                            this.next_out[out++] = window[from++];
                                        } while (--op != 0);
                                        from = out - dist;
                                    }
                                } else if (wnext < op) {
                                    from += wsize + wnext - op;
                                    if ((op -= wnext) < len) {
                                        len -= op;
                                        do {
                                            this.next_out[out++] = window[from++];
                                        } while (--op != 0);
                                        from = 0;
                                        if (wnext < len) {
                                            op = wnext;
                                            len -= op;
                                            do {
                                                this.next_out[out++] = window[from++];
                                            } while (--op != 0);
                                            from = out - dist;
                                        }
                                    }
                                } else {
                                    from += wnext - op;
                                    if (op < len) {
                                        len -= op;
                                        do {
                                            this.next_out[out++] = window[from++];
                                        } while (--op != 0);
                                        from = out - dist;
                                    }
                                }
                                while (len > 2) {
                                    this.next_out[out++] = this.next_out[from++];
                                    this.next_out[out++] = this.next_out[from++];
                                    this.next_out[out++] = this.next_out[from++];
                                    len -= 3;
                                }
                                if (len == 0) continue block0;
                                this.next_out[out++] = this.next_out[from++];
                                if (len <= 1) continue block0;
                                this.next_out[out++] = this.next_out[from++];
                                continue block0;
                            }
                            from = out - dist;
                            do {
                                this.next_out[out++] = this.next_out[from++];
                                this.next_out[out++] = this.next_out[from++];
                                this.next_out[out++] = this.next_out[from++];
                            } while ((len -= 3) > 2);
                            if (len == 0) continue block0;
                            this.next_out[out++] = this.next_out[from++];
                            if (len <= 1) continue block0;
                            this.next_out[out++] = this.next_out[from++];
                            continue block0;
                        }
                        if ((op & 0x40) != 0) break;
                        here = this.codes[dcode + hereVal + (hold & (1 << op) - 1)];
                        hereOp = here >>> 24 & 0xFF;
                        hereBits = here >>> 16 & 0xFF;
                        hereVal = here & 0xFFFF;
                    }
                    throw new DeflateException("invalid distance code");
                }
                if ((op & 0x40) != 0) break;
                here = this.codes[lcode + hereVal + (hold & (1 << op) - 1)];
                hereOp = here >>> 24 & 0xFF;
                hereBits = here >>> 16 & 0xFF;
                hereVal = here & 0xFFFF;
            }
            if ((op & 0x20) != 0) {
                this.mode = 11;
                break;
            }
            throw new DeflateException("invalid literal/length code");
        } while (in < last && out < end);
        len = bits >>> 3;
        this.next_in_index = in -= len;
        this.next_out_index = out;
        this.avail_in = in < last ? 5 + (last - in) : 5 - (in - last);
        this.avail_out = out < end ? 257 + (end - out) : 257 - (out - end);
        this.hold = hold &= (1 << (bits -= len << 3)) - 1;
        this.bits = bits;
    }

    final void fixedtables() {
        this.codes = fixed;
        this.lencode = 0;
        this.lenbits = 9;
        this.distcode = 512;
        this.distbits = 5;
    }

    final int inflate_table(int type, int offset, int length) {
        int here;
        short hereVal;
        int hereOp;
        int hereBits;
        short end;
        int base_index;
        int extra_index;
        short[] base;
        short[] extra;
        int min;
        int max;
        int sym;
        int len;
        short[] count = new short[16];
        short[] offs = new short[16];
        for (len = 0; len <= 15; ++len) {
            count[len] = 0;
        }
        for (sym = 0; sym < length; ++sym) {
            short s = this.lens[offset + sym];
            count[s] = (short)(count[s] + 1);
        }
        int root = type == 2 ? this.distbits : this.lenbits;
        for (max = 15; max >= 1 && count[max] == 0; --max) {
        }
        if (root > max) {
            root = max;
        }
        if (max == 0) {
            int hereOp2 = 64;
            int hereBits2 = 1;
            int hereVal2 = 0;
            int here2 = Inflate.code(hereOp2, hereBits2, hereVal2);
            this.codes[this.next++] = here2;
            this.codes[this.next++] = here2;
            if (type == 2) {
                this.distbits = 1;
            } else {
                this.lenbits = 1;
            }
            return 0;
        }
        for (min = 1; min < max && count[min] == 0; ++min) {
        }
        if (root < min) {
            root = min;
        }
        int left = 1;
        for (len = 1; len <= 15; ++len) {
            left <<= 1;
            if ((left -= count[len]) >= 0) continue;
            return -1;
        }
        if (left > 0 && (type == 0 || max != 1)) {
            return -1;
        }
        offs[1] = 0;
        for (len = 1; len < 15; ++len) {
            offs[len + 1] = (short)(offs[len] + count[len]);
        }
        for (sym = 0; sym < length; ++sym) {
            if (this.lens[offset + sym] == 0) continue;
            short s = this.lens[offset + sym];
            short s2 = offs[s];
            offs[s] = (short)(s2 + 1);
            this.work[s2] = (short)sym;
        }
        switch (type) {
            case 0: {
                extra = this.work;
                base = this.work;
                extra_index = 0;
                base_index = 0;
                end = 19;
                break;
            }
            case 1: {
                base = lbase;
                base_index = -257;
                extra = lext;
                extra_index = -257;
                end = 256;
                break;
            }
            default: {
                base = dbase;
                base_index = 0;
                extra = dext;
                extra_index = 0;
                end = -1;
            }
        }
        int huff = 0;
        sym = 0;
        len = min;
        int next = this.next;
        int curr = root;
        int drop = 0;
        int low = -1;
        int used = 1 << root;
        int mask = used - 1;
        if (type == 1 && used > 852 || type == 2 && used > 592) {
            return 1;
        }
        while (true) {
            int fill;
            hereBits = len - drop;
            if (this.work[sym] < end) {
                hereOp = 0;
                hereVal = this.work[sym];
            } else if (this.work[sym] > end) {
                hereOp = extra[extra_index + this.work[sym]];
                hereVal = base[base_index + this.work[sym]];
            } else {
                hereOp = 96;
                hereVal = 0;
            }
            here = Inflate.code(hereOp, hereBits, hereVal);
            int incr = 1 << len - drop;
            min = fill = 1 << curr;
            do {
                this.codes[next + (huff >>> drop) + (fill -= incr)] = here;
            } while (fill != 0);
            incr = 1 << len - 1;
            while ((huff & incr) != 0) {
                incr >>>= 1;
            }
            if (incr != 0) {
                huff &= incr - 1;
                huff += incr;
            } else {
                huff = 0;
            }
            ++sym;
            int n = len;
            count[n] = (short)(count[n] - 1);
            if (count[n] == 0) {
                if (len == max) break;
                len = this.lens[offset + this.work[sym]];
            }
            if (len <= root || (huff & mask) == low) continue;
            if (drop == 0) {
                drop = root;
            }
            next += min;
            curr = len - drop;
            left = 1 << curr;
            while (curr + drop < max && (left -= count[curr + drop]) > 0) {
                ++curr;
                left <<= 1;
            }
            if (type == 1 && (used += 1 << curr) > 852 || type == 2 && used > 592) {
                return 1;
            }
            low = huff & mask;
            this.codes[this.next + low] = Inflate.code(curr, root, next - this.next);
        }
        if (huff != 0) {
            hereOp = 64;
            hereBits = len - drop;
            hereVal = 0;
            this.codes[next + huff] = here = Inflate.code(hereOp, hereBits, hereVal);
        }
        this.next += used;
        if (type == 2) {
            this.distbits = root;
        } else {
            this.lenbits = root;
        }
        return 0;
    }

    final void compactwindow(int end, int copy) {
        if (end > this.wsize) {
            System.arraycopy(this.window, end - this.wsize, this.window, 0, this.wsize);
            this.wnext = this.wsize;
        } else {
            this.wnext = end;
        }
        this.whave = this.wnext;
    }

    final void updatewindow(byte[] output, int end, int copy) {
        if (this.window == null) {
            this.window = new byte[1 << this.wbits];
            this.window_buffer = Binary.inputBuffer((byte[])this.window);
        }
        if (this.wsize == 0) {
            this.wsize = 1 << this.wbits;
            this.wnext = 0;
            this.whave = 0;
        }
        if (copy >= this.wsize) {
            System.arraycopy(output, end - this.wsize, this.window, 0, this.wsize);
            this.wnext = 0;
            this.whave = this.wsize;
        } else {
            int dist = this.wsize - this.wnext;
            if (dist > copy) {
                dist = copy;
            }
            System.arraycopy(output, end - copy, this.window, this.wnext, dist);
            if ((copy -= dist) != 0) {
                System.arraycopy(output, end - copy, this.window, 0, copy);
                this.wnext = copy;
                this.whave = this.wsize;
            } else {
                this.wnext += dist;
                if (this.wnext == this.wsize) {
                    this.wnext = 0;
                }
                if (this.whave < this.wsize) {
                    this.whave += dist;
                }
            }
        }
    }

    final void INITBITS() {
        this.hold = 0;
        this.bits = 0;
    }

    final boolean PULLBYTE() {
        if (this.avail_in == 0) {
            return false;
        }
        --this.avail_in;
        this.hold += (this.next_in[this.next_in_index++] & 0xFF) << this.bits;
        this.bits += 8;
        return true;
    }

    final boolean NEEDBITS(int n) {
        while (this.bits < n) {
            if (this.PULLBYTE()) continue;
            return false;
        }
        return true;
    }

    final int BITS(int n) {
        return this.hold & (1 << n) - 1;
    }

    final void DROPBITS(int n) {
        this.hold >>>= n;
        this.bits -= n;
    }

    final void BYTEBITS() {
        this.hold >>>= this.bits & 7;
        this.bits -= this.bits & 7;
    }

    final int UPDATE(int check, byte[] buf, int off, int len) {
        if (this.wrap == 1) {
            return Adler32.adler32(check, buf, off, len);
        }
        if (this.wrap == 2) {
            return CRC32.crc32(check, buf, off, len);
        }
        return check;
    }

    final void CRC2(int check, byte[] hbuf, int word) {
        hbuf[0] = (byte)word;
        hbuf[1] = (byte)(word >>> 8);
        check = CRC32.crc32(check, hbuf, 0, 2);
    }

    final void CRC4(int check, byte[] hbuf, int word) {
        hbuf[0] = (byte)word;
        hbuf[1] = (byte)(word >> 8);
        hbuf[2] = (byte)(word >> 16);
        hbuf[3] = (byte)(word >> 24);
        check = CRC32.crc32(check, hbuf, 0, 4);
    }

    static int code(int op, int bits, int val) {
        return (op & 0xFF) << 24 | (bits & 0xFF) << 16 | val & 0xFFFF;
    }
}

