/*
 * Decompiled with CFR 0.152.
 */
package swim.store;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import swim.api.data.MapData;
import swim.store.MapDataBinding;
import swim.store.MapDataContext;
import swim.store.MapDataView;
import swim.store.StoreBinding;
import swim.structure.Form;
import swim.structure.Value;
import swim.util.Cursor;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;

public class MapDataProxy
implements MapDataBinding,
MapDataContext {
    protected final MapDataBinding dataBinding;
    protected MapDataContext dataContext;

    public MapDataProxy(MapDataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    public final MapDataBinding dataBinding() {
        return this.dataBinding;
    }

    @Override
    public final MapDataContext dataContext() {
        return this.dataContext;
    }

    @Override
    public void setDataContext(MapDataContext dataContext) {
        this.dataContext = dataContext;
        this.dataBinding.setDataContext(this);
    }

    @Override
    public StoreBinding storeBinding() {
        return this.dataBinding.storeBinding();
    }

    @Override
    public void setStoreBinding(StoreBinding storeBinding) {
        this.dataBinding.setStoreBinding(storeBinding);
    }

    @Override
    public <T> T unwrapData(Class<T> dataClass) {
        if (dataClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.dataBinding.unwrapData(dataClass);
    }

    @Override
    public Value name() {
        return this.dataBinding.name();
    }

    @Override
    public long dataSize() {
        return this.dataBinding.dataSize();
    }

    public Form<Value> keyForm() {
        return Form.forValue();
    }

    public <K> MapData<K, Value> keyForm(Form<K> keyForm) {
        return new MapDataView(this, keyForm, Form.forValue());
    }

    public <K> MapData<K, Value> keyClass(Class<K> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public Form<Value> valueForm() {
        return Form.forValue();
    }

    public <V> MapData<Value, V> valueForm(Form<V> valueForm) {
        return new MapDataView(this, Form.forValue(), valueForm);
    }

    public <V> MapData<Value, V> valueClass(Class<V> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    @Override
    public boolean isResident() {
        return this.dataBinding.isResident();
    }

    @Override
    public MapDataBinding isResident(boolean isResident) {
        this.dataBinding.isResident(isResident);
        return this;
    }

    @Override
    public boolean isTransient() {
        return this.dataBinding.isTransient();
    }

    @Override
    public MapDataBinding isTransient(boolean isTransient) {
        this.dataBinding.isTransient(isTransient);
        return this;
    }

    public boolean isEmpty() {
        return this.dataBinding.isEmpty();
    }

    public int size() {
        return this.dataBinding.size();
    }

    public boolean containsKey(Object key) {
        return this.dataBinding.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.dataBinding.containsValue(value);
    }

    public int indexOf(Object key) {
        return this.dataBinding.indexOf(key);
    }

    public Value get(Object key) {
        return (Value)this.dataBinding.get(key);
    }

    public Map.Entry<Value, Value> getEntry(Object key) {
        return this.dataBinding.getEntry(key);
    }

    public Map.Entry<Value, Value> getIndex(int index) {
        return this.dataBinding.getIndex(index);
    }

    public Map.Entry<Value, Value> firstEntry() {
        return this.dataBinding.firstEntry();
    }

    public Value firstKey() {
        return (Value)this.dataBinding.firstKey();
    }

    public Value firstValue() {
        return (Value)this.dataBinding.firstValue();
    }

    public Map.Entry<Value, Value> lastEntry() {
        return this.dataBinding.lastEntry();
    }

    public Value lastKey() {
        return (Value)this.dataBinding.lastKey();
    }

    public Value lastValue() {
        return (Value)this.dataBinding.lastValue();
    }

    public Map.Entry<Value, Value> nextEntry(Value key) {
        return this.dataBinding.nextEntry(key);
    }

    public Value nextKey(Value key) {
        return (Value)this.dataBinding.nextKey(key);
    }

    public Value nextValue(Value key) {
        return (Value)this.dataBinding.nextValue(key);
    }

    public Map.Entry<Value, Value> previousEntry(Value key) {
        return this.dataBinding.previousEntry(key);
    }

    public Value previousKey(Value key) {
        return (Value)this.dataBinding.previousKey(key);
    }

    public Value previousValue(Value key) {
        return (Value)this.dataBinding.previousValue(key);
    }

    public Value put(Value key, Value value) {
        return (Value)this.dataBinding.put(key, value);
    }

    public void putAll(Map<? extends Value, ? extends Value> items) {
        this.dataBinding.putAll(items);
    }

    public Value remove(Object key) {
        return (Value)this.dataBinding.remove(key);
    }

    public void drop(int lower) {
        this.dataBinding.drop(lower);
    }

    public void take(int upper) {
        this.dataBinding.take(upper);
    }

    public void clear() {
        this.dataBinding.clear();
    }

    public OrderedMap<Value, Value> headMap(Value toKey) {
        return this.dataBinding.headMap(toKey);
    }

    public OrderedMap<Value, Value> tailMap(Value fromKey) {
        return this.dataBinding.tailMap(fromKey);
    }

    public OrderedMap<Value, Value> subMap(Value fromKey, Value toKey) {
        return this.dataBinding.subMap(fromKey, toKey);
    }

    public Set<Map.Entry<Value, Value>> entrySet() {
        return this.dataBinding.entrySet();
    }

    public Set<Value> keySet() {
        return this.dataBinding.keySet();
    }

    public Collection<Value> values() {
        return this.dataBinding.values();
    }

    public OrderedMapCursor<Value, Value> iterator() {
        return this.dataBinding.iterator();
    }

    public Cursor<Value> keyIterator() {
        return this.dataBinding.keyIterator();
    }

    public Cursor<Value> valueIterator() {
        return this.dataBinding.valueIterator();
    }

    public OrderedMap<Value, Value> snapshot() {
        return this.dataBinding.snapshot();
    }

    public Comparator<? super Value> comparator() {
        return this.dataBinding.comparator();
    }

    @Override
    public void close() {
        this.dataBinding.close();
    }

    @Override
    public void didChange() {
        this.dataContext.didChange();
    }

    @Override
    public void didCommit() {
        this.dataContext.didCommit();
    }

    @Override
    public void didUpdate(Value key, Value newValue, Value oldValue) {
        this.dataContext.didUpdate(key, newValue, oldValue);
    }

    @Override
    public void didRemove(Value key, Value oldValue) {
        this.dataContext.didRemove(key, oldValue);
    }

    @Override
    public void didDrop(long lower) {
        this.dataContext.didDrop(lower);
    }

    @Override
    public void didTake(long upper) {
        this.dataContext.didTake(upper);
    }

    @Override
    public void didClear() {
        this.dataContext.didClear();
    }
}

