/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import swim.codec.Output;
import swim.codec.OutputSettings;
import swim.structure.Text;

final class TextOutput
extends Output<Text> {
    final StringBuilder builder;
    OutputSettings settings;

    TextOutput(StringBuilder builder, OutputSettings settings) {
        this.builder = builder;
        this.settings = settings;
    }

    public boolean isCont() {
        return true;
    }

    public boolean isFull() {
        return false;
    }

    public boolean isDone() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public boolean isPart() {
        return false;
    }

    public Output<Text> isPart(boolean isPart) {
        return this;
    }

    public Output<Text> write(int codePoint) {
        this.builder.appendCodePoint(codePoint);
        return this;
    }

    public Output<Text> write(String string) {
        this.builder.append(string);
        return this;
    }

    public Output<Text> writeln(String string) {
        this.builder.append(string).append(this.settings.lineSeparator());
        return this;
    }

    public Output<Text> writeln() {
        this.builder.append(this.settings.lineSeparator());
        return this;
    }

    public OutputSettings settings() {
        return this.settings;
    }

    public Output<Text> settings(OutputSettings settings) {
        this.settings = settings;
        return this;
    }

    public Text bind() {
        return Text.from(this.builder.toString());
    }

    public Output<Text> clone() {
        return new TextOutput(new StringBuilder(this.builder.toString()), this.settings);
    }

    public String toString() {
        return this.builder.toString();
    }
}

