/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Value;

public final class LongForm
extends Form<Long> {
    final Long unit;

    public LongForm(Long unit) {
        this.unit = unit;
    }

    @Override
    public Long unit() {
        return this.unit;
    }

    @Override
    public Form<Long> unit(Long unit) {
        return new LongForm(unit);
    }

    @Override
    public Class<Long> type() {
        return Long.class;
    }

    @Override
    public Item mold(Long value) {
        if (value != null) {
            return Num.from(value);
        }
        return Item.extant();
    }

    @Override
    public Long cast(Item item) {
        Value value = item.target();
        try {
            return value.longValue();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }
}

