/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.http.WebSocketExtension;
import swim.ws.WsDecoder;
import swim.ws.WsDeflateClientEngine;
import swim.ws.WsDeflateServerEngine;
import swim.ws.WsEncoder;
import swim.ws.WsEngineSettings;
import swim.ws.WsStandardClientEngine;
import swim.ws.WsStandardServerEngine;

public abstract class WsEngine {
    private static WsEngine standardClientEngine;
    private static WsEngine standardServerEngine;

    public abstract WsDecoder decoder();

    public abstract WsEncoder encoder();

    public abstract WsEngine extension(WebSocketExtension var1, WsEngineSettings var2);

    public WsEngine extensions(Iterable<WebSocketExtension> extensions, WsEngineSettings settings) {
        WsEngine engine = this;
        for (WebSocketExtension extension : extensions) {
            engine = engine.extension(extension, settings);
        }
        return engine;
    }

    public static WsEngine standardClientEngine() {
        if (standardClientEngine == null) {
            standardClientEngine = new WsStandardClientEngine();
        }
        return standardClientEngine;
    }

    public static WsEngine standardServerEngine() {
        if (standardServerEngine == null) {
            standardServerEngine = new WsStandardServerEngine();
        }
        return standardServerEngine;
    }

    public static WsEngine deflateClientEngine(WebSocketExtension extension, WsEngineSettings settings) {
        return WsDeflateClientEngine.from(extension, settings);
    }

    public static WsEngine deflateServerEngine(WebSocketExtension extension, WsEngineSettings settings) {
        return WsDeflateServerEngine.from(extension, settings);
    }
}

