/*
 * Decompiled with CFR 0.152.
 */
package swim.api.agent;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.Agent;
import swim.api.agent.AgentContext;
import swim.api.agent.AgentFactory;
import swim.api.agent.AgentType;
import swim.api.auth.Identity;
import swim.api.data.DataFactory;
import swim.api.data.ListData;
import swim.api.data.MapData;
import swim.api.data.SpatialData;
import swim.api.data.ValueData;
import swim.api.downlink.EventDownlink;
import swim.api.downlink.ListDownlink;
import swim.api.downlink.MapDownlink;
import swim.api.downlink.ValueDownlink;
import swim.api.http.HttpDownlink;
import swim.api.lane.CommandLane;
import swim.api.lane.DemandLane;
import swim.api.lane.DemandMapLane;
import swim.api.lane.JoinMapLane;
import swim.api.lane.JoinValueLane;
import swim.api.lane.Lane;
import swim.api.lane.LaneFactory;
import swim.api.lane.ListLane;
import swim.api.lane.MapLane;
import swim.api.lane.SpatialLane;
import swim.api.lane.SupplyLane;
import swim.api.lane.ValueLane;
import swim.api.ref.HostRef;
import swim.api.ref.LaneRef;
import swim.api.ref.NodeRef;
import swim.api.ref.SwimRef;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.concurrent.TimerFunction;
import swim.concurrent.TimerRef;
import swim.math.R2Shape;
import swim.math.Z2Form;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;

public class AbstractAgent
implements Agent,
LaneFactory,
DataFactory,
SwimRef,
Log,
Schedule {
    protected final AgentContext context;

    public AbstractAgent(AgentContext context) {
        this.context = context;
    }

    public AbstractAgent() {
        this(SwimContext.getAgentContext());
    }

    @Override
    public AgentContext agentContext() {
        return this.context;
    }

    @Override
    public void willOpen() {
    }

    @Override
    public void didOpen() {
    }

    @Override
    public void willLoad() {
    }

    @Override
    public void didLoad() {
    }

    @Override
    public void willStart() {
    }

    @Override
    public void didStart() {
    }

    @Override
    public void willStop() {
    }

    @Override
    public void didStop() {
    }

    @Override
    public void willUnload() {
    }

    @Override
    public void didUnload() {
    }

    @Override
    public void willClose() {
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    public final Uri hostUri() {
        return this.context.hostUri();
    }

    public final Uri nodeUri() {
        return this.context.nodeUri();
    }

    public final AgentType<?> agentType() {
        return this.context.agentType();
    }

    public final Value props() {
        return this.context.props();
    }

    public final Value getProp(Value key) {
        return this.context.getProp(key);
    }

    public final Value getProp(String name) {
        return this.context.getProp(name);
    }

    public final Schedule schedule() {
        return this.context.schedule();
    }

    public final Stage stage() {
        return this.context.stage();
    }

    public final Lane lane() {
        return this.context.lane();
    }

    public final Link link() {
        return this.context.link();
    }

    public FingerTrieSeq<Agent> traits() {
        return this.context.traits();
    }

    public <A extends Agent> A getTrait(Value props) {
        return this.context.getTrait(props);
    }

    public <A extends Agent> A getTrait(String name) {
        return this.context.getTrait(name);
    }

    public <A extends Agent> A getTrait(Class<A> agentClass) {
        return this.context.getTrait(agentClass);
    }

    public <A extends Agent> A addTrait(Value props, AgentFactory<A> agentFactory) {
        return this.context.addTrait(props, agentFactory);
    }

    public <A extends Agent> A addTrait(String name, AgentFactory<A> agentFactory) {
        return this.context.addTrait(name, agentFactory);
    }

    public <A extends Agent> A addTrait(Value props, Class<A> agentClass) {
        return this.context.addTrait(props, agentClass);
    }

    public <A extends Agent> A addTrait(String name, Class<A> agentClass) {
        return this.context.addTrait(name, agentClass);
    }

    public void removeTrait(Value props) {
        this.context.removeTrait(props);
    }

    public void removeTrait(String name) {
        this.context.removeTrait(name);
    }

    public boolean isSecure() {
        Link link = this.link();
        return link != null && link.isSecure();
    }

    public String securityProtocol() {
        Link link = this.link();
        if (link != null) {
            return link.securityProtocol();
        }
        return null;
    }

    public String cipherSuite() {
        Link link = this.link();
        if (link != null) {
            return link.cipherSuite();
        }
        return null;
    }

    public InetSocketAddress localAddress() {
        Link link = this.link();
        if (link != null) {
            return link.localAddress();
        }
        return null;
    }

    public Identity localIdentity() {
        Link link = this.link();
        if (link != null) {
            return link.localIdentity();
        }
        return null;
    }

    public Principal localPrincipal() {
        Link link = this.link();
        if (link != null) {
            return link.localPrincipal();
        }
        return null;
    }

    public Collection<Certificate> localCertificates() {
        Link link = this.link();
        if (link != null) {
            return link.localCertificates();
        }
        return FingerTrieSeq.empty();
    }

    public InetSocketAddress remoteAddress() {
        Link link = this.link();
        if (link != null) {
            return link.remoteAddress();
        }
        return null;
    }

    public Identity remoteIdentity() {
        Link link = this.link();
        if (link != null) {
            return link.remoteIdentity();
        }
        return null;
    }

    public Principal remotePrincipal() {
        Link link = this.link();
        if (link != null) {
            return link.remotePrincipal();
        }
        return null;
    }

    public Collection<Certificate> remoteCertificates() {
        Link link = this.link();
        if (link != null) {
            return link.remoteCertificates();
        }
        return FingerTrieSeq.empty();
    }

    @Override
    public final <V> CommandLane<V> commandLane() {
        return this.context.commandLane();
    }

    @Override
    public final <V> DemandLane<V> demandLane() {
        return this.context.demandLane();
    }

    @Override
    public final <K, V> DemandMapLane<K, V> demandMapLane() {
        return this.context.demandMapLane();
    }

    @Override
    public final <L, K, V> JoinMapLane<L, K, V> joinMapLane() {
        return this.context.joinMapLane();
    }

    @Override
    public final <K, V> JoinValueLane<K, V> joinValueLane() {
        return this.context.joinValueLane();
    }

    @Override
    public final <V> ListLane<V> listLane() {
        return this.context.listLane();
    }

    @Override
    public final <K, V> MapLane<K, V> mapLane() {
        return this.context.mapLane();
    }

    @Override
    public final <K, S, V> SpatialLane<K, S, V> spatialLane(Z2Form<S> shapeForm) {
        return this.context.spatialLane(shapeForm);
    }

    @Override
    public final <K, V> SpatialLane<K, R2Shape, V> geospatialLane() {
        return this.context.geospatialLane();
    }

    @Override
    public final <V> SupplyLane<V> supplyLane() {
        return this.context.supplyLane();
    }

    @Override
    public final <V> ValueLane<V> valueLane() {
        return this.context.valueLane();
    }

    @Override
    public final ListData<Value> listData(Value name) {
        return this.context.listData(name);
    }

    @Override
    public final ListData<Value> listData(String name) {
        return this.context.listData(name);
    }

    @Override
    public final MapData<Value, Value> mapData(Value name) {
        return this.context.mapData(name);
    }

    @Override
    public final MapData<Value, Value> mapData(String name) {
        return this.context.mapData(name);
    }

    @Override
    public final <S> SpatialData<Value, S, Value> spatialData(Value name, Z2Form<S> shapeForm) {
        return this.context.spatialData(name, shapeForm);
    }

    @Override
    public final <S> SpatialData<Value, S, Value> spatialData(String name, Z2Form<S> shapeForm) {
        return this.context.spatialData(name, shapeForm);
    }

    @Override
    public final SpatialData<Value, R2Shape, Value> geospatialData(Value name) {
        return this.context.geospatialData(name);
    }

    @Override
    public final SpatialData<Value, R2Shape, Value> geospatialData(String name) {
        return this.context.geospatialData(name);
    }

    @Override
    public final ValueData<Value> valueData(Value name) {
        return this.context.valueData(name);
    }

    @Override
    public final ValueData<Value> valueData(String name) {
        return this.context.valueData(name);
    }

    @Override
    public final EventDownlink<Value> downlink() {
        return this.context.downlink();
    }

    @Override
    public final ListDownlink<Value> downlinkList() {
        return this.context.downlinkList();
    }

    @Override
    public final MapDownlink<Value, Value> downlinkMap() {
        return this.context.downlinkMap();
    }

    @Override
    public final ValueDownlink<Value> downlinkValue() {
        return this.context.downlinkValue();
    }

    public final <V> HttpDownlink<V> downlinkHttp() {
        return this.context.downlinkHttp();
    }

    @Override
    public final HostRef hostRef(Uri hostUri) {
        return this.context.hostRef(hostUri);
    }

    @Override
    public final HostRef hostRef(String hostUri) {
        return this.context.hostRef(hostUri);
    }

    @Override
    public final NodeRef nodeRef(Uri hostUri, Uri nodeUri) {
        return this.context.nodeRef(hostUri, nodeUri);
    }

    @Override
    public final NodeRef nodeRef(String hostUri, String nodeUri) {
        return this.context.nodeRef(hostUri, nodeUri);
    }

    @Override
    public final NodeRef nodeRef(Uri nodeUri) {
        return this.context.nodeRef(nodeUri);
    }

    @Override
    public final NodeRef nodeRef(String nodeUri) {
        return this.context.nodeRef(nodeUri);
    }

    @Override
    public final LaneRef laneRef(Uri hostUri, Uri nodeUri, Uri laneUri) {
        return this.context.laneRef(hostUri, nodeUri, laneUri);
    }

    @Override
    public final LaneRef laneRef(String hostUri, String nodeUri, String laneUri) {
        return this.context.laneRef(hostUri, nodeUri, laneUri);
    }

    @Override
    public final LaneRef laneRef(Uri nodeUri, Uri laneUri) {
        return this.context.laneRef(nodeUri, laneUri);
    }

    @Override
    public final LaneRef laneRef(String nodeUri, String laneUri) {
        return this.context.laneRef(nodeUri, laneUri);
    }

    @Override
    public final void command(Uri hostUri, Uri nodeUri, Uri laneUri, float prio, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, prio, body);
    }

    @Override
    public final void command(String hostUri, String nodeUri, String laneUri, float prio, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, prio, body);
    }

    @Override
    public final void command(Uri hostUri, Uri nodeUri, Uri laneUri, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, body);
    }

    @Override
    public final void command(String hostUri, String nodeUri, String laneUri, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, body);
    }

    @Override
    public final void command(Uri nodeUri, Uri laneUri, float prio, Value body) {
        this.context.command(nodeUri, laneUri, prio, body);
    }

    @Override
    public final void command(String nodeUri, String laneUri, float prio, Value body) {
        this.context.command(nodeUri, laneUri, prio, body);
    }

    @Override
    public final void command(Uri nodeUri, Uri laneUri, Value body) {
        this.context.command(nodeUri, laneUri, body);
    }

    @Override
    public final void command(String nodeUri, String laneUri, Value body) {
        this.context.command(nodeUri, laneUri, body);
    }

    public void trace(Object message) {
        Link link = this.link();
        if (link != null) {
            link.trace(message);
        } else {
            this.context.trace(message);
        }
    }

    public void debug(Object message) {
        Link link = this.link();
        if (link != null) {
            link.debug(message);
        } else {
            this.context.debug(message);
        }
    }

    public void info(Object message) {
        Link link = this.link();
        if (link != null) {
            link.info(message);
        } else {
            this.context.info(message);
        }
    }

    public void warn(Object message) {
        Link link = this.link();
        if (link != null) {
            link.warn(message);
        } else {
            this.context.warn(message);
        }
    }

    public void error(Object message) {
        Link link = this.link();
        if (link != null) {
            link.error(message);
        } else {
            this.context.error(message);
        }
    }

    public final TimerRef timer(TimerFunction timer) {
        return this.schedule().timer(timer);
    }

    public final TimerRef setTimer(long millis, TimerFunction timer) {
        return this.schedule().setTimer(millis, timer);
    }

    @Override
    public void close() {
        this.context.close();
    }
}

