/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.concurrent.ThreadLocalRandom;
import swim.collections.STreePage;

public abstract class STreeContext<T> {
    protected Object identify(T value) {
        return ThreadLocalRandom.current().nextLong();
    }

    protected int compare(Object x, Object y) {
        return ((Comparable)x).compareTo(y);
    }

    protected int pageSplitSize() {
        return 32;
    }

    protected boolean pageShouldSplit(STreePage<T> page) {
        return page.arity() > this.pageSplitSize();
    }

    protected boolean pageShouldMerge(STreePage<T> page) {
        return page.arity() < this.pageSplitSize() >>> 1;
    }
}

