/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Map;
import swim.collections.STreeContext;
import swim.collections.STreeLeaf;
import swim.collections.STreeNodeCursor;
import swim.collections.STreePage;
import swim.util.Cursor;

final class STreeNode<T>
extends STreePage<T> {
    final STreePage<T>[] pages;
    final int[] knots;
    final int size;

    STreeNode(STreePage<T>[] pages, int[] knots, int size) {
        this.pages = pages;
        if (knots == null || size < 0) {
            knots = new int[pages.length - 1];
            size = 0;
            int n = knots.length;
            for (int i = 0; i < n; ++i) {
                knots[i] = size += pages[i].size();
            }
            size += pages[knots.length].size();
        }
        this.knots = knots;
        this.size = size;
    }

    STreeNode(STreePage<T>[] pages) {
        this(pages, null, -1);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int arity() {
        return this.pages.length;
    }

    @Override
    public boolean contains(Object value) {
        STreePage<T>[] pages = this.pages;
        int n = pages.length;
        for (int i = 0; i < n; ++i) {
            if (!pages[i].contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object object) {
        STreePage<T>[] pages = this.pages;
        int k = 0;
        for (STreePage<T> page : pages) {
            int i = page.indexOf(object);
            if (i >= 0) {
                return k + i;
            }
            k += page.size();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        STreePage<T>[] pages = this.pages;
        int k = this.size;
        for (int x = pages.length - 1; x >= 0; --x) {
            STreePage<T> page = pages[x];
            int i = page.lastIndexOf(object);
            k -= page.size();
            if (i < 0) continue;
            return k + 1;
        }
        return -1;
    }

    @Override
    public T get(int index) {
        int x = this.lookup(index);
        x = x >= 0 ? ++x : -(x + 1);
        int i = x == 0 ? index : index - this.knots[x - 1];
        return this.pages[x].get(i);
    }

    @Override
    public Map.Entry<Object, T> getEntry(int index) {
        int x = this.lookup(index);
        x = x >= 0 ? ++x : -(x + 1);
        int i = x == 0 ? index : index - this.knots[x - 1];
        return this.pages[x].getEntry(i);
    }

    @Override
    public STreeNode<T> updated(int index, T newValue, STreeContext<T> tree) {
        int x = this.lookup(index);
        x = x >= 0 ? ++x : -(x + 1);
        int i = x == 0 ? index : index - this.knots[x - 1];
        STreePage<T> oldPage = this.pages[x];
        STreePage<T> newPage = oldPage.updated(i, newValue, tree);
        if (oldPage != newPage) {
            if (oldPage.size() != newPage.size() && tree.pageShouldSplit(newPage)) {
                return this.updatedPageSplit(x, newPage, oldPage);
            }
            return this.updatedPage(x, newPage, oldPage);
        }
        return this;
    }

    private STreeNode<T> updatedPage(int x, STreePage<T> newPage, STreePage<T> oldPage) {
        int newSize;
        int[] newKnots;
        STreePage<T>[] oldPages = this.pages;
        int n = oldPages.length;
        STreePage[] newPages = new STreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, n);
        newPages[x] = newPage;
        int[] oldKnots = this.knots;
        if (n - 1 > 0) {
            newKnots = new int[n - 1];
            if (x > 0) {
                System.arraycopy(oldKnots, 0, newKnots, 0, x);
                newSize = oldKnots[x - 1];
            } else {
                newSize = 0;
            }
            for (int i = x; i < n - 1; ++i) {
                newKnots[i] = newSize += newPages[i].size();
            }
            newSize += newPages[n - 1].size();
        } else {
            newKnots = new int[]{};
            newSize = 0;
        }
        return new STreeNode<T>(newPages, newKnots, newSize);
    }

    private STreeNode<T> updatedPageSplit(int x, STreePage<T> newPage, STreePage<T> oldPage) {
        STreePage<T>[] oldPages = this.pages;
        int n = oldPages.length + 1;
        STreePage[] newPages = new STreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, x);
        int y = newPage.arity() >>> 1;
        STreePage<T> newLeftPage = newPage.splitLeft(y);
        STreePage<T> newRightPage = newPage.splitRight(y);
        newPages[x] = newLeftPage;
        newPages[x + 1] = newRightPage;
        System.arraycopy(oldPages, x + 1, newPages, x + 2, n - (x + 2));
        return new STreeNode<T>(newPages);
    }

    private STreeNode<T> updatedPageMerge(int x, STreeNode<T> newPage, STreePage<T> oldPage) {
        STreePage<T>[] oldPages = this.pages;
        STreePage<T>[] midPages = newPage.pages;
        int k = midPages.length;
        int n = oldPages.length + (k - 1);
        STreePage[] newPages = new STreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, x);
        System.arraycopy(midPages, 0, newPages, x, k);
        System.arraycopy(oldPages, x + 1, newPages, x + k, n - (x + k));
        return new STreeNode<T>(newPages);
    }

    @Override
    public STreeNode<T> inserted(int index, T newValue, Object id, STreeContext<T> tree) {
        int x = this.lookup(index);
        x = x >= 0 ? ++x : -(x + 1);
        int i = x == 0 ? index : index - this.knots[x - 1];
        STreePage<T> oldPage = this.pages[x];
        STreePage<T> newPage = oldPage.inserted(i, newValue, id, tree);
        if (oldPage != newPage) {
            if (tree.pageShouldSplit(newPage)) {
                return this.updatedPageSplit(x, newPage, oldPage);
            }
            return this.updatedPage(x, newPage, oldPage);
        }
        return this;
    }

    @Override
    public STreePage<T> removed(int index, STreeContext<T> tree) {
        int x = this.lookup(index);
        x = x >= 0 ? ++x : -(x + 1);
        int i = x == 0 ? index : index - this.knots[x - 1];
        STreePage<T> oldPage = this.pages[x];
        STreePage<T> newPage = oldPage.removed(i, tree);
        if (oldPage != newPage) {
            return this.replacedPage(x, newPage, oldPage, tree);
        }
        return this;
    }

    private STreePage<T> replacedPage(int x, STreePage<T> newPage, STreePage<T> oldPage, STreeContext<T> tree) {
        if (!newPage.isEmpty()) {
            if (newPage instanceof STreeNode && tree.pageShouldMerge(newPage)) {
                return this.updatedPageMerge(x, (STreeNode)newPage, oldPage);
            }
            return this.updatedPage(x, newPage, oldPage);
        }
        if (this.pages.length > 2) {
            return this.removedPage(x, newPage, oldPage);
        }
        if (this.pages.length > 1) {
            if (x == 0) {
                return this.pages[1];
            }
            return this.pages[0];
        }
        return STreeLeaf.empty();
    }

    private STreeNode<T> removedPage(int x, STreePage<T> newPage, STreePage<T> oldPage) {
        int newSize;
        STreePage<T>[] oldPages = this.pages;
        int n = oldPages.length - 1;
        STreePage[] newPages = new STreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, x);
        System.arraycopy(oldPages, x + 1, newPages, x, n - x);
        int[] oldKnots = this.knots;
        int[] newKnots = new int[n - 1];
        if (x > 0) {
            System.arraycopy(oldKnots, 0, newKnots, 0, x);
            newSize = oldKnots[x - 1];
        } else {
            newSize = 0;
        }
        for (int i = x; i < n - 1; ++i) {
            newKnots[i] = newSize += newPages[i].size();
        }
        return new STreeNode<T>(newPages, newKnots, newSize += newPages[n - 1].size());
    }

    @Override
    public STreePage<T> removed(Object value, STreeContext<T> tree) {
        STreePage<T>[] pages = this.pages;
        int n = pages.length;
        for (int x = 0; x < n; ++x) {
            STreePage<T> oldPage = pages[x];
            STreePage<T> newPage = oldPage.removed(value, tree);
            if (oldPage == newPage) continue;
            return this.replacedPage(x, newPage, oldPage, tree);
        }
        return this;
    }

    @Override
    public STreePage<T> drop(int lower, STreeContext<T> tree) {
        if (lower > 0) {
            if (lower < this.size) {
                int x = this.lookup(lower);
                x = x >= 0 ? ++x : -(x + 1);
                int i = x == 0 ? lower : lower - this.knots[x - 1];
                STreePage<T>[] oldPages = this.pages;
                int k = oldPages.length;
                int n = k - x;
                if (n > 1) {
                    STreeNode<T> newNode;
                    if (x > 0) {
                        STreePage[] newPages = new STreePage[n];
                        System.arraycopy(oldPages, x, newPages, 0, n);
                        newNode = new STreeNode<T>(newPages);
                    } else {
                        newNode = this;
                    }
                    if (i > 0) {
                        STreePage<T> oldPage = oldPages[x];
                        STreePage<T> newPage = oldPage.drop(i, tree);
                        return super.replacedPage(0, newPage, oldPage, tree);
                    }
                    return newNode;
                }
                return oldPages[x].drop(i, tree);
            }
            return STreeLeaf.empty();
        }
        return this;
    }

    @Override
    public STreePage<T> take(int upper, STreeContext<T> tree) {
        if (upper < this.size) {
            if (upper > 0) {
                int n;
                int x = this.lookup(upper);
                x = x >= 0 ? ++x : -(x + 1);
                int i = x == 0 ? upper : upper - this.knots[x - 1];
                STreePage<T>[] oldPages = this.pages;
                int k = oldPages.length;
                int n2 = n = i == 0 ? x : x + 1;
                if (n > 1) {
                    STreeNode<T> newNode;
                    if (x < k) {
                        STreePage[] newPages = new STreePage[n];
                        System.arraycopy(oldPages, 0, newPages, 0, n);
                        int[] newKnots = new int[n - 1];
                        System.arraycopy(this.knots, 0, newKnots, 0, n - 1);
                        int newSize = newKnots[n - 2] + newPages[n - 1].size();
                        newNode = new STreeNode<T>(newPages, newKnots, newSize);
                    } else {
                        newNode = this;
                    }
                    if (i > 0) {
                        STreePage<T> oldPage = oldPages[x];
                        STreePage<T> newPage = oldPage.take(i, tree);
                        return newNode.replacedPage(x, newPage, oldPage, tree);
                    }
                    return newNode;
                }
                if (i > 0) {
                    return oldPages[0].take(i, tree);
                }
                return oldPages[0];
            }
            return STreeLeaf.empty();
        }
        return this;
    }

    @Override
    public STreeNode<T> balanced(STreeContext<T> tree) {
        if (this.pages.length > 1 && tree.pageShouldSplit(this)) {
            int x = this.knots.length >>> 1;
            return this.split(x);
        }
        return this;
    }

    @Override
    public STreeNode<T> split(int x) {
        STreePage[] newPages = new STreePage[2];
        STreePage newLeftPage = this.splitLeft(x);
        STreePage newRightPage = this.splitRight(x);
        newPages[0] = newLeftPage;
        newPages[1] = newRightPage;
        int[] newKnots = new int[]{((STreeNode)newLeftPage).size()};
        return new STreeNode<T>(newPages, newKnots, this.size);
    }

    @Override
    public STreeNode<T> splitLeft(int x) {
        STreePage<T>[] oldPages = this.pages;
        STreePage[] newPages = new STreePage[x + 1];
        System.arraycopy(oldPages, 0, newPages, 0, x + 1);
        int[] oldKnots = this.knots;
        int[] newKnots = new int[x];
        System.arraycopy(oldKnots, 0, newKnots, 0, x);
        int newSize = 0;
        for (int i = 0; i <= x; ++i) {
            newSize += newPages[i].size();
        }
        return new STreeNode<T>(newPages, newKnots, newSize);
    }

    @Override
    public STreeNode<T> splitRight(int x) {
        int newSize;
        STreePage<T>[] oldPages = this.pages;
        int y = oldPages.length - (x + 1);
        STreePage[] newPages = new STreePage[y];
        System.arraycopy(oldPages, x + 1, newPages, 0, y);
        int[] newKnots = new int[y - 1];
        if (y > 0) {
            newSize = newPages[0].size();
            for (int i = 1; i < y; ++i) {
                newKnots[i - 1] = newSize;
                newSize += newPages[i].size();
            }
        } else {
            newSize = 0;
        }
        return new STreeNode<T>(newPages, newKnots, newSize);
    }

    @Override
    public void copyToArray(Object[] array, int offset) {
        for (STreePage<T> page : this.pages) {
            page.copyToArray(array, offset);
            offset += page.size();
        }
    }

    @Override
    public Cursor<Map.Entry<Object, T>> entryIterator() {
        return new STreeNodeCursor<T>(this.pages);
    }

    @Override
    public Cursor<Map.Entry<Object, T>> reverseEntryIterator() {
        return new STreeNodeCursor<T>(this.pages, this.size, this.pages.length);
    }

    private int lookup(int index) {
        int lo = 0;
        int hi = this.knots.length - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            if (index > this.knots[mid]) {
                lo = mid + 1;
                continue;
            }
            if (index < this.knots[mid]) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return -(lo + 1);
    }
}

