/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import swim.collections.FingerTrieSeq;
import swim.io.ClientAuth;
import swim.io.TlsSettings;
import swim.structure.Form;
import swim.structure.FormException;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class TlsSettingsForm
extends Form<TlsSettings> {
    TlsSettingsForm() {
    }

    public String tag() {
        return "tls";
    }

    public Class<?> type() {
        return TlsSettings.class;
    }

    public Item mold(TlsSettings settings) {
        if (settings != null) {
            Record header = Record.create((int)2).slot("protocol", settings.sslContext.getProtocol()).slot("provider", settings.sslContext.getProvider().getName());
            Record record = Record.create((int)4).attr(this.tag(), (Value)header);
            if (settings.clientAuth != ClientAuth.NONE) {
                record.slot("clientAuth", ClientAuth.form().mold((Object)settings.clientAuth).toValue());
            }
            if (settings.cipherSuites != null) {
                Record cipherSuites = Record.create((int)settings.cipherSuites.size());
                for (String cipherSuite : settings.cipherSuites) {
                    cipherSuites.item(cipherSuite);
                }
                record.slot("cipherSuites", (Value)cipherSuites);
            }
            if (settings.protocols != null) {
                Record protocols = Record.create((int)settings.protocols.size());
                for (String protocol : settings.protocols) {
                    protocols.item(protocol);
                }
                record.slot("protocols", (Value)protocols);
            }
            return record;
        }
        return Item.extant();
    }

    public TlsSettings cast(Item item) {
        Value value = item.toValue();
        Value header = value.getAttr(this.tag());
        if (header.isDefined()) {
            FingerTrieSeq protocols;
            FingerTrieSeq cipherSuites;
            SSLContext sslContext;
            String tlsProtocol = header.get("protocol").stringValue(System.getProperty("swim.tls.protocol", "TLS"));
            String tlsProvider = header.get("provider").stringValue(System.getProperty("swim.tls.provider"));
            String tlsRandom = header.get("random").stringValue(System.getProperty("swim.tls.random"));
            KeyManager[] keyManagers = TlsSettings.loadKeyManagers();
            TrustManager[] trustManagers = TlsSettings.loadTrustManagers();
            for (Item member : value) {
                Object trustManagerFactory;
                KeyManagerFactory keyManagerFactory = this.castKeyManagerFactory(member.toValue());
                if (keyManagerFactory != null) {
                    if (keyManagers == null) {
                        keyManagers = keyManagerFactory.getKeyManagers();
                    } else {
                        KeyManager[] newKeyManagers = keyManagerFactory.getKeyManagers();
                        if (newKeyManagers != null && newKeyManagers.length > 0) {
                            KeyManager[] oldKeyManagers = keyManagers;
                            keyManagers = new KeyManager[oldKeyManagers.length + newKeyManagers.length];
                            System.arraycopy(oldKeyManagers, 0, keyManagers, 0, oldKeyManagers.length);
                            System.arraycopy(newKeyManagers, 0, keyManagers, oldKeyManagers.length, newKeyManagers.length);
                        }
                    }
                }
                if ((trustManagerFactory = this.castTrustManagerFactory(member.toValue())) == null) continue;
                if (trustManagers == null) {
                    trustManagers = ((TrustManagerFactory)trustManagerFactory).getTrustManagers();
                    continue;
                }
                TrustManager[] newTrustManagers = ((TrustManagerFactory)trustManagerFactory).getTrustManagers();
                if (newTrustManagers == null || newTrustManagers.length <= 0) continue;
                TrustManager[] oldTrustManagers = trustManagers;
                trustManagers = new TrustManager[oldTrustManagers.length + newTrustManagers.length];
                System.arraycopy(oldTrustManagers, 0, trustManagers, 0, oldTrustManagers.length);
                System.arraycopy(newTrustManagers, 0, trustManagers, oldTrustManagers.length, newTrustManagers.length);
            }
            try {
                SecureRandom random = tlsRandom != null ? SecureRandom.getInstance(tlsRandom) : new SecureRandom();
                sslContext = tlsProvider != null ? SSLContext.getInstance(tlsProtocol, tlsProvider) : SSLContext.getInstance(tlsProtocol);
                sslContext.init(keyManagers, trustManagers, random);
            }
            catch (GeneralSecurityException cause) {
                throw new FormException((Throwable)cause);
            }
            ClientAuth clientAuth = (ClientAuth)((Object)ClientAuth.form().cast((Item)value.get("clientAuth")));
            if (clientAuth == null) {
                try {
                    clientAuth = ClientAuth.from(System.getProperty("swim.tls.client.auth"));
                }
                catch (IllegalArgumentException swallow) {
                    clientAuth = ClientAuth.NONE;
                }
            }
            if (value.containsKey("cipherSuites")) {
                cipherSuites = FingerTrieSeq.empty();
                for (Object cipherSuite : value.get("cipherSuites")) {
                    cipherSuites = cipherSuites.appended((Object)cipherSuite.stringValue());
                }
            } else {
                try {
                    cipherSuites = FingerTrieSeq.of((Object[])System.getProperty("swim.tls.ciphersuites").split(","));
                }
                catch (NullPointerException cause) {
                    cipherSuites = null;
                }
            }
            if (value.containsKey("protocols")) {
                protocols = FingerTrieSeq.empty();
                for (Item protocol : value.get("protocols")) {
                    protocols = protocols.appended((Object)protocol.stringValue());
                }
            } else {
                try {
                    protocols = FingerTrieSeq.of((Object[])System.getProperty("swim.tls.protocols").split(","));
                }
                catch (NullPointerException cause) {
                    protocols = null;
                }
            }
            return new TlsSettings(sslContext, clientAuth, (Collection<String>)cipherSuites, (Collection<String>)protocols);
        }
        return null;
    }

    private KeyManagerFactory castKeyManagerFactory(Value value) {
        Value header = value.getAttr("keyStore");
        if (header.isDefined()) {
            KeyManagerFactory keyManagerFactory;
            KeyStore keyStore;
            String type = header.get("type").stringValue(KeyStore.getDefaultType());
            String provider = header.get("provider").stringValue(null);
            try {
                if (provider != null) {
                    keyStore = KeyStore.getInstance(type, provider);
                    keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm(), provider);
                } else {
                    keyStore = KeyStore.getInstance(type);
                    keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                }
            }
            catch (GeneralSecurityException cause) {
                throw new FormException((Throwable)cause);
            }
            String path = value.get("path").stringValue(null);
            String resource = value.get("resource").stringValue(null);
            String password = value.get("password").stringValue(null);
            char[] passwordChars = password != null ? password.toCharArray() : null;
            InputStream inputStream = null;
            try {
                if (path != null) {
                    inputStream = new FileInputStream(path);
                } else if (resource != null && (inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource)) == null) {
                    throw new FormException("Missing keystore resource: " + resource);
                }
                keyStore.load(inputStream, passwordChars);
                keyManagerFactory.init(keyStore, passwordChars);
                KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
                return keyManagerFactory2;
            }
            catch (IOException | GeneralSecurityException cause) {
                throw new FormException((Throwable)cause);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException cause) {
                        throw new FormException((Throwable)cause);
                    }
                }
            }
        }
        return null;
    }

    private TrustManagerFactory castTrustManagerFactory(Value value) {
        Value header = value.getAttr("trustStore");
        if (header.isDefined()) {
            TrustManagerFactory trustManagerFactory;
            KeyStore trustStore;
            String type = header.get("type").stringValue(KeyStore.getDefaultType());
            String provider = header.get("provider").stringValue(null);
            try {
                if (provider != null) {
                    trustStore = KeyStore.getInstance(type, provider);
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), provider);
                } else {
                    trustStore = KeyStore.getInstance(type);
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                }
            }
            catch (GeneralSecurityException cause) {
                throw new FormException((Throwable)cause);
            }
            String path = value.get("path").stringValue(null);
            String resource = value.get("resource").stringValue(null);
            String password = value.get("password").stringValue(null);
            char[] passwordChars = password != null ? password.toCharArray() : null;
            InputStream inputStream = null;
            try {
                if (path != null) {
                    inputStream = new FileInputStream(path);
                } else if (resource != null && (inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource)) == null) {
                    throw new FormException("Missing truststore resource: " + resource);
                }
                trustStore.load(inputStream, passwordChars);
                trustManagerFactory.init(trustStore);
                TrustManagerFactory trustManagerFactory2 = trustManagerFactory;
                return trustManagerFactory2;
            }
            catch (IOException | GeneralSecurityException cause) {
                throw new FormException((Throwable)cause);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException cause) {
                        throw new FormException((Throwable)cause);
                    }
                }
            }
        }
        return null;
    }
}

