/*
 * Decompiled with CFR 0.152.
 */
package swim.args;

import swim.args.Arg;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.FingerTrieSeq;
import swim.util.Murmur3;

public class Opt
implements Cloneable,
Debug {
    final String name;
    char flag;
    String desc;
    FingerTrieSeq<Arg> args;
    int defs;
    private static int hashSeed;

    public Opt(String name, char flag, String desc, FingerTrieSeq<Arg> args, int defs) {
        this.name = name;
        this.flag = flag;
        this.desc = desc;
        this.args = args;
        this.defs = defs;
    }

    public String name() {
        return this.name;
    }

    public char flag() {
        return this.flag;
    }

    public Opt flag(char flag) {
        this.flag = flag;
        return this;
    }

    public String desc() {
        return this.desc;
    }

    public Opt desc(String desc) {
        this.desc = desc;
        return this;
    }

    public FingerTrieSeq<Arg> args() {
        return this.args;
    }

    public Opt arg(Arg arg) {
        this.args = this.args.appended((Object)arg);
        return this;
    }

    public Opt arg(String arg) {
        return this.arg(Arg.of(arg));
    }

    public int defs() {
        return this.defs;
    }

    public boolean isDefined() {
        return this.defs != 0;
    }

    public Arg getArg() {
        return this.getArg(0);
    }

    public Arg getArg(int index) {
        return (Arg)this.args.get(index);
    }

    public String getValue() {
        return this.getValue(0);
    }

    public String getValue(int index) {
        Arg arg = (Arg)this.args.get(index);
        return arg != null ? arg.value() : null;
    }

    public int parse(String[] params, int paramIndex) {
        int argCount = this.args.size();
        int paramCount = params.length;
        for (int argIndex = 0; argIndex < argCount && paramIndex < paramCount; ++paramIndex, ++argIndex) {
            Arg arg = (Arg)this.args.get(argIndex);
            String param = params[paramIndex];
            if (arg.optional && param.charAt(0) == '-') break;
            arg.value(param);
        }
        return paramIndex;
    }

    public boolean canEqual(Object other) {
        return other instanceof Opt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Opt) {
            Opt that = (Opt)other;
            return that.canEqual(this) && this.name.equals(that.name) && this.flag == that.flag && (this.desc == null ? that.desc == null : this.desc.equals(that.desc)) && this.args.equals(that.args) && this.defs == that.defs;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Opt.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)this.flag), (int)Murmur3.hash((Object)this.desc)), (int)this.args.hashCode()), (int)this.defs));
    }

    public void debug(Output<?> output) {
        output = output.write("Opt").write(46).write("of").write(40).debug((Object)this.name).write(41);
        if (this.flag != '\u0000') {
            output = output.write(46).write("flag").write(40).debug((Object)Character.valueOf(this.flag)).write(41);
        }
        if (this.desc != null) {
            output = output.write(46).write("desc").write(40).debug((Object)this.desc).write(41);
        }
        int argCount = this.args.size();
        for (int argIndex = 0; argIndex < argCount; ++argIndex) {
            Arg arg = (Arg)this.args.get(argIndex);
            output = output.write(46).write("arg").write(40).debug((Object)arg).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public Opt clone() {
        int argCount = this.args.size();
        FingerTrieSeq args = FingerTrieSeq.empty();
        for (int i = 0; i < argCount; ++i) {
            args = args.appended((Object)((Arg)this.args.get(i)).clone());
        }
        return new Opt(this.name, this.flag, this.desc, (FingerTrieSeq<Arg>)args, this.defs);
    }

    public static Opt of(String name, char flag) {
        return new Opt(name, flag, null, (FingerTrieSeq<Arg>)FingerTrieSeq.empty(), 0);
    }

    public static Opt of(String name) {
        return new Opt(name, '\u0000', null, (FingerTrieSeq<Arg>)FingerTrieSeq.empty(), 0);
    }
}

