/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.PointR2;
import swim.math.PointZ2Form;
import swim.math.VectorZ2;
import swim.math.Z2Form;
import swim.math.Z2Shape;
import swim.math.Z2ToR2Function;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class PointZ2
extends Z2Shape
implements Debug {
    public final long x;
    public final long y;
    private static int hashSeed;
    private static PointZ2 origin;
    private static Z2Form<PointZ2> form;

    public PointZ2(long x, long y) {
        this.x = x;
        this.y = y;
    }

    public final PointZ2 plus(VectorZ2 vector) {
        return new PointZ2(this.x + vector.x, this.y + vector.y);
    }

    public final PointZ2 minux(VectorZ2 vector) {
        return new PointZ2(this.x - vector.x, this.y - vector.y);
    }

    public final VectorZ2 minus(PointZ2 that) {
        return new VectorZ2(this.x - that.x, this.y - that.y);
    }

    @Override
    public final long xMin() {
        return this.x;
    }

    @Override
    public final long yMin() {
        return this.y;
    }

    @Override
    public final long xMax() {
        return this.x;
    }

    @Override
    public final long yMax() {
        return this.y;
    }

    @Override
    public boolean contains(Z2Shape shape) {
        return this.x <= shape.xMin() && shape.xMax() <= this.x && this.y <= shape.yMin() && shape.yMax() <= this.y;
    }

    @Override
    public boolean intersects(Z2Shape shape) {
        return shape.intersects(this);
    }

    @Override
    public PointR2 transform(Z2ToR2Function f) {
        return new PointR2(f.transformX(this.x, this.y), f.transformY(this.x, this.y));
    }

    @Override
    public Value toValue() {
        return PointZ2.form().mold(this).toValue();
    }

    protected boolean canEqual(PointZ2 that) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PointZ2) {
            PointZ2 that = (PointZ2)other;
            return that.canEqual(this) && this.x == that.x && this.y == that.y;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(PointZ2.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((long)this.x)), (int)Murmur3.hash((long)this.y)));
    }

    public void debug(Output<?> output) {
        output.write("PointZ2").write(46).write("of").write(40).debug((Object)this.x).write(", ").debug((Object)this.y).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static PointZ2 origin() {
        if (origin == null) {
            origin = new PointZ2(0L, 0L);
        }
        return origin;
    }

    public static PointZ2 of(long x, long y) {
        return new PointZ2(x, y);
    }

    @Kind
    public static Z2Form<PointZ2> form() {
        if (form == null) {
            form = new PointZ2Form();
        }
        return form;
    }
}

