/*
 * Decompiled with CFR 0.152.
 */
package swim.decipher;

import swim.codec.Decoder;
import swim.codec.Parser;
import swim.decipher.DecipherDecoder;
import swim.decipher.DecipherModelDecoder;
import swim.decipher.DecipherModelParser;
import swim.decipher.DecipherParser;
import swim.structure.Item;
import swim.structure.Value;

public final class Decipher {
    private static DecipherDecoder<Item, Value> modelDecoder;
    private static DecipherParser<Item, Value> modelParser;

    private Decipher() {
    }

    static boolean isSpace(int c) {
        return c == 32 || c == 9;
    }

    static boolean isNewline(int c) {
        return c == 10 || c == 13;
    }

    static boolean isWhitespace(int c) {
        return Decipher.isSpace(c) || Decipher.isNewline(c);
    }

    public static DecipherDecoder<Item, Value> modelDecoder() {
        if (modelDecoder == null) {
            modelDecoder = new DecipherModelDecoder();
        }
        return modelDecoder;
    }

    public static DecipherParser<Item, Value> modelParser() {
        if (modelParser == null) {
            modelParser = new DecipherModelParser();
        }
        return modelParser;
    }

    public static Value parse(String any) {
        return Decipher.modelParser().parseAnyString(any);
    }

    public static Parser<Value> parser() {
        return Decipher.modelParser().anyParser();
    }

    public static Decoder<Value> decoder() {
        return Decipher.modelDecoder().anyDecoder();
    }
}

