/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import java.nio.ByteBuffer;
import swim.codec.Binary;
import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.structure.Data;
import swim.util.Murmur3;
import swim.ws.WsData;
import swim.ws.WsEncoder;
import swim.ws.WsOpcode;

public final class WsBinary<T>
extends WsData<T>
implements Debug {
    final T value;
    final Encoder<?, ?> content;
    private static int hashSeed;

    WsBinary(T value, Encoder<?, ?> content) {
        this.value = value;
        this.content = content;
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public WsOpcode opcode() {
        return WsOpcode.BINARY;
    }

    @Override
    public Object payload() {
        return this.value;
    }

    @Override
    public Encoder<?, ?> contentEncoder(WsEncoder ws) {
        return this.content;
    }

    @Override
    public Encoder<?, ?> encodeContent(OutputBuffer<?> output, WsEncoder ws) {
        return this.content.pull(output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WsBinary) {
            WsBinary that = (WsBinary)other;
            return this.value == null ? that.value == null : this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WsBinary.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.value)));
    }

    public void debug(Output<?> output) {
        output = output.write("WsBinary").write(46).write("from").write(40);
        if (this.value != null) {
            output = output.debug(this.value).write(", ");
        }
        output = output.debug(this.content).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> WsBinary<T> from(T value, Encoder<?, ?> content) {
        return new WsBinary<T>(value, content);
    }

    public static <T> WsBinary<T> from(Encoder<?, ?> content) {
        return new WsBinary<Object>(null, content);
    }

    public static WsBinary<ByteBuffer> from(ByteBuffer payload) {
        return new WsBinary<ByteBuffer>(payload.duplicate(), (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)payload));
    }

    public static WsBinary<Data> from(Data payload) {
        return new WsBinary<Data>(payload, (Encoder<?, ?>)payload.writer());
    }
}

