/*
 * Decompiled with CFR 0.152.
 */
package swim.api.server;

import swim.api.SwimContext;
import swim.api.plane.Plane;
import swim.api.router.Router;
import swim.api.server.Server;
import swim.api.server.ServerContext;
import swim.util.Log;

public abstract class AbstractServer
implements Server,
Log {
    protected final ServerContext context;

    public AbstractServer(ServerContext context) {
        this.context = context;
    }

    public AbstractServer() {
        this(SwimContext.getServerContext());
    }

    @Override
    public ServerContext serverContext() {
        return this.context;
    }

    @Override
    public void willAddPlane(String name, Plane plane) {
    }

    @Override
    public void didAddPlane(String name, Plane plane) {
    }

    @Override
    public void willRemovePlane(String name, Plane plane) {
    }

    @Override
    public void didRemovePlane(String name, Plane plane) {
    }

    @Override
    public void willStart() {
    }

    @Override
    public void didStart() {
    }

    @Override
    public void willStop() {
    }

    @Override
    public void didStop() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    public final Router router() {
        return this.context.router();
    }

    public final Plane getPlane(String name) {
        return this.context.getPlane(name);
    }

    public void start() {
        this.context.start();
    }

    public void stop() {
        this.context.stop();
    }

    public void run() {
        this.context.run();
    }

    public void trace(Object message) {
        this.context.trace(message);
    }

    public void debug(Object message) {
        this.context.debug(message);
    }

    public void info(Object message) {
        this.context.info(message);
    }

    public void warn(Object message) {
        this.context.warn(message);
    }

    public void error(Object message) {
        this.context.error(message);
    }
}

