/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.OutputBuffer;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieSet;
import swim.decipher.Decipher;
import swim.http.Http;
import swim.http.HttpBody;
import swim.http.HttpChunked;
import swim.http.HttpEntity;
import swim.http.HttpException;
import swim.http.HttpHeader;
import swim.http.HttpMessageEncoder;
import swim.http.HttpPart;
import swim.http.HttpVersion;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.http.TransferCoding;
import swim.http.header.ContentLength;
import swim.http.header.ContentType;
import swim.http.header.TransferEncoding;
import swim.json.Json;
import swim.recon.Recon;
import swim.util.Builder;
import swim.xml.Xml;

public abstract class HttpMessage<T>
extends HttpPart {
    public abstract HttpVersion version();

    public abstract FingerTrieSeq<HttpHeader> headers();

    public HttpHeader getHeader(String name) {
        FingerTrieSeq<HttpHeader> headers = this.headers();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            HttpHeader header = (HttpHeader)headers.get(i);
            if (!name.equalsIgnoreCase(header.name())) continue;
            return header;
        }
        return null;
    }

    public <H extends HttpHeader> H getHeader(Class<H> headerClass) {
        FingerTrieSeq<HttpHeader> headers = this.headers();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            HttpHeader header = (HttpHeader)headers.get(i);
            if (!headerClass.isInstance(header)) continue;
            return (H)header;
        }
        return null;
    }

    public abstract HttpMessage<T> headers(FingerTrieSeq<HttpHeader> var1);

    public abstract HttpMessage<T> headers(HttpHeader ... var1);

    public abstract HttpMessage<T> appendedHeaders(FingerTrieSeq<HttpHeader> var1);

    public abstract HttpMessage<T> appendedHeaders(HttpHeader ... var1);

    public abstract HttpMessage<T> appendedHeader(HttpHeader var1);

    public abstract HttpMessage<T> updatedHeaders(FingerTrieSeq<HttpHeader> var1);

    public abstract HttpMessage<T> updatedHeaders(HttpHeader ... var1);

    public abstract HttpMessage<T> updatedHeader(HttpHeader var1);

    public abstract HttpEntity<T> entity();

    public abstract <T2> HttpMessage<T2> entity(HttpEntity<T2> var1);

    public abstract <T2> HttpMessage<T2> content(HttpEntity<T2> var1);

    public abstract HttpMessage<String> body(String var1, MediaType var2);

    public abstract HttpMessage<String> body(String var1);

    public <T2> Decoder<? extends HttpMessage<T2>> entityDecoder(Decoder<T2> contentDecoder) {
        int bodyType = 0;
        long length = 0L;
        FingerTrieSeq<HttpHeader> headers = this.headers();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            HttpHeader header = (HttpHeader)headers.get(i);
            if (header instanceof ContentLength) {
                if (bodyType == 0) {
                    length = ((ContentLength)header).length();
                    bodyType = 1;
                    continue;
                }
                if (bodyType == 1) {
                    return Decoder.error((Throwable)new HttpException("conflicting Content-Length"));
                }
                if (bodyType != 2) continue;
                return Decoder.error((Throwable)new HttpException("conflicting Content-Length and chunked Transfer-Encoding"));
            }
            if (!(header instanceof TransferEncoding)) continue;
            FingerTrieSeq<TransferCoding> codings = ((TransferEncoding)header).codings();
            int k = codings.size();
            for (int j = 0; j < k; ++j) {
                TransferCoding coding = (TransferCoding)codings.get(j);
                if (coding.isChunked()) {
                    if (bodyType == 0) {
                        bodyType = 2;
                        continue;
                    }
                    if (bodyType == 1) {
                        return Decoder.error((Throwable)new HttpException("conflicting Content-Length and chunked Transfer-Encoding"));
                    }
                    if (bodyType != 2) continue;
                    return Decoder.error((Throwable)new HttpException("conflicting Transfer-Encoding"));
                }
                return Decoder.error((Throwable)new HttpException("unsupported Transfer-Encoding: " + coding.toHttp()));
            }
        }
        if (bodyType == 1 && length > 0L) {
            return HttpBody.httpDecoder(this, contentDecoder, length);
        }
        if (bodyType == 2) {
            return HttpChunked.httpDecoder(this, contentDecoder);
        }
        return Decoder.done(this.entity(HttpEntity.empty()));
    }

    public Decoder<Object> contentDecoder(MediaType mediaType) {
        if (mediaType.isText()) {
            return Utf8.stringParser();
        }
        if (mediaType.isApplication()) {
            if ("json".equalsIgnoreCase(mediaType.subtype)) {
                return Utf8.decodedParser((Parser)Json.modelParser().valueParser());
            }
            if ("recon".equalsIgnoreCase(mediaType.subtype) || "x-recon".equalsIgnoreCase(mediaType.subtype)) {
                return Utf8.decodedParser((Parser)Recon.modelParser().blockParser());
            }
            if ("xml".equalsIgnoreCase(mediaType.subtype)) {
                return Utf8.decodedParser((Parser)Xml.modelParser().documentParser());
            }
        }
        return Decipher.modelDecoder().anyDecoder();
    }

    public Decoder<Object> contentDecoder() {
        FingerTrieSeq<HttpHeader> headers = this.headers();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            HttpHeader header = (HttpHeader)headers.get(i);
            if (!(header instanceof ContentType)) continue;
            return this.contentDecoder(((ContentType)header).mediaType());
        }
        return this.contentDecoder(MediaType.applicationOctetStream());
    }

    public Encoder<?, ? extends HttpMessage<T>> httpEncoder(HttpWriter http) {
        return new HttpMessageEncoder(http, this);
    }

    public Encoder<?, ? extends HttpMessage<T>> httpEncoder() {
        return this.httpEncoder(Http.standardWriter());
    }

    public Encoder<?, ? extends HttpMessage<T>> encodeHttp(OutputBuffer<?> output, HttpWriter http) {
        return HttpMessageEncoder.encode(output, http, this);
    }

    public Encoder<?, ? extends HttpMessage<T>> encodeHttp(OutputBuffer<?> output) {
        return this.encodeHttp(output, Http.standardWriter());
    }

    static FingerTrieSeq<HttpHeader> updatedHeaders(FingerTrieSeq<HttpHeader> oldHeaders, HttpHeader newHeader) {
        Builder headers = FingerTrieSeq.builder();
        boolean updated = false;
        boolean changed = false;
        int n = oldHeaders.size();
        for (int i = 0; i < n; ++i) {
            HttpHeader oldHeader = (HttpHeader)oldHeaders.get(i);
            if (oldHeader.lowerCaseName().equals(newHeader.lowerCaseName())) {
                updated = true;
                if (!oldHeader.equals(newHeader)) {
                    changed = true;
                }
                headers.add((Object)newHeader);
                continue;
            }
            headers.add((Object)oldHeader);
        }
        if (!updated) {
            headers.add((Object)newHeader);
            changed = true;
        }
        if (changed) {
            return (FingerTrieSeq)headers.bind();
        }
        return oldHeaders;
    }

    static FingerTrieSeq<HttpHeader> updatedHeaders(FingerTrieSeq<HttpHeader> oldHeaders, FingerTrieSeq<HttpHeader> newHeaders) {
        int newHeaderCount = newHeaders.size();
        if (newHeaderCount == 0) {
            return oldHeaders;
        }
        if (newHeaderCount == 1) {
            return HttpMessage.updatedHeaders(oldHeaders, (HttpHeader)newHeaders.head());
        }
        Builder headers = FingerTrieSeq.builder();
        HashTrieSet absent = HashTrieSet.from(newHeaders);
        boolean changed = false;
        int oldHeaderCount = oldHeaders.size();
        block0: for (int i = 0; i < oldHeaderCount; ++i) {
            HttpHeader oldHeader = (HttpHeader)oldHeaders.get(i);
            for (int j = 0; j < newHeaderCount; ++j) {
                HttpHeader newHeader = (HttpHeader)newHeaders.get(j);
                if (!oldHeader.lowerCaseName().equals(newHeader.lowerCaseName())) continue;
                absent.remove((Object)newHeader);
                if (!oldHeader.equals(newHeader)) {
                    changed = true;
                }
                headers.add((Object)newHeader);
                continue block0;
            }
            headers.add((Object)oldHeader);
        }
        if (!absent.isEmpty()) {
            for (int j = 0; j < newHeaderCount; ++j) {
                HttpHeader newHeader = (HttpHeader)newHeaders.get(j);
                if (!absent.contains((Object)newHeader)) continue;
                headers.add((Object)newHeader);
                changed = true;
            }
        }
        if (changed) {
            return (FingerTrieSeq)headers.bind();
        }
        return oldHeaders;
    }
}

