/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import swim.structure.Field;
import swim.structure.Form;
import swim.structure.FormException;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.structure.form.FieldForm;

public final class SlotForm<T>
extends FieldForm<T> {
    final java.lang.reflect.Field field;
    final Value key;
    final Form<?> form;

    public SlotForm(java.lang.reflect.Field field, Value key, Form<?> form) {
        this.field = field;
        this.key = key.commit();
        this.form = form;
    }

    @Override
    public java.lang.reflect.Field field() {
        return this.field;
    }

    @Override
    public Value key() {
        return this.key;
    }

    @Override
    public Class<?> type() {
        return this.field.getDeclaringClass();
    }

    @Override
    public Item mold(T object, Item item) {
        if (object != null) {
            try {
                Value value = this.form.mold(this.field.get(object)).toValue();
                if (item instanceof Field) {
                    return ((Field)item).updatedValue(value);
                }
                return item.updatedSlot(this.key, value);
            }
            catch (IllegalAccessException cause) {
                return Item.absent();
            }
        }
        return Item.extant();
    }

    @Override
    public Item mold(T object) {
        if (object != null) {
            try {
                Value value = this.form.mold(this.field.get(object)).toValue();
                return Slot.of(this.key, value);
            }
            catch (IllegalAccessException cause) {
                return Item.absent();
            }
        }
        return Item.extant();
    }

    @Override
    public T cast(Item item, T object) {
        try {
            if (item instanceof Record) {
                Value value = item.get(this.key);
                if (value.isDefined()) {
                    this.field.set(object, this.form.cast(value));
                }
            } else if (item.keyEquals(this.key)) {
                this.field.set(object, this.form.cast(item.toValue()));
            }
        }
        catch (IllegalAccessException cause) {
            throw new FormException(cause);
        }
        return object;
    }
}

