/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.concurrent.Stage;
import swim.concurrent.Task;
import swim.concurrent.TaskContext;
import swim.concurrent.TaskFunction;
import swim.concurrent.Theater;

class TheaterTask
implements TaskContext,
Runnable,
ForkJoinPool.ManagedBlocker {
    final Theater theater;
    final TaskFunction task;
    volatile int status;
    static final int CUED = 1;
    static final int RUNNING = 2;
    static final AtomicIntegerFieldUpdater<TheaterTask> STATUS = AtomicIntegerFieldUpdater.newUpdater(TheaterTask.class, "status");

    TheaterTask(Theater theater, TaskFunction task) {
        this.theater = theater;
        this.task = task;
    }

    @Override
    public Stage stage() {
        return this.theater;
    }

    @Override
    public boolean isCued() {
        return (this.status & 1) != 0;
    }

    @Override
    public boolean isReleasable() {
        return (this.status & 2) == 0;
    }

    @Override
    public boolean cue() {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus, newStatus = ((oldStatus = this.status) & 1) == 0 ? oldStatus | 1 : oldStatus)) {
        }
        if (oldStatus != newStatus && (newStatus & 2) == 0) {
            this.theater.taskWillCue(this.task);
            if (this.task instanceof Task) {
                ((Task)this.task).taskWillCue();
            }
            this.theater.execute(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean cancel() {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus = this.status, newStatus = oldStatus & 0xFFFFFFFE)) {
        }
        if (oldStatus != newStatus && (newStatus & 2) == 0) {
            if (this.task instanceof Task) {
                ((Task)this.task).taskDidCancel();
            }
            this.theater.taskDidCancel(this.task);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus = this.status, newStatus = (oldStatus | 2) & 0xFFFFFFFE)) {
        }
        if ((oldStatus & 1) != 0) {
            this.theater.taskWillRun(this.task);
            try {
                if (this.task instanceof Task && ((Task)this.task).taskWillBlock()) {
                    ForkJoinPool.managedBlock(this);
                } else {
                    this.task.runTask();
                }
                this.theater.taskDidRun(this.task);
            }
            catch (Throwable error) {
                this.theater.taskDidFail(this.task, error);
            }
        }
        while (!STATUS.compareAndSet(this, oldStatus = this.status, newStatus = oldStatus & 0xFFFFFFFD)) {
        }
        if ((newStatus & 1) != 0) {
            this.theater.taskWillCue(this.task);
            if (this.task instanceof Task) {
                ((Task)this.task).taskWillCue();
            }
            this.theater.execute(this);
        }
    }

    @Override
    public boolean block() {
        this.task.runTask();
        return true;
    }
}

