/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;

final class SizedDecoder<V>
extends Decoder<V> {
    final Decoder<V> payloadDecoder;
    final long length;
    final int lengthShift;
    final int step;

    SizedDecoder(Decoder<V> payloadDecoder, long length, int lengthShift, int step) {
        this.payloadDecoder = payloadDecoder;
        this.length = length;
        this.lengthShift = lengthShift;
        this.step = step;
    }

    public Decoder<V> feed(InputBuffer input) {
        return SizedDecoder.decode(input, this.payloadDecoder, this.length, this.lengthShift, this.step);
    }

    static <V> Decoder<V> decode(InputBuffer input, Decoder<V> payloadDecoder, long length, int lengthShift, int step) {
        if (step == 1) {
            while (input.isCont()) {
                int b = input.head();
                if (lengthShift < 64) {
                    input = input.step();
                    length |= (long)(b & 0x7F) << lengthShift;
                } else {
                    return SizedDecoder.error((Throwable)new DecoderException("varint overflow"));
                }
                if ((b & 0x80) == 0) {
                    step = 2;
                    break;
                }
                lengthShift += 7;
            }
        }
        if (step == 2) {
            int inputStart = input.index();
            int inputLimit = input.limit();
            int inputRemaining = inputLimit - inputStart;
            boolean inputPart = input.isPart();
            if (length < (long)inputRemaining) {
                input.limit(inputStart + (int)length);
            }
            if (length <= (long)inputRemaining) {
                input = input.isPart(false);
            }
            payloadDecoder = payloadDecoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            length -= (long)(input.index() - inputStart);
            if (payloadDecoder.isDone()) {
                if (length == 0L) {
                    return payloadDecoder;
                }
                return SizedDecoder.error((Throwable)new DecoderException("unconsumed input"));
            }
            if (payloadDecoder.isError()) {
                return payloadDecoder.asError();
            }
        }
        if (input.isDone()) {
            return SizedDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return SizedDecoder.error((Throwable)input.trap());
        }
        return new SizedDecoder<V>(payloadDecoder, length, lengthShift, step);
    }

    static <V> Decoder<V> decode(InputBuffer input, Decoder<V> payloadDecoder) {
        return SizedDecoder.decode(input, payloadDecoder, 0L, 0, 1);
    }
}

