/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import java.util.Iterator;
import swim.api.agent.AgentContext;
import swim.api.auth.Identity;
import swim.api.data.DataFactory;
import swim.api.downlink.Downlink;
import swim.api.lane.Lane;
import swim.api.policy.Policy;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.math.Z2Form;
import swim.runtime.HttpBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.runtime.PushRequest;
import swim.runtime.TierContext;
import swim.store.DataBinding;
import swim.store.ListDataBinding;
import swim.store.MapDataBinding;
import swim.store.SpatialDataBinding;
import swim.store.ValueDataBinding;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;

public class LaneProxy
implements LaneBinding,
LaneContext {
    protected final LaneBinding laneBinding;
    protected LaneContext laneContext;

    public LaneProxy(LaneBinding laneBinding) {
        this.laneBinding = laneBinding;
    }

    public final LaneBinding laneBinding() {
        return this.laneBinding;
    }

    @Override
    public final LaneContext laneContext() {
        return this.laneContext;
    }

    @Override
    public void setLaneContext(LaneContext laneContext) {
        this.laneContext = laneContext;
        this.laneBinding.setLaneContext(this);
    }

    @Override
    public final TierContext tierContext() {
        return this;
    }

    @Override
    public <T> T unwrapLane(Class<T> laneClass) {
        if (laneClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.laneBinding.unwrapLane(laneClass);
    }

    @Override
    public Uri meshUri() {
        return this.laneContext.meshUri();
    }

    @Override
    public Value partKey() {
        return this.laneContext.partKey();
    }

    @Override
    public Uri hostUri() {
        return this.laneContext.hostUri();
    }

    @Override
    public Uri nodeUri() {
        return this.laneContext.nodeUri();
    }

    @Override
    public Uri laneUri() {
        return this.laneContext.laneUri();
    }

    @Override
    public Value agentKey() {
        return this.laneContext.agentKey();
    }

    @Override
    public Identity identity() {
        return this.laneContext.identity();
    }

    @Override
    public Policy policy() {
        return this.laneContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.laneContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.laneContext.stage();
    }

    @Override
    public DataFactory data() {
        return this.laneContext.data();
    }

    @Override
    public Lane getLaneView(AgentContext agentContext) {
        return this.laneBinding.getLaneView(agentContext);
    }

    @Override
    public void openLaneView(Lane lane) {
        this.laneBinding.openLaneView(lane);
    }

    @Override
    public void closeLaneView(Lane lane) {
        this.laneBinding.closeLaneView(lane);
    }

    @Override
    public FingerTrieSeq<LinkContext> getUplinks() {
        return this.laneBinding.getUplinks();
    }

    @Override
    public LinkBinding getUplink(Value linkKey) {
        return this.laneBinding.getUplink(linkKey);
    }

    @Override
    public void closeUplink(Value linkKey) {
        this.laneBinding.closeUplink(linkKey);
    }

    @Override
    public void pushUpCommand(CommandMessage message) {
        this.laneBinding.pushUpCommand(message);
    }

    public Iterator<DataBinding> dataBindings() {
        return this.laneBinding.dataBindings();
    }

    public void closeData(Value name) {
        this.laneBinding.closeData(name);
    }

    public ListDataBinding openListData(Value name) {
        return this.laneContext.openListData(name);
    }

    public ListDataBinding injectListData(ListDataBinding dataBinding) {
        return this.laneContext.injectListData(dataBinding);
    }

    public MapDataBinding openMapData(Value name) {
        return this.laneContext.openMapData(name);
    }

    public MapDataBinding injectMapData(MapDataBinding dataBinding) {
        return this.laneContext.injectMapData(dataBinding);
    }

    public <S> SpatialDataBinding<S> openSpatialData(Value name, Z2Form<S> shapeForm) {
        return this.laneContext.openSpatialData(name, shapeForm);
    }

    public <S> SpatialDataBinding<S> injectSpatialData(SpatialDataBinding<S> dataBinding) {
        return this.laneContext.injectSpatialData(dataBinding);
    }

    public ValueDataBinding openValueData(Value name) {
        return this.laneContext.openValueData(name);
    }

    public ValueDataBinding injectValueData(ValueDataBinding dataBinding) {
        return this.laneContext.injectValueData(dataBinding);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.laneContext.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.laneContext.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
        this.laneContext.closeDownlink(link);
    }

    @Override
    public void httpDownlink(HttpBinding http) {
        this.laneContext.httpDownlink(http);
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.laneContext.pushDown(pushRequest);
    }

    @Override
    public void openUplink(LinkBinding link) {
        this.laneBinding.openUplink(link);
    }

    @Override
    public void httpUplink(HttpBinding http) {
        this.laneBinding.httpUplink(http);
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        this.laneBinding.pushUp(pushRequest);
    }

    public void trace(Object message) {
        this.laneContext.trace(message);
    }

    public void debug(Object message) {
        this.laneContext.debug(message);
    }

    public void info(Object message) {
        this.laneContext.info(message);
    }

    public void warn(Object message) {
        this.laneContext.warn(message);
    }

    public void error(Object message) {
        this.laneContext.error(message);
    }

    @Override
    public boolean isClosed() {
        return this.laneBinding.isClosed();
    }

    @Override
    public boolean isOpened() {
        return this.laneBinding.isOpened();
    }

    @Override
    public boolean isLoaded() {
        return this.laneBinding.isLoaded();
    }

    @Override
    public boolean isStarted() {
        return this.laneBinding.isStarted();
    }

    @Override
    public void open() {
        this.laneBinding.open();
    }

    @Override
    public void load() {
        this.laneBinding.load();
    }

    @Override
    public void start() {
        this.laneBinding.start();
    }

    @Override
    public void stop() {
        this.laneBinding.stop();
    }

    @Override
    public void unload() {
        this.laneBinding.unload();
    }

    @Override
    public void close() {
        this.laneBinding.close();
    }

    @Override
    public void willOpen() {
        this.laneContext.willOpen();
    }

    @Override
    public void didOpen() {
        this.laneContext.didOpen();
    }

    @Override
    public void willLoad() {
        this.laneContext.willLoad();
    }

    @Override
    public void didLoad() {
        this.laneContext.didLoad();
    }

    @Override
    public void willStart() {
        this.laneContext.willStart();
    }

    @Override
    public void didStart() {
        this.laneContext.didStart();
    }

    @Override
    public void willStop() {
        this.laneContext.willStop();
    }

    @Override
    public void didStop() {
        this.laneContext.didStop();
    }

    @Override
    public void willUnload() {
        this.laneContext.willUnload();
    }

    @Override
    public void didUnload() {
        this.laneContext.didUnload();
    }

    @Override
    public void willClose() {
        this.laneContext.willClose();
    }

    @Override
    public void didClose() {
        this.laneBinding.didClose();
    }

    @Override
    public void didFail(Throwable error) {
        this.laneBinding.didFail(error);
    }
}

