/*
 * Decompiled with CFR 0.152.
 */
package swim.dataflow.operator;

import swim.streamlet.AbstractOutlet;
import swim.streamlet.Inlet;
import swim.streamlet.Outlet;
import swim.streamlet.OutletInlet;
import swim.structure.Func;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public final class InvokeOutlet
extends AbstractOutlet<Value> {
    final Record scope;
    final Inlet<Value> funcInlet;
    final Inlet<Value> argsInlet;

    public InvokeOutlet(Record scope) {
        this.scope = scope;
        this.funcInlet = new OutletInlet((Outlet)this);
        this.argsInlet = new OutletInlet((Outlet)this);
    }

    public Inlet<Value> funcInlet() {
        return this.funcInlet;
    }

    public Inlet<Value> argsInlet() {
        return this.argsInlet;
    }

    public Value get() {
        Value args;
        Value func;
        Outlet funcInput = this.funcInlet.input();
        Outlet argsInput = this.argsInlet.input();
        if (funcInput != null && argsInput != null && (func = (Value)this.funcInlet.input().get()) instanceof Func && (args = (Value)this.argsInlet.input().get()) != null) {
            Interpreter interpreter = new Interpreter();
            interpreter.pushScope((Item)this.scope);
            Item result = ((Func)func).invoke(args, interpreter, null);
            return result.toValue();
        }
        return Value.absent();
    }
}

