/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import swim.structure.Form;
import swim.structure.Record;
import swim.structure.Value;
import swim.structure.collections.ValueIterable;

public class ValueCollection<T>
extends ValueIterable<T>
implements Collection<T> {
    public ValueCollection(Collection<? extends Value> inner, Form<T> valueForm) {
        super(inner, valueForm);
    }

    public Collection<Value> inner() {
        return (Collection)this.inner;
    }

    @Override
    public <T2> ValueCollection<T2> valueForm(Form<T2> valueForm) {
        return new ValueCollection<T2>((Collection)this.inner, valueForm);
    }

    @Override
    public <T2> ValueCollection<T2> valueClass(Class<T2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    @Override
    public boolean isEmpty() {
        return ((Collection)this.inner).isEmpty();
    }

    @Override
    public int size() {
        return ((Collection)this.inner).size();
    }

    @Override
    public boolean contains(Object object) {
        Class<?> valueType = this.valueForm.type();
        if (valueType == null || valueType.isInstance(object)) {
            Value value = this.valueForm.mold(object).toValue();
            return ((Collection)this.inner).contains(value);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        Iterator<?> those = objects.iterator();
        while (those.hasNext()) {
            if (this.contains(those.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(T newObject) {
        Value newValue = this.valueForm.mold(newObject).toValue();
        return ((Collection)this.inner).add(newValue);
    }

    @Override
    public boolean addAll(Collection<? extends T> newObjects) {
        if (this.valueForm != Form.forValue()) {
            Iterator<T> those = newObjects.iterator();
            Class<?> valueType = this.valueForm.type();
            Record values = Record.create(newObjects.size());
            while (those.hasNext()) {
                T newObject = those.next();
                if (valueType != null && !valueType.isInstance(newObject)) continue;
                Value newValue = this.valueForm.mold(newObject).toValue();
                values.add(newValue);
            }
            return ((Collection)this.inner).addAll(values);
        }
        return ((Collection)this.inner).addAll(newObjects);
    }

    @Override
    public boolean remove(Object object) {
        Class<?> valueType = this.valueForm.type();
        if (valueType == null || valueType.isInstance(object)) {
            Value value = this.valueForm.mold(object).toValue();
            return ((Collection)this.inner).remove(value);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        if (this.valueForm != Form.forValue()) {
            Class<?> valueType = this.valueForm.type();
            Iterator<?> those = objects.iterator();
            boolean modified = false;
            while (those.hasNext()) {
                Value value;
                Object object = those.next();
                if (valueType != null && !valueType.isInstance(object) || !((Collection)this.inner).remove(value = this.valueForm.mold(object).toValue())) continue;
                modified = true;
            }
            return modified;
        }
        return ((Collection)this.inner).removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        if (this.valueForm != Form.forValue()) {
            Iterator<?> those = objects.iterator();
            Class<?> valueType = this.valueForm.type();
            Record values = Record.create(objects.size());
            while (those.hasNext()) {
                Object object = those.next();
                if (valueType != null && !valueType.isInstance(object)) continue;
                Value value = this.valueForm.mold(object).toValue();
                values.add(value);
            }
            return ((Collection)this.inner).retainAll(values);
        }
        return ((Collection)this.inner).retainAll(objects);
    }

    @Override
    public void clear() {
        ((Collection)this.inner).clear();
    }

    @Override
    public Object[] toArray() {
        Iterator these = ((Collection)this.inner).iterator();
        int i = 0;
        int n = ((Collection)this.inner).size();
        Object[] array = new Object[n];
        while (these.hasNext()) {
            Value value = (Value)these.next();
            Object object = this.valueForm.cast(value);
            if (object == null) {
                object = this.valueForm.unit();
            }
            if (i == n) {
                if ((n = n + (n >> 1) + 1) < 0) {
                    n = Integer.MAX_VALUE;
                }
                Object[] newArray = new Object[n];
                System.arraycopy(array, 0, newArray, 0, i);
                array = newArray;
            }
            array[i] = object;
            ++i;
        }
        if (i < n) {
            Object[] newArray = new Object[i];
            System.arraycopy(array, 0, newArray, 0, i);
            array = newArray;
        }
        return array;
    }

    @Override
    public <T2> T2[] toArray(T2[] a) {
        Iterator these = ((Collection)this.inner).iterator();
        int i = 0;
        int n = a.length;
        Object[] array = a;
        while (these.hasNext()) {
            Value value = (Value)these.next();
            Object object = this.valueForm.cast(value);
            if (object == null) {
                object = this.valueForm.unit();
            }
            if (i == n) {
                if ((n = n + (n >> 1) + 1) < 0) {
                    n = Integer.MAX_VALUE;
                }
                Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), n);
                System.arraycopy(array, 0, newArray, 0, i);
                array = newArray;
            }
            array[i] = object;
            ++i;
        }
        if (i < n) {
            if (array == a) {
                array[i] = null;
            } else {
                Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), i);
                System.arraycopy(array, 0, newArray, 0, i);
                array = newArray;
            }
        }
        return array;
    }

    public String toString() {
        Iterator these = this.iterator();
        if (!these.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            sb.append(these.next());
            if (!these.hasNext()) break;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }
}

