/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import swim.structure.Form;
import swim.structure.Value;
import swim.structure.collections.ValueCollection;
import swim.structure.collections.ValueMapEntrySet;
import swim.structure.collections.ValueSet;

public class ValueMap<K, V>
implements Map<K, V> {
    protected Map<Value, Value> inner;
    protected Form<K> keyForm;
    protected Form<V> valueForm;

    public ValueMap(Map<? extends Value, ? extends Value> inner, Form<K> keyForm, Form<V> valueForm) {
        this.inner = inner;
        this.keyForm = keyForm;
        this.valueForm = valueForm;
    }

    public Map<Value, Value> inner() {
        return this.inner;
    }

    public Form<K> keyForm() {
        return this.keyForm;
    }

    public <K2> ValueMap<K2, V> keyForm(Form<K2> keyForm) {
        return new ValueMap<K2, V>(this.inner, keyForm, this.valueForm);
    }

    public <K2> ValueMap<K2, V> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> ValueMap<K, V2> valueForm(Form<V2> valueForm) {
        return new ValueMap<K, V2>(this.inner, this.keyForm, valueForm);
    }

    public <V2> ValueMap<K, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean containsKey(Object keyObject) {
        Class<?> keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            return this.inner.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object valueObject) {
        Class<?> valueType = this.valueForm.type();
        if (valueType == null || valueType.isInstance(valueObject)) {
            Value value = this.valueForm.mold(valueObject).toValue();
            return this.inner.containsValue(value);
        }
        return false;
    }

    @Override
    public V get(Object keyObject) {
        Value key;
        Value value;
        V valueObject;
        Class<?> keyType = this.keyForm.type();
        if ((keyType == null || keyType.isInstance(keyObject)) && (valueObject = this.valueForm.cast(value = this.inner.get(key = this.keyForm.mold(keyObject).toValue()))) != null) {
            return valueObject;
        }
        return this.valueForm.unit();
    }

    @Override
    public V put(K keyObject, V newValueObject) {
        Value newValue;
        Value key = this.keyForm.mold(keyObject).toValue();
        Value oldValue = this.inner.put(key, newValue = this.valueForm.mold(newValueObject).toValue());
        V oldValueObject = this.valueForm.cast(oldValue);
        if (oldValueObject != null) {
            return oldValueObject;
        }
        return this.valueForm.unit();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.inner.putAll(map);
        }
    }

    @Override
    public V remove(Object keyObject) {
        Value key;
        Value oldValue;
        V oldValueObject;
        Class<?> keyType = this.keyForm.type();
        if ((keyType == null || keyType.isInstance(keyObject)) && (oldValueObject = this.valueForm.cast(oldValue = this.inner.remove(key = this.keyForm.mold(keyObject).toValue()))) != null) {
            return oldValueObject;
        }
        return this.valueForm.unit();
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            return new ValueMapEntrySet<K, V>(this.inner, this.keyForm, this.valueForm);
        }
        return this.inner.entrySet();
    }

    @Override
    public Set<K> keySet() {
        if (this.keyForm != Form.forValue()) {
            return new ValueSet<K>(this.inner.keySet(), this.keyForm);
        }
        return this.inner.keySet();
    }

    @Override
    public Collection<V> values() {
        if (this.valueForm != Form.forValue()) {
            return new ValueCollection<V>(this.inner.values(), this.valueForm);
        }
        return this.inner.values();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (this.size() != that.size()) {
                return false;
            }
            try {
                for (Map.Entry<K, V> entry : this.entrySet()) {
                    K keyObject = entry.getKey();
                    V valueObject = entry.getValue();
                    if (!(valueObject != null ? !valueObject.equals(that.get(keyObject)) : that.get(keyObject) != null || !that.containsKey(keyObject))) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        Iterator<Map.Entry<K, V>> these = this.entrySet().iterator();
        int code = 0;
        while (these.hasNext()) {
            code += these.next().hashCode();
        }
        return code;
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> these = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (these.hasNext()) {
            sb.append(these.next());
            while (these.hasNext()) {
                sb.append(", ").append(these.next());
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

