/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.collections;

import java.util.Comparator;
import java.util.Map;
import swim.structure.Form;
import swim.structure.Value;
import swim.structure.collections.ValueEntry;
import swim.structure.collections.ValueIterableMap;
import swim.structure.collections.ValueOrderedMapCursor;
import swim.util.IterableMap;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;

public class ValueOrderedMap<K, V>
extends ValueIterableMap<K, V>
implements OrderedMap<K, V> {
    public ValueOrderedMap(OrderedMap<? extends Value, ? extends Value> inner, Form<K> keyForm, Form<V> valueForm) {
        super((IterableMap<? extends Value, ? extends Value>)inner, keyForm, valueForm);
    }

    public OrderedMap<Value, Value> inner() {
        return (OrderedMap)this.inner;
    }

    @Override
    public <K2> ValueOrderedMap<K2, V> keyForm(Form<K2> keyForm) {
        return new ValueOrderedMap<K2, V>((OrderedMap<? extends Value, ? extends Value>)((OrderedMap)this.inner), keyForm, this.valueForm);
    }

    @Override
    public <K2> ValueOrderedMap<K2, V> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    @Override
    public <V2> ValueOrderedMap<K, V2> valueForm(Form<V2> valueForm) {
        return new ValueOrderedMap<K, V2>((OrderedMap<? extends Value, ? extends Value>)((OrderedMap)this.inner), this.keyForm, valueForm);
    }

    @Override
    public <V2> ValueOrderedMap<K, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public int indexOf(Object keyObject) {
        Class<?> keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            return ((OrderedMap)this.inner).indexOf((Object)key);
        }
        throw new IllegalArgumentException(keyObject.toString());
    }

    public Map.Entry<K, V> getEntry(Object keyObject) {
        Value key;
        Map.Entry entry;
        Class<?> keyType = this.keyForm.type();
        if ((keyType == null || keyType.isInstance(keyObject)) && (entry = ((OrderedMap)this.inner).getEntry((Object)(key = this.keyForm.mold(keyObject).toValue()))) != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public Map.Entry<K, V> getIndex(int index) {
        Map.Entry entry = ((OrderedMap)this.inner).getIndex(index);
        if (entry != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public Map.Entry<K, V> firstEntry() {
        Map.Entry entry = ((OrderedMap)this.inner).firstEntry();
        if (entry != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public K firstKey() {
        Value key = (Value)((OrderedMap)this.inner).firstKey();
        Object keyObject = this.keyForm.cast(key);
        if (keyObject != null) {
            return (K)keyObject;
        }
        return (K)this.keyForm.unit();
    }

    public V firstValue() {
        Value value = (Value)((OrderedMap)this.inner).firstValue();
        Object object = this.valueForm.cast(value);
        if (object != null) {
            return (V)object;
        }
        return (V)this.valueForm.unit();
    }

    public Map.Entry<K, V> lastEntry() {
        Map.Entry entry = ((OrderedMap)this.inner).lastEntry();
        if (entry != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public K lastKey() {
        Value key = (Value)((OrderedMap)this.inner).lastKey();
        Object keyObject = this.keyForm.cast(key);
        if (keyObject != null) {
            return (K)keyObject;
        }
        return (K)this.keyForm.unit();
    }

    public V lastValue() {
        Value value = (Value)((OrderedMap)this.inner).lastValue();
        Object object = this.valueForm.cast(value);
        if (object != null) {
            return (V)object;
        }
        return (V)this.valueForm.unit();
    }

    public Map.Entry<K, V> nextEntry(Object keyObject) {
        Value key;
        Map.Entry entry;
        Class<?> keyType = this.keyForm.type();
        if ((keyType == null || keyType.isInstance(keyObject)) && (entry = ((OrderedMap)this.inner).nextEntry((Object)(key = this.keyForm.mold(keyObject).toValue()))) != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public K nextKey(Object keyObject) {
        Class<?> keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            Value nextKey = (Value)((OrderedMap)this.inner).nextKey((Object)key);
            Object nextKeyObject = this.keyForm.cast(nextKey);
            if (nextKeyObject != null) {
                return (K)nextKeyObject;
            }
            return (K)this.keyForm.unit();
        }
        return null;
    }

    public V nextValue(Object keyObject) {
        Class<?> keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            Value nextValue = (Value)((OrderedMap)this.inner).nextValue((Object)key);
            Object nextObject = this.valueForm.cast(nextValue);
            if (nextObject != null) {
                return (V)nextObject;
            }
            return (V)this.valueForm.unit();
        }
        return null;
    }

    public Map.Entry<K, V> previousEntry(Object keyObject) {
        Value key;
        Map.Entry entry;
        Class<?> keyType = this.keyForm.type();
        if ((keyType == null || keyType.isInstance(keyObject)) && (entry = ((OrderedMap)this.inner).previousEntry((Object)(key = this.keyForm.mold(keyObject).toValue()))) != null) {
            return new ValueEntry(entry, this.keyForm, this.valueForm);
        }
        return null;
    }

    public K previousKey(Object keyObject) {
        Class<?> keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            Value previousKey = (Value)((OrderedMap)this.inner).previousKey((Object)key);
            Object previousKeyObject = this.keyForm.cast(previousKey);
            if (previousKeyObject != null) {
                return (K)previousKeyObject;
            }
            return (K)this.keyForm.unit();
        }
        return null;
    }

    public V previousValue(Object keyObject) {
        Class<?> keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            Value previousValue = (Value)((OrderedMap)this.inner).previousValue((Object)key);
            Object previousObject = this.valueForm.cast(previousValue);
            if (previousObject != null) {
                return (V)previousObject;
            }
            return (V)this.valueForm.unit();
        }
        return null;
    }

    public OrderedMap<K, V> headMap(K toKeyObject) {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            Value toKey = this.keyForm.mold(toKeyObject).toValue();
            return new ValueOrderedMap<K, V>((OrderedMap<? extends Value, ? extends Value>)((OrderedMap)this.inner).headMap((Object)toKey), this.keyForm, this.valueForm);
        }
        return ((OrderedMap)this.inner).headMap((Object)((Value)toKeyObject));
    }

    public OrderedMap<K, V> tailMap(K fromKeyObject) {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            Value fromKey = this.keyForm.mold(fromKeyObject).toValue();
            return new ValueOrderedMap<K, V>((OrderedMap<? extends Value, ? extends Value>)((OrderedMap)this.inner).tailMap((Object)fromKey), this.keyForm, this.valueForm);
        }
        return ((OrderedMap)this.inner).tailMap((Object)((Value)fromKeyObject));
    }

    public OrderedMap<K, V> subMap(K fromKeyObject, K toKeyObject) {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            Value fromKey = this.keyForm.mold(fromKeyObject).toValue();
            Value toKey = this.keyForm.mold(toKeyObject).toValue();
            return new ValueOrderedMap<K, V>((OrderedMap<? extends Value, ? extends Value>)((OrderedMap)this.inner).subMap((Object)fromKey, (Object)toKey), this.keyForm, this.valueForm);
        }
        return ((OrderedMap)this.inner).subMap((Object)((Value)fromKeyObject), (Object)((Value)toKeyObject));
    }

    public OrderedMapCursor<K, V> iterator() {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            return new ValueOrderedMapCursor((OrderedMapCursor<? extends Value, ? extends Value>)((OrderedMap)this.inner).iterator(), this.keyForm, this.valueForm);
        }
        return ((OrderedMap)this.inner).iterator();
    }

    public Comparator<? super K> comparator() {
        return null;
    }
}

