/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.Map;
import swim.runtime.downlink.DownlinkRelay;
import swim.runtime.downlink.ListDownlinkModel;
import swim.runtime.downlink.ListDownlinkView;
import swim.structure.Attr;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.EventMessage;

final class ListDownlinkRelayUpdate
extends DownlinkRelay<ListDownlinkModel, ListDownlinkView<?>> {
    final EventMessage message;
    Object key;
    final int index;
    Form<Object> valueForm;
    Value oldValue;
    Value newValue;
    Object oldObject;
    Object newObject;

    ListDownlinkRelayUpdate(ListDownlinkModel model, EventMessage message, int index, Value newValue, Object key) {
        super(model, 4);
        this.message = message;
        this.index = index;
        this.key = key;
        this.newValue = newValue;
    }

    ListDownlinkRelayUpdate(ListDownlinkModel model, int index, Value newValue, Object key) {
        super(model, 1, 3);
        this.message = null;
        this.index = index;
        this.key = key;
        this.newValue = newValue;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            if (((ListDownlinkModel)this.model).isStateful()) {
                Map.Entry entry = this.index < ((ListDownlinkModel)this.model).state.size() ? ((ListDownlinkModel)this.model).state.getEntry(this.index, this.key) : null;
                if (entry == null) {
                    ((ListDownlinkModel)this.model).state.add(this.index, (Object)this.newValue, this.key);
                    if (this.key == null) {
                        entry = ((ListDownlinkModel)this.model).state.getEntry(this.index);
                        this.key = entry.getKey();
                    }
                } else {
                    this.oldValue = (Value)entry.getValue();
                    this.key = entry.getKey();
                    ((ListDownlinkModel)this.model).state.set(this.index, (Object)this.newValue, this.key);
                }
            }
            if (this.oldValue == null) {
                this.oldValue = Value.absent();
            }
        }
    }

    @Override
    boolean runPhase(ListDownlinkView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            this.newValue = view.downlinkWillUpdateValue(this.index, this.newValue);
            Map.Entry entry = ((ListDownlinkModel)this.model).state.getEntry(this.index, this.key);
            if (entry != null) {
                this.oldValue = (Value)entry.getValue();
                this.key = entry.getKey();
            }
            Form valueForm = view.valueForm;
            this.valueForm = valueForm;
            this.oldObject = valueForm.cast((Item)this.newValue);
            if (this.oldObject == null) {
                this.oldObject = valueForm.unit();
            }
            if (preemptive) {
                this.newObject = view.downlinkWillUpdate(this.index, this.oldObject);
            }
            Map.Entry<Boolean, Object> result = view.dispatchWillUpdate(this.index, this.oldObject, preemptive);
            this.newObject = result.getValue();
            if (this.oldObject != this.newObject) {
                this.oldObject = this.newObject;
                this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            view.downlinkDidUpdateValue(this.index, this.newValue, this.oldValue);
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.downlinkDidUpdate(this.index, this.newObject, this.oldObject);
            }
            return view.dispatchDidUpdate(this.index, this.newObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        if (this.message != null) {
            ((ListDownlinkModel)this.model).cueDown();
        } else {
            Record header = Record.create((int)2).slot("key", Value.fromObject((Object)this.key)).slot("index", this.index);
            ((ListDownlinkModel)this.model).pushUp((Value)Attr.of((String)"update", (Value)header).concat((Item)this.newValue));
        }
    }
}

