/*
 * Decompiled with CFR 0.152.
 */
package swim.args;

import swim.args.Arg;
import swim.args.ExecCmd;
import swim.args.ExecHelpCmd;
import swim.args.Opt;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.collections.FingerTrieSeq;
import swim.util.Murmur3;

public class Cmd
implements Cloneable,
Debug {
    final String id;
    final String name;
    String desc;
    FingerTrieSeq<Opt> opts;
    FingerTrieSeq<Cmd> cmds;
    ExecCmd exec;
    Cmd base;
    private static int hashSeed;

    public Cmd(String id, String name, String desc, FingerTrieSeq<Opt> opts, FingerTrieSeq<Cmd> cmds, ExecCmd exec, Cmd base) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.opts = opts;
        this.cmds = cmds;
        this.exec = exec;
        this.base = base;
    }

    public Cmd base() {
        return this.base;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String desc() {
        return this.desc;
    }

    public Cmd desc(String desc) {
        this.desc = desc;
        return this;
    }

    public FingerTrieSeq<Opt> opts() {
        return this.opts;
    }

    public Cmd opt(Opt opt) {
        this.opts = this.opts.appended((Object)opt);
        return this;
    }

    public Cmd opt(String opt) {
        return this.opt(Opt.of(opt));
    }

    public FingerTrieSeq<Cmd> cmds() {
        return this.cmds;
    }

    public Cmd cmd(Cmd cmd) {
        this.cmds = this.cmds.appended((Object)cmd);
        return this;
    }

    public Cmd cmd(String cmd) {
        return this.cmd(Cmd.of(cmd));
    }

    public Opt getOpt(String name) {
        int n = this.opts.size();
        for (int i = 0; i < n; ++i) {
            Opt opt = (Opt)this.opts.get(i);
            if (!name.equals(opt.name)) continue;
            return opt;
        }
        throw new IllegalArgumentException("undefined opt: " + name);
    }

    public Cmd parse(String[] params) {
        return this.parse(params, 1);
    }

    public Cmd parse(String[] params, int paramIndex) {
        int paramCount = params.length;
        int optCount = this.opts.size();
        int cmdCount = this.cmds.size();
        while (paramIndex < paramCount) {
            String param = params[paramIndex];
            for (int cmdIndex = 0; cmdIndex < cmdCount; ++cmdIndex) {
                Cmd cmd = (Cmd)this.cmds.get(cmdIndex);
                if (!param.equals(cmd.name)) continue;
                Cmd subCmd = cmd;
                subCmd.base = this;
                return subCmd.parse(params, paramIndex + 1);
            }
            ++paramIndex;
            int argLength = param.length();
            if (argLength > 2 && param.charAt(0) == '-' && param.charAt(1) == '-') {
                String name = param.substring(2);
                for (int optIndex = 0; optIndex < optCount; ++optIndex) {
                    Opt opt = (Opt)this.opts.get(optIndex);
                    if (!name.equals(opt.name)) continue;
                    ++opt.defs;
                    paramIndex = opt.parse(params, paramIndex);
                }
                continue;
            }
            if (argLength <= 1 || param.charAt(0) != '-') continue;
            for (int flagIndex = 1; flagIndex < argLength; ++flagIndex) {
                char flag = param.charAt(flagIndex);
                for (int optIndex = 0; optIndex < optCount; ++optIndex) {
                    Opt opt = (Opt)this.opts.get(optIndex);
                    if (flag != opt.flag) continue;
                    ++opt.defs;
                    if (argLength != 2) continue;
                    paramIndex = opt.parse(params, paramIndex);
                }
            }
        }
        return this;
    }

    public ExecCmd exec() {
        return this.exec;
    }

    public Cmd exec(ExecCmd exec) {
        this.exec = exec;
        return this;
    }

    public void run() {
        if (this.exec != null) {
            this.exec.exec(this);
        }
    }

    public Cmd helpCmd() {
        return this.cmd(Cmd.help());
    }

    public void writeFullName(Output<String> output) {
        if (this.base != null) {
            this.base.writeFullName(output);
            output.write(32);
        }
        output.write(this.name);
    }

    public void writeHelp(Output<String> output) {
        int cmdCount;
        output.write("Usage: ");
        this.writeFullName(output);
        int optCount = this.opts.size();
        if (optCount != 0) {
            output.write(" [options]");
        }
        if ((cmdCount = this.cmds.size()) != 0) {
            output.write(" <command>");
        }
        output.writeln();
        if (optCount != 0) {
            output.writeln();
            output.writeln("Options:");
            for (int optIndex = 0; optIndex < optCount; ++optIndex) {
                Opt opt = (Opt)this.opts.get(optIndex);
                if (opt.flag != '\u0000') {
                    output.write("  -").write((int)opt.flag).write(", --").write(opt.name);
                } else {
                    output.write("      --").write(opt.name);
                }
                int optLength = opt.name.length();
                int argCount = opt.args.size();
                for (int argIndex = 0; argIndex < argCount; ++argIndex) {
                    Arg arg = (Arg)opt.args.get(argIndex);
                    output.write(32).write(60).write(arg.name).write(62);
                    optLength += 2 + arg.name.length() + 1;
                    if (!arg.optional) continue;
                    output.write(63);
                    ++optLength;
                }
                for (int i = optLength; i < 15; ++i) {
                    output.write(32);
                }
                if (opt.desc != null) {
                    output.write(32).write(opt.desc);
                }
                output.writeln();
            }
        }
        if (cmdCount != 0) {
            output.writeln();
            output.writeln("Commands:");
            for (int cmdIndex = 0; cmdIndex < cmdCount; ++cmdIndex) {
                Cmd cmd = (Cmd)this.cmds.get(cmdIndex);
                output.write("  ").write(cmd.name);
                for (int i = cmd.name.length(); i < 20; ++i) {
                    output.write(32);
                }
                if (cmd.desc != null) {
                    output.write("  ").write(cmd.desc);
                }
                output.writeln();
            }
        }
    }

    public String toHelp() {
        Output output = Unicode.stringOutput();
        this.writeHelp((Output<String>)output);
        return (String)output.bind();
    }

    public boolean canEqual(Object other) {
        return other instanceof Cmd;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Cmd) {
            Cmd that = (Cmd)other;
            return that.canEqual(this) && this.id.equals(that.id) && this.name.equals(that.name) && (this.desc == null ? that.desc == null : this.desc.equals(that.desc)) && this.opts.equals(that.opts) && this.cmds.equals(that.cmds) && (this.exec == null ? that.exec == null : this.exec.equals(that.exec));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Cmd.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.id.hashCode()), (int)this.name.hashCode()), (int)Murmur3.hash((Object)this.desc)), (int)this.opts.hashCode()), (int)this.cmds.hashCode()), (int)Murmur3.hash((Object)this.exec)));
    }

    public void debug(Output<?> output) {
        output = output.write("Cmd").write(46).write("of").write(40).debug((Object)this.name).write(41);
        if (this.desc != null) {
            output = output.write(46).write("flag").write(40).debug((Object)this.desc).write(41);
        }
        int optCount = this.opts.size();
        for (int optIndex = 0; optIndex < optCount; ++optIndex) {
            Opt opt = (Opt)this.opts.get(optIndex);
            output = output.write(46).write("opt").write(40).debug((Object)opt).write(41);
        }
        int cmdCount = this.cmds.size();
        for (int cmdIndex = 0; cmdIndex < cmdCount; ++cmdIndex) {
            Cmd cmd = (Cmd)this.cmds.get(cmdIndex);
            output = output.write(46).write("cmd").write(40).debug((Object)cmd).write(41);
        }
        if (this.exec != null) {
            output = output.write(46).write("exec").write(40).debug((Object)this.exec).write(41);
        }
        if (this.base != null) {
            output = output.write(46).write("base").write(40).debug((Object)this.base).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public Cmd clone() {
        int optCount = this.opts.size();
        FingerTrieSeq opts = FingerTrieSeq.empty();
        for (int i = 0; i < optCount; ++i) {
            opts = opts.appended((Object)((Opt)this.opts.get(i)).clone());
        }
        int cmdCount = this.cmds.size();
        FingerTrieSeq cmds = FingerTrieSeq.empty();
        for (int i = 0; i < cmdCount; ++i) {
            cmds = cmds.appended((Object)((Cmd)this.cmds.get(i)).clone());
        }
        return new Cmd(this.id, this.name, this.desc, (FingerTrieSeq<Opt>)opts, (FingerTrieSeq<Cmd>)cmds, this.exec, this.base);
    }

    public static Cmd of(String id, String name) {
        return new Cmd(id, name, null, (FingerTrieSeq<Opt>)FingerTrieSeq.empty(), (FingerTrieSeq<Cmd>)FingerTrieSeq.empty(), null, null);
    }

    public static Cmd of(String id) {
        return new Cmd(id, id, null, (FingerTrieSeq<Opt>)FingerTrieSeq.empty(), (FingerTrieSeq<Cmd>)FingerTrieSeq.empty(), null, null);
    }

    public static Cmd help() {
        return new Cmd("help", "help", null, (FingerTrieSeq<Opt>)FingerTrieSeq.empty(), (FingerTrieSeq<Cmd>)FingerTrieSeq.empty(), new ExecHelpCmd(), null);
    }
}

