/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.Product;
import swim.http.header.ServerParser;
import swim.http.header.ServerWriter;
import swim.util.Builder;
import swim.util.Murmur3;

public final class Server
extends HttpHeader {
    final FingerTrieSeq<Product> products;
    private static int hashSeed;

    Server(FingerTrieSeq<Product> products) {
        this.products = products;
    }

    @Override
    public String lowerCaseName() {
        return "server";
    }

    @Override
    public String name() {
        return "Server";
    }

    public FingerTrieSeq<Product> products() {
        return this.products;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return ServerWriter.write(output, http, this.products.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Server) {
            Server that = (Server)other;
            return this.products.equals(that.products);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Server.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.products.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("Server").write(46).write("from").write(40);
        int n = this.products.size();
        if (n > 0) {
            output.debug(this.products.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.products.get(i));
            }
        }
        output = output.write(41);
    }

    public static Server from(FingerTrieSeq<Product> products) {
        return new Server(products);
    }

    public static Server from(Product ... products) {
        return new Server((FingerTrieSeq<Product>)FingerTrieSeq.of((Object[])products));
    }

    public static Server from(String ... productStrings) {
        Builder products = FingerTrieSeq.builder();
        int n = productStrings.length;
        for (int i = 0; i < n; ++i) {
            products.add((Object)Product.parse(productStrings[i]));
        }
        return new Server((FingerTrieSeq<Product>)((FingerTrieSeq)products.bind()));
    }

    public static Parser<Server> parseHttpValue(Input input, HttpParser http) {
        return ServerParser.parse(input, http);
    }
}

