/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Map;
import java.util.NoSuchElementException;
import swim.util.OrderedMapCursor;

final class BTreeLeafCursor<K, V>
implements OrderedMapCursor<K, V> {
    final Map.Entry<K, V>[] array;
    int index;
    int limit;

    BTreeLeafCursor(Map.Entry<K, V>[] array, int index, int limit) {
        this.array = array;
        this.index = index;
        this.limit = limit;
    }

    public boolean isEmpty() {
        return this.index >= this.limit;
    }

    public Map.Entry<K, V> head() {
        if (this.index < this.limit) {
            return this.array[this.index];
        }
        throw new NoSuchElementException();
    }

    public void step() {
        if (this.index >= this.limit) {
            throw new UnsupportedOperationException();
        }
        this.index = 1;
    }

    public void skip(long count) {
        this.index = (int)Math.max(0L, Math.min((long)this.index + count, (long)this.limit));
    }

    public boolean hasNext() {
        return this.index < this.limit;
    }

    public long nextIndexLong() {
        return this.index;
    }

    public int nextIndex() {
        return this.index;
    }

    public K nextKey() {
        return this.array[this.index].getKey();
    }

    public Map.Entry<K, V> next() {
        int index = this.index;
        if (index < this.limit) {
            this.index = index + 1;
            return this.array[index];
        }
        this.index = this.limit;
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public long previousIndexLong() {
        return this.index - 1;
    }

    public int previousIndex() {
        return this.index - 1;
    }

    public K previousKey() {
        return this.array[this.index - 1].getKey();
    }

    public Map.Entry<K, V> previous() {
        int index = this.index - 1;
        if (index >= 0) {
            this.index = index;
            return this.array[index];
        }
        this.index = 0;
        throw new NoSuchElementException();
    }
}

