/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.PrecisionForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public final class Precision
implements Debug {
    final int bits;
    private static int hashSeed;
    private static Precision undefined;
    private static Precision f16;
    private static Precision f32;
    private static Precision f64;
    private static Form<Precision> form;

    Precision(int bits) {
        this.bits = bits;
    }

    public boolean isDefined() {
        return this.bits != 0;
    }

    public boolean isHalf() {
        return this.bits == 16;
    }

    public boolean isSingle() {
        return this.bits == 32;
    }

    public boolean isDouble() {
        return this.bits == 64;
    }

    public int bits() {
        return this.bits;
    }

    public int bytes() {
        return (this.bits + 7) / 8;
    }

    public Precision min(Precision that) {
        return Precision.fromBits(Math.min(this.bits, that.bits));
    }

    public Precision max(Precision that) {
        return Precision.fromBits(Math.max(this.bits, that.bits));
    }

    public Value toValue() {
        return Precision.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Precision) {
            Precision that = (Precision)other;
            return this.bits == that.bits;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Precision.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.bits));
    }

    public void debug(Output<?> output) {
        output = output.write("Precision").write(46);
        output = this.bits == 0 ? output.write("undefined").write(40).write(41) : (this.bits == 16 ? output.write("f16").write(40).write(41) : (this.bits == 32 ? output.write("f32").write(40).write(41) : (this.bits == 64 ? output.write("f64").write(40).write(41) : output.write("fromBits").write(40).debug((Object)this.bits).write(41))));
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static Precision undefined() {
        if (undefined == null) {
            undefined = new Precision(0);
        }
        return undefined;
    }

    public static Precision f16() {
        if (f16 == null) {
            f16 = new Precision(16);
        }
        return f16;
    }

    public static Precision f32() {
        if (f32 == null) {
            f32 = new Precision(32);
        }
        return f32;
    }

    public static Precision f64() {
        if (f64 == null) {
            f64 = new Precision(64);
        }
        return f64;
    }

    public static Precision fromBits(int bits) {
        if (bits < 0) {
            throw new IllegalArgumentException();
        }
        if (bits == 0) {
            return Precision.undefined();
        }
        if (bits == 16) {
            return Precision.f16();
        }
        if (bits == 32) {
            return Precision.f32();
        }
        if (bits == 64) {
            return Precision.f64();
        }
        return new Precision(bits);
    }

    @Kind
    public static Form<Precision> form() {
        if (form == null) {
            form = new PrecisionForm();
        }
        return form;
    }
}

