/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.BoxR3;
import swim.math.PointR3;
import swim.math.R3Form;
import swim.math.R3Shape;
import swim.math.SphereR3;
import swim.structure.Item;
import swim.structure.Value;

final class R3ShapeForm
extends R3Form<R3Shape> {
    R3ShapeForm() {
    }

    public Class<?> type() {
        return R3Shape.class;
    }

    @Override
    public double getXMin(R3Shape shape) {
        return shape.xMin();
    }

    @Override
    public double getYMin(R3Shape shape) {
        return shape.yMin();
    }

    @Override
    public double getZMin(R3Shape shape) {
        return shape.zMin();
    }

    @Override
    public double getXMax(R3Shape shape) {
        return shape.xMax();
    }

    @Override
    public double getYMax(R3Shape shape) {
        return shape.yMax();
    }

    @Override
    public double getZMax(R3Shape shape) {
        return shape.zMax();
    }

    @Override
    public boolean contains(R3Shape outer, R3Shape inner) {
        return outer.contains(inner);
    }

    @Override
    public boolean intersects(R3Shape s, R3Shape t) {
        return s.intersects(t);
    }

    public Item mold(R3Shape shape) {
        if (shape != null) {
            return shape.toValue();
        }
        return Item.extant();
    }

    public R3Shape cast(Item item) {
        Value value = item.toValue();
        String tag = value.tag();
        if ("point".equals(tag)) {
            return (R3Shape)PointR3.form().cast((Item)value);
        }
        if ("box".equals(tag)) {
            return (R3Shape)BoxR3.form().cast((Item)value);
        }
        if ("sphere".equals(tag)) {
            return (R3Shape)SphereR3.form().cast((Item)value);
        }
        return null;
    }
}

