/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.R2ToZ2Function;
import swim.math.TensorForm;
import swim.math.VectorR2Form;
import swim.math.VectorZ2;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class VectorR2
implements Debug {
    public final double x;
    public final double y;
    private static int hashSeed;
    private static VectorR2 zero;
    private static TensorForm<VectorR2> form;

    public VectorR2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final VectorR2 plus(VectorR2 that) {
        return new VectorR2(this.x + that.x, this.y + that.y);
    }

    public final VectorR2 opposite() {
        return new VectorR2(-this.x, -this.y);
    }

    public final VectorR2 minus(VectorR2 that) {
        return new VectorR2(this.x - that.x, this.y - that.y);
    }

    public final VectorR2 times(double scalar) {
        return new VectorR2(this.x * scalar, this.y * scalar);
    }

    public VectorZ2 transform(R2ToZ2Function f) {
        return new VectorZ2(f.transformX(this.x, this.y), f.transformY(this.x, this.y));
    }

    public Value toValue() {
        return VectorR2.form().mold(this).toValue();
    }

    protected boolean canEqual(VectorR2 that) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof VectorR2) {
            VectorR2 that = (VectorR2)other;
            return that.canEqual(this) && this.x == that.x && this.y == that.y;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(VectorR2.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((double)this.x)), (int)Murmur3.hash((double)this.y)));
    }

    public void debug(Output<?> output) {
        output.write("VectorR2").write(46).write("of").write(40).debug((Object)this.x).write(", ").debug((Object)this.y).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static VectorR2 zero() {
        if (zero == null) {
            zero = new VectorR2(0.0, 0.0);
        }
        return zero;
    }

    public static VectorR2 of(double x, double y) {
        return new VectorR2(x, y);
    }

    @Kind
    public static TensorForm<VectorR2> form() {
        if (form == null) {
            form = new VectorR2Form();
        }
        return form;
    }
}

