/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.nio.ByteBuffer;
import swim.codec.Output;
import swim.codec.OutputSettings;

abstract class ByteOutput<T>
extends Output<T> {
    byte[] array;
    int size;
    OutputSettings settings;

    ByteOutput(byte[] array, int size, OutputSettings settings) {
        this.array = array;
        this.size = size;
        this.settings = settings;
    }

    @Override
    public final boolean isCont() {
        return true;
    }

    @Override
    public final boolean isFull() {
        return false;
    }

    @Override
    public final boolean isDone() {
        return false;
    }

    @Override
    public final boolean isError() {
        return false;
    }

    @Override
    public final boolean isPart() {
        return false;
    }

    @Override
    public final Output<T> isPart(boolean isPart) {
        return this;
    }

    @Override
    public final Output<T> write(int b) {
        byte[] newArray;
        int n = this.size;
        byte[] oldArray = this.array;
        if (oldArray == null || n + 1 > oldArray.length) {
            newArray = new byte[ByteOutput.expand(n + 1)];
            if (oldArray != null) {
                System.arraycopy(oldArray, 0, newArray, 0, n);
            }
            this.array = newArray;
        } else {
            newArray = oldArray;
        }
        newArray[n] = (byte)b;
        this.size = n + 1;
        return this;
    }

    @Override
    public Output<T> write(String string) {
        throw new UnsupportedOperationException("binary output");
    }

    @Override
    public Output<T> writeln(String string) {
        throw new UnsupportedOperationException("binary output");
    }

    @Override
    public Output<T> writeln() {
        throw new UnsupportedOperationException("binary output");
    }

    final byte[] toByteArray() {
        int n = this.size;
        byte[] oldArray = this.array;
        if (oldArray != null && n == oldArray.length) {
            return oldArray;
        }
        byte[] newArray = new byte[n];
        if (oldArray != null) {
            System.arraycopy(oldArray, 0, newArray, 0, n);
        }
        this.array = newArray;
        return newArray;
    }

    final ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.array != null ? this.array : new byte[]{}, 0, this.size);
    }

    final byte[] cloneArray() {
        byte[] oldArray = this.array;
        if (oldArray != null) {
            int n = this.size;
            byte[] newArray = new byte[n];
            System.arraycopy(oldArray, 0, newArray, 0, n);
            return newArray;
        }
        return null;
    }

    @Override
    public OutputSettings settings() {
        return this.settings;
    }

    @Override
    public Output<T> settings(OutputSettings settings) {
        this.settings = settings;
        return this;
    }

    static int expand(int n) {
        n = Math.max(32, n) - 1;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }
}

