/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import swim.concurrent.Stage;
import swim.concurrent.Task;
import swim.concurrent.TaskContext;
import swim.concurrent.TaskException;

public abstract class AbstractTask
implements Task {
    protected TaskContext taskContext;

    @Override
    public final TaskContext taskContext() {
        return this.taskContext;
    }

    @Override
    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    @Override
    public abstract void runTask();

    @Override
    public boolean taskWillBlock() {
        return false;
    }

    @Override
    public void taskWillCue() {
    }

    @Override
    public void taskDidCancel() {
    }

    public Stage stage() {
        TaskContext taskContext = this.taskContext;
        if (taskContext == null) {
            throw new TaskException("Unbound Task");
        }
        return taskContext.stage();
    }

    public boolean isCued() {
        TaskContext taskContext = this.taskContext;
        return taskContext != null && taskContext.isCued();
    }

    public boolean cue() {
        TaskContext taskContext = this.taskContext;
        if (taskContext == null) {
            throw new TaskException("Unbound Task");
        }
        return taskContext.cue();
    }

    public boolean cancel() {
        TaskContext taskContext = this.taskContext;
        if (taskContext == null) {
            return false;
        }
        return taskContext.cancel();
    }
}

