/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.deflate.DeflateException;
import swim.ws.WsDeflateEncoder;
import swim.ws.WsFrame;
import swim.ws.WsOpcode;

final class WsFrameDeflater<O>
extends Encoder<Object, WsFrame<O>> {
    final WsDeflateEncoder ws;
    final WsFrame<O> frame;
    final Encoder<?, ?> content;
    final long position;
    final long offset;

    WsFrameDeflater(WsDeflateEncoder ws, WsFrame<O> frame, Encoder<?, ?> content, long position, long offset) {
        this.ws = ws;
        this.frame = frame;
        this.content = content;
        this.position = position;
        this.offset = offset;
    }

    WsFrameDeflater(WsDeflateEncoder ws, WsFrame<O> frame) {
        this(ws, frame, null, 0L, 0L);
    }

    public Encoder<Object, WsFrame<O>> pull(OutputBuffer<?> output) {
        return WsFrameDeflater.encode(output, this.ws, this.frame, this.content, this.position, this.offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <O> Encoder<Object, WsFrame<O>> encode(OutputBuffer<?> output, WsDeflateEncoder ws, WsFrame<O> frame, Encoder<?, ?> content, long position, long offset) {
        int maskSize;
        boolean isMasked = ws.isMasked();
        int outputSize = output.remaining();
        int n = maskSize = isMasked ? 4 : 0;
        int maxHeaderSize = (outputSize <= 127 ? 2 : (outputSize <= 65539 ? 4 : 10)) + maskSize;
        if (outputSize >= maxHeaderSize) {
            int outputBase = output.index();
            int maxPayloadBase = outputBase + maxHeaderSize;
            ws.deflate.input = content == null ? frame.contentEncoder(ws) : content;
            ws.deflate.next_out = output.array();
            ws.deflate.next_out_index = output.arrayOffset() + maxPayloadBase;
            ws.deflate.avail_out = outputSize - maxHeaderSize;
            try {
                int finRsvOp;
                boolean needsMore = ws.deflate.deflate(ws.flush);
                content = ws.deflate.input;
                boolean eof = content.isDone() && !needsMore;
                int payloadSize = ws.deflate.next_out_index - (output.arrayOffset() + maxPayloadBase) - (eof ? 4 : 0);
                int headerSize = (payloadSize <= 125 ? 2 : (payloadSize <= 65535 ? 4 : 10)) + maskSize;
                WsOpcode opcode = frame.opcode();
                if (eof) {
                    finRsvOp = offset == 0L ? 0xC0 | opcode.code : 128;
                } else {
                    if (content.isError()) {
                        Encoder encoder = content.asError();
                        return encoder;
                    }
                    finRsvOp = offset == 0L ? 0x40 | opcode.code : 0;
                }
                output = output.index(outputBase);
                output = output.write(finRsvOp);
                output = payloadSize < 126 ? output.write(isMasked ? 0x80 | payloadSize : payloadSize) : (payloadSize < 65536 ? output.write(isMasked ? 254 : 126).write(payloadSize >>> 8).write(payloadSize) : output.write(isMasked ? 255 : 127).write(0).write(0).write(0).write(0).write(payloadSize >>> 24).write(payloadSize >>> 16).write(payloadSize >>> 8).write(payloadSize));
                if (isMasked) {
                    byte[] maskingKey = new byte[4];
                    ws.maskingKey(maskingKey);
                    output = output.write(maskingKey[0] & 0xFF).write(maskingKey[1] & 0xFF).write(maskingKey[2] & 0xFF).write(maskingKey[3] & 0xFF);
                    for (int i = 0; i < payloadSize; ++i) {
                        output.set(outputBase + headerSize + i, (output.get(outputBase + maxHeaderSize + i) ^ maskingKey[(int)(position + (long)i) & 3]) & 0xFF);
                    }
                } else if (headerSize < maxHeaderSize) {
                    output = output.move(maxHeaderSize, headerSize, payloadSize);
                }
                position += (long)payloadSize;
                offset += (long)payloadSize;
                output = output.index(outputBase + headerSize + payloadSize);
                if (eof) {
                    Encoder encoder = WsFrameDeflater.done(frame);
                    return encoder;
                }
            }
            catch (DeflateException cause) {
                Encoder encoder = WsFrameDeflater.error((Throwable)new EncoderException((Throwable)cause));
                return encoder;
            }
            finally {
                ws.deflate.input = null;
                ws.deflate.next_out = null;
                ws.deflate.next_out_index = 0;
                ws.deflate.avail_out = 0;
            }
        }
        if (output.isDone()) {
            return WsFrameDeflater.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return WsFrameDeflater.error((Throwable)output.trap());
        }
        return new WsFrameDeflater<O>(ws, frame, content, position, offset);
    }

    static <O> Encoder<Object, WsFrame<O>> encode(OutputBuffer<?> output, WsDeflateEncoder ws, WsFrame<O> frame) {
        return WsFrameDeflater.encode(output, ws, frame, null, 0L, 0L);
    }
}

