/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.ws.WsEncoder;
import swim.ws.WsFrame;
import swim.ws.WsOpcode;

final class WsFrameEncoder<O>
extends Encoder<Object, WsFrame<O>> {
    final WsEncoder ws;
    final WsFrame<O> frame;
    final Encoder<?, ?> content;
    final long position;
    final long offset;

    WsFrameEncoder(WsEncoder ws, WsFrame<O> frame, Encoder<?, ?> content, long position, long offset) {
        this.ws = ws;
        this.frame = frame;
        this.content = content;
        this.position = position;
        this.offset = offset;
    }

    WsFrameEncoder(WsEncoder ws, WsFrame<O> frame) {
        this(ws, frame, null, 0L, 0L);
    }

    public Encoder<Object, WsFrame<O>> pull(OutputBuffer<?> output) {
        return WsFrameEncoder.encode(output, this.ws, this.frame, this.content, this.position, this.offset);
    }

    static <O> Encoder<Object, WsFrame<O>> encode(OutputBuffer<?> output, WsEncoder ws, WsFrame<O> frame, Encoder<?, ?> content, long position, long offset) {
        int maskSize;
        boolean isMasked = ws.isMasked();
        int outputSize = output.remaining();
        int n = maskSize = isMasked ? 4 : 0;
        int maxHeaderSize = (outputSize <= 127 ? 2 : (outputSize <= 65539 ? 4 : 10)) + maskSize;
        if (outputSize >= maxHeaderSize) {
            int finRsvOp;
            int outputBase = output.index();
            int maxPayloadBase = outputBase + maxHeaderSize;
            output = output.index(maxPayloadBase);
            Encoder<?, ?> nextContent = content == null ? frame.encodeContent(output, ws) : content.pull(output);
            int payloadSize = output.index() - maxPayloadBase;
            int headerSize = (payloadSize <= 125 ? 2 : (payloadSize <= 65535 ? 4 : 10)) + maskSize;
            WsOpcode opcode = frame.opcode();
            if (nextContent.isDone()) {
                finRsvOp = offset == 0L ? 0x80 | opcode.code : 128;
            } else {
                if (nextContent.isError()) {
                    return nextContent.asError();
                }
                finRsvOp = offset == 0L ? opcode.code : 0;
            }
            output = output.index(outputBase);
            if (!opcode.isControl() || (finRsvOp & 0x80) != 0) {
                content = nextContent;
                output = output.write(finRsvOp);
                output = payloadSize < 126 ? output.write(isMasked ? 0x80 | payloadSize : payloadSize) : (payloadSize < 65536 ? output.write(isMasked ? 254 : 126).write(payloadSize >>> 8).write(payloadSize) : output.write(isMasked ? 255 : 127).write(0).write(0).write(0).write(0).write(payloadSize >>> 24).write(payloadSize >>> 16).write(payloadSize >>> 8).write(payloadSize));
                if (isMasked) {
                    byte[] maskingKey = new byte[4];
                    ws.maskingKey(maskingKey);
                    output = output.write(maskingKey[0] & 0xFF).write(maskingKey[1] & 0xFF).write(maskingKey[2] & 0xFF).write(maskingKey[3] & 0xFF);
                    for (int i = 0; i < payloadSize; ++i) {
                        output.set(outputBase + headerSize + i, (output.get(outputBase + maxHeaderSize + i) ^ maskingKey[(int)(position + (long)i) & 3]) & 0xFF);
                    }
                } else if (headerSize < maxHeaderSize) {
                    output = output.move(maxHeaderSize, headerSize, payloadSize);
                }
                position += (long)payloadSize;
                offset += (long)payloadSize;
                output = output.index(outputBase + headerSize + payloadSize);
                if (content.isDone()) {
                    return WsFrameEncoder.done(frame);
                }
            }
        }
        if (output.isDone()) {
            return WsFrameEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return WsFrameEncoder.error((Throwable)output.trap());
        }
        return new WsFrameEncoder<O>(ws, frame, content, position, offset);
    }

    static <O> Encoder<Object, WsFrame<O>> encode(OutputBuffer<?> output, WsEncoder ws, WsFrame<O> frame) {
        return WsFrameEncoder.encode(output, ws, frame, null, 0L, 0L);
    }
}

