/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Output;
import swim.codec.OutputSettings;
import swim.codec.Unicode;

public final class Format {
    private static String lineSeparator;

    private Format() {
    }

    public static void display(Object object, Output<?> output) {
        if (object == null) {
            output = output.write("null");
        } else if (object instanceof Integer) {
            Format.displayInt((Integer)object, output);
        } else if (object instanceof Long) {
            Format.displayLong((Long)object, output);
        } else if (object instanceof Display) {
            ((Display)object).display(output);
        } else {
            output = output.write(object.toString());
        }
    }

    public static String display(Object object, OutputSettings settings) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Display) {
            Output<String> output = Unicode.stringOutput(settings);
            ((Display)object).display(output);
            return output.bind();
        }
        return object.toString();
    }

    public static String display(Object object) {
        return Format.display(object, OutputSettings.standard());
    }

    public static void debug(Object object, Output<?> output) {
        if (object == null) {
            output = output.write("null");
        } else if (object instanceof Integer) {
            Format.debugInt((Integer)object, output);
        } else if (object instanceof Long) {
            Format.debugLong((Long)object, output);
        } else if (object instanceof Float) {
            Format.debugFloat(((Float)object).floatValue(), output);
        } else if (object instanceof Character) {
            Format.debugChar(((Character)object).charValue(), output);
        } else if (object instanceof String) {
            Format.debugString((String)object, output);
        } else if (object instanceof Debug) {
            ((Debug)object).debug(output);
        } else {
            output = output.write(object.toString());
        }
    }

    public static String debug(Object object, OutputSettings settings) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Integer) {
            Output<String> output = Unicode.stringOutput(settings);
            Format.debugInt((Integer)object, output);
            return output.bind();
        }
        if (object instanceof Long) {
            Output<String> output = Unicode.stringOutput(settings);
            Format.debugLong((Long)object, output);
            return output.bind();
        }
        if (object instanceof Float) {
            Output<String> output = Unicode.stringOutput(settings);
            Format.debugFloat(((Float)object).floatValue(), output);
            return output.bind();
        }
        if (object instanceof Character) {
            Output<String> output = Unicode.stringOutput(settings);
            Format.debugChar(((Character)object).charValue(), output);
            return output.bind();
        }
        if (object instanceof String) {
            Output<String> output = Unicode.stringOutput(settings);
            Format.debugString((String)object, output);
            return output.bind();
        }
        if (object instanceof Debug) {
            Output<String> output = Unicode.stringOutput(settings);
            ((Debug)object).debug(output);
            return output.bind();
        }
        return object.toString();
    }

    public static String debug(Object object) {
        return Format.debug(object, OutputSettings.standard());
    }

    public static void displayInt(int value, Output<?> output) {
        if (value < 0) {
            output = output.write(45);
        }
        if (value > -10 && value < 10) {
            output = output.write(48 + Math.abs(value));
        } else {
            byte[] digits = new byte[10];
            long x = value;
            int i = 9;
            while (x != 0L) {
                digits[i] = (byte)Math.abs(x % 10L);
                x /= 10L;
                --i;
            }
            ++i;
            while (i < 10) {
                output = output.write(48 + digits[i]);
                ++i;
            }
        }
    }

    public static void displayLong(long value, Output<?> output) {
        if (value < 0L) {
            output = output.write(45);
        }
        if (value > -10L && value < 10L) {
            output = output.write(48 + Math.abs((int)value));
        } else {
            byte[] digits = new byte[19];
            long x = value;
            int i = 18;
            while (x != 0L) {
                digits[i] = (byte)Math.abs((int)(x % 10L));
                x /= 10L;
                --i;
            }
            ++i;
            while (i < 19) {
                output = output.write(48 + digits[i]);
                ++i;
            }
        }
    }

    public static void displayFloat(float value, Output<?> output) {
        output = output.write(Float.toString(value)).write(102);
    }

    public static void displayDouble(double value, Output<?> output) {
        output = output.write(Double.toString(value));
    }

    public static void debugInt(int value, Output<?> output) {
        Format.displayInt(value, output);
    }

    public static void debugLong(long value, Output<?> output) {
        Format.displayLong(value, output);
        output = output.write(76);
    }

    public static void debugFloat(float value, Output<?> output) {
        output = output.write(Float.toString(value)).write(102);
    }

    public static void debugDouble(double value, Output<?> output) {
        output = output.write(Double.toString(value));
    }

    public static void debugChar(int character, Output<?> output) {
        output = output.write(39);
        switch (character) {
            case 8: {
                output.write(92).write(98);
                break;
            }
            case 9: {
                output.write(92).write(116);
                break;
            }
            case 10: {
                output.write(92).write(110);
                break;
            }
            case 12: {
                output.write(92).write(102);
                break;
            }
            case 13: {
                output.write(92).write(114);
                break;
            }
            case 34: {
                output.write(92).write(34);
                break;
            }
            case 39: {
                output.write(92).write(39);
                break;
            }
            case 92: {
                output.write(92).write(92);
                break;
            }
            default: {
                output = character >= 0 && character <= 31 || character >= 127 && character <= 159 ? output.write(92).write(117).write(Format.encodeHex(character >>> 12 & 0xF)).write(Format.encodeHex(character >>> 8 & 0xF)).write(Format.encodeHex(character >>> 4 & 0xF)).write(Format.encodeHex(character & 0xF)) : output.write(character);
            }
        }
        output = output.write(39);
    }

    public static void debugString(String string, Output<?> output) {
        output = output.write(34);
        int n = string.length();
        int i = 0;
        while (i < n) {
            int c = string.codePointAt(i);
            switch (c) {
                case 8: {
                    output.write(92).write(98);
                    break;
                }
                case 9: {
                    output.write(92).write(116);
                    break;
                }
                case 10: {
                    output.write(92).write(110);
                    break;
                }
                case 12: {
                    output.write(92).write(102);
                    break;
                }
                case 13: {
                    output.write(92).write(114);
                    break;
                }
                case 34: {
                    output.write(92).write(34);
                    break;
                }
                case 92: {
                    output.write(92).write(92);
                    break;
                }
                default: {
                    output = c >= 0 && c <= 31 || c >= 127 && c <= 159 ? output.write(92).write(117).write(Format.encodeHex(c >>> 12 & 0xF)).write(Format.encodeHex(c >>> 8 & 0xF)).write(Format.encodeHex(c >>> 4 & 0xF)).write(Format.encodeHex(c & 0xF)) : output.write(c);
                }
            }
            i = string.offsetByCodePoints(i, 1);
        }
        output = output.write(34);
    }

    private static char encodeHex(int x) {
        if (x < 10) {
            return (char)(48 + x);
        }
        return (char)(65 + (x - 10));
    }

    public static String lineSeparator() {
        if (lineSeparator == null) {
            lineSeparator = System.getProperty("line.separator", "\n");
        }
        return lineSeparator;
    }
}

