/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.InputDone;
import swim.codec.InputEmpty;
import swim.codec.InputError;
import swim.codec.InputException;
import swim.codec.InputSettings;
import swim.codec.Mark;

public abstract class Input {
    private static Input empty;
    private static Input done;

    public abstract boolean isCont();

    public abstract boolean isEmpty();

    public abstract boolean isDone();

    public abstract boolean isError();

    public abstract boolean isPart();

    public abstract Input isPart(boolean var1);

    public abstract int head();

    public abstract Input step();

    public abstract Input seek(Mark var1);

    public Input fork(Object condition) {
        return this;
    }

    public Throwable trap() {
        throw new InputException();
    }

    public abstract Object id();

    public abstract Input id(Object var1);

    public abstract Mark mark();

    public abstract Input mark(Mark var1);

    public long offset() {
        return this.mark().offset;
    }

    public int line() {
        return this.mark().line;
    }

    public int column() {
        return this.mark().column;
    }

    public abstract InputSettings settings();

    public abstract Input settings(InputSettings var1);

    public abstract Input clone();

    public static Input empty() {
        if (empty == null) {
            empty = new InputEmpty(null, Mark.zero(), InputSettings.standard());
        }
        return empty;
    }

    public static Input empty(InputSettings settings) {
        if (settings == InputSettings.standard()) {
            return Input.empty();
        }
        return new InputEmpty(null, Mark.zero(), settings);
    }

    public static Input empty(Object id, Mark mark) {
        if (id == null && (mark == null || mark == Mark.zero())) {
            return Input.empty();
        }
        return new InputEmpty(id, mark, InputSettings.standard());
    }

    public static Input empty(Object id, Mark mark, InputSettings settings) {
        if (id == null && (mark == null || mark == Mark.zero()) && settings == InputSettings.standard()) {
            return Input.empty();
        }
        return new InputEmpty(id, mark, settings);
    }

    public static Input done() {
        if (done == null) {
            done = new InputDone(null, Mark.zero(), InputSettings.standard());
        }
        return done;
    }

    public static Input done(InputSettings settings) {
        if (settings == InputSettings.standard()) {
            return Input.done();
        }
        return new InputDone(null, Mark.zero(), settings);
    }

    public static Input done(Object id, Mark mark) {
        if (id == null && (mark == null || mark == Mark.zero())) {
            return Input.done();
        }
        return new InputDone(id, mark, InputSettings.standard());
    }

    public static Input done(Object id, Mark mark, InputSettings settings) {
        if (id == null && (mark == null || mark == Mark.zero()) && settings == InputSettings.standard()) {
            return Input.done();
        }
        return new InputDone(id, mark, settings);
    }

    public static Input error(Throwable error) {
        return new InputError(error, null, Mark.zero(), InputSettings.standard());
    }

    public static Input error(Throwable error, InputSettings settings) {
        return new InputError(error, null, Mark.zero(), settings);
    }

    public static Input error(Throwable error, Object id, Mark mark) {
        return new InputError(error, id, mark, InputSettings.standard());
    }

    public static Input error(Throwable error, Object id, Mark mark, InputSettings settings) {
        return new InputError(error, id, mark, settings);
    }
}

