/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Output;
import swim.codec.OutputException;
import swim.codec.OutputSettings;
import swim.codec.UtfErrorMode;

final class Utf8EncodedOutput<T>
extends Output<T> {
    Output<T> output;
    UtfErrorMode errorMode;
    int c2;
    int c3;
    int c4;
    int index;

    Utf8EncodedOutput(Output<T> output, UtfErrorMode errorMode, int c2, int c3, int c4, int index) {
        this.output = output;
        this.errorMode = errorMode;
        this.c2 = c2;
        this.c3 = c3;
        this.c4 = c4;
        this.index = index;
    }

    Utf8EncodedOutput(Output<T> output, UtfErrorMode errorMode) {
        this(output, errorMode, 0, 0, 0, 4);
    }

    @Override
    public boolean isCont() {
        return this.output.isCont();
    }

    @Override
    public boolean isFull() {
        return this.output.isFull();
    }

    @Override
    public boolean isDone() {
        return this.output.isDone();
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isPart() {
        return this.output.isPart();
    }

    @Override
    public Output<T> isPart(boolean isPart) {
        this.output = this.output.isPart(isPart);
        return this;
    }

    @Override
    public Output<T> write(int c) {
        int index;
        int c1 = 0;
        int c2 = this.c2;
        int c3 = this.c3;
        int c4 = this.c4;
        block11: for (index = this.index; index < 4; ++index) {
            if (this.output.isCont()) {
                switch (index) {
                    case 1: {
                        this.output = this.output.write(c2);
                        this.c2 = 0;
                        continue block11;
                    }
                    case 2: {
                        this.output = this.output.write(c3);
                        this.c3 = 0;
                        continue block11;
                    }
                    case 3: {
                        this.output = this.output.write(c4);
                        this.c4 = 0;
                        continue block11;
                    }
                    default: {
                        throw new AssertionError((Object)"unreachable");
                    }
                }
            }
            return Utf8EncodedOutput.error(new OutputException("unable to flush buffered code units"));
        }
        if (c >= 0 && c <= 127) {
            c4 = c;
            index = 3;
        } else if (c >= 128 && c <= 2047) {
            c3 = 0xC0 | c >>> 6;
            c4 = 0x80 | c & 0x3F;
            index = 2;
        } else if (c >= 2048 && c <= 65535 || c >= 57344 && c <= 65535) {
            c2 = 0xE0 | c >>> 12;
            c3 = 0x80 | c >>> 6 & 0x3F;
            c4 = 0x80 | c & 0x3F;
            index = 1;
        } else if (c >= 65536 && c <= 0x10FFFF) {
            c1 = 0xF0 | c >>> 18;
            c2 = 0x80 | c >>> 12 & 0x3F;
            c3 = 0x80 | c >>> 6 & 0x3F;
            c4 = 0x80 | c & 0x3F;
            index = 0;
        } else {
            if (this.errorMode.isFatal()) {
                return Utf8EncodedOutput.error(new OutputException("invalid code point: U+" + Integer.toHexString(c)));
            }
            return this.write(this.errorMode.replacementChar());
        }
        do {
            switch (index) {
                case 0: {
                    this.output = this.output.write(c1);
                    break;
                }
                case 1: {
                    this.output = this.output.write(c2);
                    this.c2 = 0;
                    break;
                }
                case 2: {
                    this.output = this.output.write(c3);
                    this.c3 = 0;
                    break;
                }
                case 3: {
                    this.output = this.output.write(c4);
                    this.c4 = 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unreachable");
                }
            }
        } while (++index < 4 && this.output.isCont());
        if (index < 4) {
            if (index < 3) {
                if (index < 2) {
                    this.c2 = c2;
                }
                this.c3 = c3;
            }
            this.c4 = c4;
        }
        this.index = index;
        return this;
    }

    @Override
    public Output<T> flush() {
        int index;
        block5: for (index = this.index; index < 4; ++index) {
            if (this.output.isCont()) {
                switch (index) {
                    case 1: {
                        this.output = this.output.write(this.c2);
                        this.c2 = 0;
                        continue block5;
                    }
                    case 2: {
                        this.output = this.output.write(this.c3);
                        this.c3 = 0;
                        continue block5;
                    }
                    case 3: {
                        this.output = this.output.write(this.c4);
                        this.c4 = 0;
                        continue block5;
                    }
                    default: {
                        throw new AssertionError((Object)"unreachable");
                    }
                }
            }
            return Utf8EncodedOutput.error(new OutputException("unable to flush buffered code units"));
        }
        this.index = index;
        return this;
    }

    @Override
    public OutputSettings settings() {
        return this.output.settings();
    }

    @Override
    public Output<T> settings(OutputSettings settings) {
        this.output.settings(settings);
        return this;
    }

    @Override
    public Output<T> fork(Object condition) {
        if (condition instanceof Output) {
            this.output = (Output)condition;
        }
        return this;
    }

    @Override
    public T bind() {
        return this.output.bind();
    }

    @Override
    public Output<T> clone() {
        return new Utf8EncodedOutput<T>(this.output.clone(), this.errorMode, this.c2, this.c3, this.c4, this.index);
    }
}

