/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.BoxZ2;
import swim.math.Z2Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class BoxZ2Form
extends Z2Form<BoxZ2> {
    BoxZ2Form() {
    }

    public String tag() {
        return "box";
    }

    public Class<?> type() {
        return BoxZ2.class;
    }

    @Override
    public long getXMin(BoxZ2 box) {
        return box.xMin;
    }

    @Override
    public long getYMin(BoxZ2 box) {
        return box.yMin;
    }

    @Override
    public long getXMax(BoxZ2 box) {
        return box.xMax;
    }

    @Override
    public long getYMax(BoxZ2 box) {
        return box.yMax;
    }

    @Override
    public boolean contains(BoxZ2 outer, BoxZ2 inner) {
        return outer.contains(inner);
    }

    @Override
    public boolean intersects(BoxZ2 s, BoxZ2 t) {
        return s.intersects(t);
    }

    public Item mold(BoxZ2 box) {
        if (box != null) {
            return Record.create((int)1).attr(this.tag(), (Value)Record.create((int)4).item(box.xMin).item(box.yMin).item(box.xMax).item(box.yMax));
        }
        return Item.extant();
    }

    public BoxZ2 cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            long xMin = header.getItem(0).longValue(0L);
            long yMin = header.getItem(1).longValue(0L);
            long xMax = header.getItem(2).longValue(0L);
            long yMax = header.getItem(3).longValue(0L);
            return new BoxZ2(xMin, yMin, xMax, yMax);
        }
        return null;
    }
}

