/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.json.JsonFormParser;
import swim.json.JsonFormWriter;
import swim.json.JsonModelParser;
import swim.json.JsonModelWriter;
import swim.json.JsonParser;
import swim.json.JsonWriter;
import swim.structure.Data;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;

public final class Json {
    private static JsonParser<Item, Value> modelParser;
    private static JsonWriter<Item, Value> modelWriter;

    private Json() {
    }

    static boolean isSpace(int c) {
        return c == 32 || c == 9;
    }

    static boolean isNewline(int c) {
        return c == 10 || c == 13;
    }

    static boolean isWhitespace(int c) {
        return Json.isSpace(c) || Json.isNewline(c);
    }

    static boolean isIdentStartChar(int c) {
        return c >= 65 && c <= 90 || c == 95 || c >= 97 && c <= 122 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    static boolean isIdentChar(int c) {
        return c == 45 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c == 95 || c >= 97 && c <= 122 || c == 183 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8255 && c <= 8256 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    public static JsonParser<Item, Value> modelParser() {
        if (modelParser == null) {
            modelParser = new JsonModelParser();
        }
        return modelParser;
    }

    public static JsonWriter<Item, Value> modelWriter() {
        if (modelWriter == null) {
            modelWriter = new JsonModelWriter();
        }
        return modelWriter;
    }

    public static Value parse(String json) {
        return Json.modelParser().parseValueString(json);
    }

    public static Parser<Value> parser() {
        return Json.modelParser().valueParser();
    }

    public static Writer<?, ?> write(Item item, Output<?> output) {
        return Json.modelWriter().writeItem(item, output);
    }

    public static String toString(Item item) {
        Output output = Unicode.stringOutput();
        Json.write(item, output);
        return (String)output.bind();
    }

    public static Data toData(Item item) {
        Output output = Utf8.encodedOutput((Output)Data.output());
        Json.write(item, output);
        return (Data)output.bind();
    }

    public static <T> Parser<T> formParser(Form<T> form) {
        return new JsonFormParser<T>(Json.modelParser(), form);
    }

    public static <T> Decoder<T> formDecoder(Form<T> form) {
        return Utf8.decodedParser(Json.formParser(form));
    }

    public static <T> Writer<T, T> formWriter(Form<T> form) {
        return new JsonFormWriter<T>(Json.modelWriter(), form);
    }

    public static <T> Encoder<T, T> formEncoder(Form<T> form) {
        return Utf8.encodedWriter(Json.formWriter(form));
    }
}

