/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import swim.math.R2Shape;
import swim.math.R2ToZ2Operator;
import swim.math.Z2Form;
import swim.math.Z2ToR2Operator;
import swim.spatial.SphericalMercator;
import swim.spatial.SphericalMercatorInverse;
import swim.spatial.WGS84;
import swim.spatial.WGS84Inverse;

public final class GeoProjection {
    private static WGS84 wgs84;
    private static WGS84Inverse wgs84Inverse;
    private static SphericalMercator sphericalMercator;
    private static SphericalMercatorInverse sphericalMercatorInverse;

    private GeoProjection() {
    }

    public static R2ToZ2Operator wgs84() {
        if (wgs84 == null) {
            wgs84 = new WGS84();
        }
        return wgs84;
    }

    public static Z2ToR2Operator wgs84Inverse() {
        if (wgs84Inverse == null) {
            wgs84Inverse = new WGS84Inverse();
        }
        return wgs84Inverse;
    }

    public static Z2Form<R2Shape> wgs84Form() {
        if (wgs84 == null) {
            wgs84 = new WGS84();
        }
        return wgs84;
    }

    public static R2ToZ2Operator sphericalMercator() {
        if (sphericalMercator == null) {
            sphericalMercator = new SphericalMercator();
        }
        return sphericalMercator;
    }

    public static Z2ToR2Operator sphericalMercatorInverse() {
        if (sphericalMercatorInverse == null) {
            sphericalMercatorInverse = new SphericalMercatorInverse();
        }
        return sphericalMercatorInverse;
    }

    public static Z2Form<R2Shape> sphericalMercatorForm() {
        if (sphericalMercator == null) {
            sphericalMercator = new SphericalMercator();
        }
        return sphericalMercator;
    }
}

