/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.data.DataFactory;
import swim.api.data.ListData;
import swim.api.data.MapData;
import swim.api.data.SpatialData;
import swim.api.data.ValueData;
import swim.api.downlink.Downlink;
import swim.api.lane.CommandLane;
import swim.api.lane.DemandLane;
import swim.api.lane.DemandMapLane;
import swim.api.lane.JoinMapLane;
import swim.api.lane.JoinValueLane;
import swim.api.lane.Lane;
import swim.api.lane.LaneFactory;
import swim.api.lane.ListLane;
import swim.api.lane.MapLane;
import swim.api.lane.SpatialLane;
import swim.api.lane.SupplyLane;
import swim.api.lane.ValueLane;
import swim.api.policy.Policy;
import swim.collections.HashTrieMap;
import swim.concurrent.Call;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.concurrent.Task;
import swim.concurrent.TaskContext;
import swim.concurrent.TaskFunction;
import swim.concurrent.TaskRef;
import swim.concurrent.TimerFunction;
import swim.concurrent.TimerRef;
import swim.math.R2Shape;
import swim.math.Z2Form;
import swim.runtime.AbstractTierBinding;
import swim.runtime.CellContext;
import swim.runtime.HttpBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.NodeBinding;
import swim.runtime.NodeContext;
import swim.runtime.PushRequest;
import swim.runtime.TierContext;
import swim.runtime.agent.AgentLane;
import swim.runtime.agent.AgentTimer;
import swim.runtime.lane.CommandLaneView;
import swim.runtime.lane.DemandLaneView;
import swim.runtime.lane.DemandMapLaneView;
import swim.runtime.lane.JoinMapLaneView;
import swim.runtime.lane.JoinValueLaneView;
import swim.runtime.lane.LaneView;
import swim.runtime.lane.ListLaneView;
import swim.runtime.lane.MapLaneView;
import swim.runtime.lane.SpatialLaneView;
import swim.runtime.lane.SupplyLaneView;
import swim.runtime.lane.ValueLaneView;
import swim.runtime.uplink.ErrorUplinkModem;
import swim.runtime.uplink.HttpErrorUplinkModem;
import swim.spatial.GeoProjection;
import swim.store.DataBinding;
import swim.store.ListDataBinding;
import swim.store.MapDataBinding;
import swim.store.SpatialDataBinding;
import swim.store.ValueDataBinding;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriPath;
import swim.uri.UriScheme;

public class AgentNode
extends AbstractTierBinding
implements NodeBinding,
CellContext,
LaneFactory,
DataFactory,
Schedule,
Stage,
Task {
    protected NodeContext nodeContext;
    protected TaskContext taskContext;
    volatile HashTrieMap<Uri, LaneBinding> lanes = HashTrieMap.empty();
    volatile HashTrieMap<Value, DataBinding> data = HashTrieMap.empty();
    final ConcurrentLinkedQueue<Runnable> mailbox = new ConcurrentLinkedQueue();
    static final AtomicReferenceFieldUpdater<AgentNode, HashTrieMap<Uri, LaneBinding>> LANES = AtomicReferenceFieldUpdater.newUpdater(AgentNode.class, HashTrieMap.class, "lanes");
    static final AtomicReferenceFieldUpdater<AgentNode, HashTrieMap<Value, DataBinding>> DATA = AtomicReferenceFieldUpdater.newUpdater(AgentNode.class, HashTrieMap.class, "data");

    @Override
    public TierContext tierContext() {
        return this.nodeContext;
    }

    @Override
    public NodeContext nodeContext() {
        return this.nodeContext;
    }

    @Override
    public void setNodeContext(NodeContext nodeContext) {
        this.nodeContext = nodeContext;
        nodeContext.stage().task((TaskFunction)this);
    }

    public TaskContext taskContext() {
        return this.taskContext;
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    @Override
    public <T> T unwrapNode(Class<T> nodeClass) {
        if (nodeClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    protected LaneContext createLaneContext(LaneBinding lane, Uri laneUri) {
        return new AgentLane(this, lane, laneUri);
    }

    @Override
    public final Uri meshUri() {
        return this.nodeContext.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.nodeContext.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.nodeContext.hostUri();
    }

    @Override
    public final Uri nodeUri() {
        return this.nodeContext.nodeUri();
    }

    @Override
    public Value agentKey() {
        return Value.absent();
    }

    protected static Uri normalizeLaneUri(Uri laneUri) {
        if (laneUri.query().isDefined() || laneUri.fragment().isDefined()) {
            laneUri = Uri.from((UriScheme)laneUri.scheme(), (UriAuthority)laneUri.authority(), (UriPath)laneUri.path());
        }
        return laneUri;
    }

    @Override
    public HashTrieMap<Uri, LaneBinding> getLanes() {
        return this.lanes;
    }

    @Override
    public LaneBinding getLane(Uri laneUri) {
        laneUri = AgentNode.normalizeLaneUri(laneUri);
        return (LaneBinding)this.lanes.get((Object)laneUri);
    }

    public LaneBinding openLaneView(Uri laneUri, LaneView laneView) {
        HashTrieMap newLanes;
        HashTrieMap oldLanes;
        laneUri = AgentNode.normalizeLaneUri(laneUri);
        LaneBinding laneBinding = null;
        do {
            if ((oldLanes = this.lanes).containsKey((Object)laneUri)) {
                laneBinding = (LaneBinding)oldLanes.get((Object)laneUri);
                newLanes = oldLanes;
                break;
            }
            if (laneBinding != null) continue;
            laneBinding = this.nodeContext.injectLane(laneUri, laneView.createLaneBinding());
            LaneContext laneContext = this.createLaneContext(laneBinding, laneUri);
            laneBinding.setLaneContext(laneContext);
        } while (oldLanes != (newLanes = oldLanes.updated((Object)laneUri, (Object)laneBinding)) && !LANES.compareAndSet(this, (HashTrieMap<Uri, LaneBinding>)oldLanes, (HashTrieMap<Uri, LaneBinding>)newLanes));
        laneBinding.openLaneView(laneView);
        if (oldLanes != newLanes) {
            this.activate(laneBinding);
        }
        return laneBinding;
    }

    public LaneBinding openLane(Uri laneUri, Lane lane) {
        laneUri = AgentNode.normalizeLaneUri(laneUri);
        return this.openLaneView(laneUri, (LaneView)lane);
    }

    @Override
    public LaneBinding openLane(Uri laneUri, LaneBinding lane) {
        HashTrieMap newLanes;
        HashTrieMap oldLanes;
        laneUri = AgentNode.normalizeLaneUri(laneUri);
        LaneBinding laneBinding = null;
        do {
            if ((oldLanes = this.lanes).containsKey((Object)laneUri)) {
                laneBinding = null;
                newLanes = oldLanes;
                break;
            }
            if (laneBinding != null) continue;
            laneBinding = this.nodeContext.injectLane(laneUri, lane);
            LaneContext laneContext = this.createLaneContext(laneBinding, laneUri);
            laneBinding.setLaneContext(laneContext);
        } while (oldLanes != (newLanes = oldLanes.updated((Object)laneUri, laneBinding)) && !LANES.compareAndSet(this, (HashTrieMap<Uri, LaneBinding>)oldLanes, (HashTrieMap<Uri, LaneBinding>)newLanes));
        if (laneBinding != null) {
            this.activate(laneBinding);
        }
        return laneBinding;
    }

    public void closeLane(Uri laneUri) {
        HashTrieMap newLanes;
        HashTrieMap oldLanes;
        laneUri = AgentNode.normalizeLaneUri(laneUri);
        LaneBinding laneBinding = null;
        do {
            LaneBinding lane;
            if ((lane = (LaneBinding)(oldLanes = this.lanes).get((Object)laneUri)) == null) {
                laneBinding = null;
                newLanes = oldLanes;
                break;
            }
            laneBinding = lane;
            newLanes = oldLanes.removed((Object)laneUri);
        } while (oldLanes != newLanes && !LANES.compareAndSet(this, (HashTrieMap<Uri, LaneBinding>)oldLanes, (HashTrieMap<Uri, LaneBinding>)newLanes));
        if (laneBinding != null) {
            laneBinding.didClose();
        }
    }

    public <V> CommandLane<V> commandLane() {
        return new CommandLaneView(null, null);
    }

    public <V> DemandLane<V> demandLane() {
        return new DemandLaneView(null, null);
    }

    public <K, V> DemandMapLane<K, V> demandMapLane() {
        return new DemandMapLaneView(null, null, null);
    }

    public <L, K, V> JoinMapLane<L, K, V> joinMapLane() {
        return new JoinMapLaneView(null, null, null, null);
    }

    public <K, V> JoinValueLane<K, V> joinValueLane() {
        return new JoinValueLaneView(null, null, null);
    }

    public <V> ListLane<V> listLane() {
        return new ListLaneView(null, null);
    }

    public <K, V> MapLane<K, V> mapLane() {
        return new MapLaneView(null, null, null);
    }

    public <K, S, V> SpatialLane<K, S, V> spatialLane(Z2Form<S> shapeForm) {
        return new SpatialLaneView(null, null, shapeForm, null);
    }

    public <K, V> SpatialLane<K, R2Shape, V> geospatialLane() {
        return new SpatialLaneView(null, null, GeoProjection.wgs84Form(), null);
    }

    public <V> SupplyLane<V> supplyLane() {
        return new SupplyLaneView(null, null);
    }

    public <V> ValueLane<V> valueLane() {
        return new ValueLaneView(null, null);
    }

    public ListData<Value> listData(Value name) {
        ListDataBinding dataBinding = this.openListData(name);
        dataBinding = this.injectListData(dataBinding);
        return dataBinding;
    }

    public ListData<Value> listData(String name) {
        return this.listData((Value)Text.from((String)name));
    }

    public MapData<Value, Value> mapData(Value name) {
        MapDataBinding dataBinding = this.openMapData(name);
        dataBinding = this.injectMapData(dataBinding);
        return dataBinding;
    }

    public MapData<Value, Value> mapData(String name) {
        return this.mapData((Value)Text.from((String)name));
    }

    public <S> SpatialData<Value, S, Value> spatialData(Value name, Z2Form<S> shapeForm) {
        SpatialDataBinding<S> dataBinding = this.openSpatialData(name, shapeForm);
        dataBinding = this.injectSpatialData(dataBinding);
        return dataBinding;
    }

    public <S> SpatialData<Value, S, Value> spatialData(String name, Z2Form<S> shapeForm) {
        return this.spatialData((Value)Text.from((String)name), shapeForm);
    }

    public SpatialData<Value, R2Shape, Value> geospatialData(Value name) {
        return this.spatialData(name, GeoProjection.wgs84Form());
    }

    public SpatialData<Value, R2Shape, Value> geospatialData(String name) {
        return this.geospatialData((Value)Text.from((String)name));
    }

    public ValueData<Value> valueData(Value name) {
        ValueDataBinding dataBinding = this.openValueData(name);
        dataBinding = this.injectValueData(dataBinding);
        return dataBinding;
    }

    public ValueData<Value> valueData(String name) {
        return this.valueData((Value)Text.from((String)name));
    }

    public Iterator<DataBinding> dataBindings() {
        return this.data.valueIterator();
    }

    protected void openData(DataBinding dataBinding) {
        HashTrieMap newData;
        HashTrieMap<Value, DataBinding> oldData;
        while (!DATA.compareAndSet(this, oldData = this.data, (HashTrieMap<Value, DataBinding>)(newData = oldData.updated((Object)dataBinding.name(), (Object)dataBinding)))) {
        }
    }

    public void closeData(Value name) {
        HashTrieMap newData;
        HashTrieMap<Value, DataBinding> oldData;
        while (!DATA.compareAndSet(this, oldData = this.data, (HashTrieMap<Value, DataBinding>)(newData = oldData.removed((Object)name)))) {
        }
    }

    public ListDataBinding openListData(Value name) {
        return this.nodeContext.openListData(name);
    }

    public ListDataBinding injectListData(ListDataBinding dataBinding) {
        dataBinding = this.nodeContext.injectListData(dataBinding);
        this.openData((DataBinding)dataBinding);
        return dataBinding;
    }

    public MapDataBinding openMapData(Value name) {
        return this.nodeContext.openMapData(name);
    }

    public MapDataBinding injectMapData(MapDataBinding dataBinding) {
        dataBinding = this.nodeContext.injectMapData(dataBinding);
        this.openData((DataBinding)dataBinding);
        return dataBinding;
    }

    public <S> SpatialDataBinding<S> openSpatialData(Value name, Z2Form<S> shapeForm) {
        return this.nodeContext.openSpatialData(name, shapeForm);
    }

    public <S> SpatialDataBinding<S> injectSpatialData(SpatialDataBinding<S> dataBinding) {
        dataBinding = this.nodeContext.injectSpatialData(dataBinding);
        this.openData((DataBinding)dataBinding);
        return dataBinding;
    }

    public ValueDataBinding openValueData(Value name) {
        return this.nodeContext.openValueData(name);
    }

    public ValueDataBinding injectValueData(ValueDataBinding dataBinding) {
        dataBinding = this.nodeContext.injectValueData(dataBinding);
        this.openData((DataBinding)dataBinding);
        return dataBinding;
    }

    @Override
    public void openUplink(LinkBinding link) {
        Uri laneUri = AgentNode.normalizeLaneUri(link.laneUri());
        LaneBinding laneBinding = this.getLane(laneUri);
        if (laneBinding != null) {
            laneBinding.openUplink(link);
        } else {
            ErrorUplinkModem linkContext = new ErrorUplinkModem(link, (Value)Record.of().attr("laneNotFound"));
            link.setLinkContext(linkContext);
            linkContext.cueDown();
        }
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.nodeContext.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.nodeContext.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void httpUplink(HttpBinding http) {
        LaneBinding laneBinding = this.getLane(http.laneUri());
        if (laneBinding != null) {
            laneBinding.httpUplink(http);
        } else {
            HttpErrorUplinkModem httpContext = new HttpErrorUplinkModem(http);
            http.setHttpContext(httpContext);
        }
    }

    @Override
    public void httpDownlink(HttpBinding http) {
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        LaneBinding laneBinding = this.getLane(pushRequest.envelope().laneUri());
        if (laneBinding != null) {
            laneBinding.pushUp(pushRequest);
        } else {
            pushRequest.didDecline();
        }
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.nodeContext.pushDown(pushRequest);
    }

    public void trace(Object message) {
        this.nodeContext.trace(message);
    }

    public void debug(Object message) {
        this.nodeContext.debug(message);
    }

    public void info(Object message) {
        this.nodeContext.info(message);
    }

    public void warn(Object message) {
        this.nodeContext.warn(message);
    }

    public void error(Object message) {
        this.nodeContext.error(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator lanesIterator = this.lanes.valueIterator();
        while (lanesIterator.hasNext()) {
            ((LaneBinding)lanesIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    @Override
    public Policy policy() {
        return this.nodeContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this;
    }

    @Override
    public Stage stage() {
        return this;
    }

    @Override
    public DataFactory data() {
        return this;
    }

    public TimerRef timer(TimerFunction timer) {
        Schedule schedule = this.nodeContext.schedule();
        AgentTimer agentTimer = new AgentTimer(this, timer);
        schedule.timer(timer);
        return agentTimer;
    }

    public TimerRef setTimer(long millis, TimerFunction timer) {
        Schedule schedule = this.nodeContext.schedule();
        AgentTimer agentTimer = new AgentTimer(this, timer);
        schedule.setTimer(millis, (TimerFunction)agentTimer);
        return agentTimer;
    }

    public TaskRef task(TaskFunction task) {
        return this.nodeContext.stage().task(task);
    }

    public <T> Call<T> call(Cont<T> future) {
        return this.nodeContext.stage().call(future);
    }

    public void execute(Runnable command) {
        this.mailbox.add(command);
        this.taskContext.cue();
    }

    public boolean taskWillBlock() {
        return false;
    }

    public void runTask() {
        Runnable command;
        while ((command = this.mailbox.poll()) != null) {
            try {
                command.run();
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
        }
    }

    public void taskWillCue() {
    }

    public void taskDidCancel() {
    }
}

