/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.scope;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.data.DataFactory;
import swim.api.downlink.Downlink;
import swim.api.policy.Policy;
import swim.collections.HashTrieSet;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.math.Z2Form;
import swim.runtime.CellContext;
import swim.runtime.HttpBinding;
import swim.runtime.LinkBinding;
import swim.runtime.PushRequest;
import swim.store.ListDataBinding;
import swim.store.MapDataBinding;
import swim.store.SpatialDataBinding;
import swim.store.ValueDataBinding;
import swim.structure.Value;

public abstract class Scope
implements CellContext {
    protected final CellContext cellContext;
    protected final Stage stage;
    volatile HashTrieSet<LinkBinding> links;
    static final AtomicReferenceFieldUpdater<Scope, HashTrieSet<LinkBinding>> LINKS = AtomicReferenceFieldUpdater.newUpdater(Scope.class, HashTrieSet.class, "links");

    public Scope(CellContext cellContext, Stage stage) {
        this.cellContext = cellContext;
        this.stage = stage;
        this.links = HashTrieSet.empty();
    }

    public Scope(CellContext cellContext) {
        this(cellContext, cellContext.stage());
    }

    public final CellContext getCellContext() {
        return this.cellContext;
    }

    @Override
    public Policy policy() {
        return this.cellContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.cellContext.schedule();
    }

    @Override
    public final Stage stage() {
        return this.stage;
    }

    @Override
    public DataFactory data() {
        return this.cellContext.data();
    }

    public ListDataBinding openListData(Value name) {
        return this.cellContext.openListData(name);
    }

    public ListDataBinding injectListData(ListDataBinding dataBinding) {
        return this.cellContext.injectListData(dataBinding);
    }

    public MapDataBinding openMapData(Value name) {
        return this.cellContext.openMapData(name);
    }

    public MapDataBinding injectMapData(MapDataBinding dataBinding) {
        return this.cellContext.injectMapData(dataBinding);
    }

    public <S> SpatialDataBinding<S> openSpatialData(Value name, Z2Form<S> shapeForm) {
        return this.cellContext.openSpatialData(name, shapeForm);
    }

    public <S> SpatialDataBinding<S> injectSpatialData(SpatialDataBinding<S> dataBinding) {
        return this.cellContext.injectSpatialData(dataBinding);
    }

    public ValueDataBinding openValueData(Value name) {
        return this.cellContext.openValueData(name);
    }

    public ValueDataBinding injectValueData(ValueDataBinding dataBinding) {
        return this.cellContext.injectValueData(dataBinding);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        HashTrieSet newLinks;
        HashTrieSet<LinkBinding> oldLinks;
        LinkBinding link = this.cellContext.bindDownlink(downlink);
        link.setCellContext(this);
        while ((oldLinks = this.links) != (newLinks = oldLinks.added((Object)link)) && !LINKS.compareAndSet(this, oldLinks, (HashTrieSet<LinkBinding>)newLinks)) {
        }
        return link;
    }

    @Override
    public void openDownlink(LinkBinding link) {
        HashTrieSet newLinks;
        HashTrieSet<LinkBinding> oldLinks;
        this.cellContext.openDownlink(link);
        link.setCellContext(this);
        while ((oldLinks = this.links) != (newLinks = oldLinks.added((Object)link)) && !LINKS.compareAndSet(this, oldLinks, (HashTrieSet<LinkBinding>)newLinks)) {
        }
    }

    @Override
    public void closeDownlink(LinkBinding link) {
        HashTrieSet newLinks;
        HashTrieSet<LinkBinding> oldLinks;
        while ((oldLinks = this.links) != (newLinks = oldLinks.removed((Object)link)) && !LINKS.compareAndSet(this, oldLinks, (HashTrieSet<LinkBinding>)newLinks)) {
        }
    }

    @Override
    public void httpDownlink(HttpBinding http) {
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.cellContext.pushDown(pushRequest);
    }

    public void trace(Object message) {
        this.cellContext.trace(message);
    }

    public void debug(Object message) {
        this.cellContext.debug(message);
    }

    public void info(Object message) {
        this.cellContext.info(message);
    }

    public void warn(Object message) {
        this.cellContext.warn(message);
    }

    public void error(Object message) {
        this.cellContext.error(message);
    }

    public void close() {
        HashTrieSet<LinkBinding> oldLinks;
        HashTrieSet newLinks = HashTrieSet.empty();
        while ((oldLinks = this.links) != newLinks && !LINKS.compareAndSet(this, oldLinks, (HashTrieSet<LinkBinding>)newLinks)) {
        }
        Iterator linksIterator = oldLinks.iterator();
        while (linksIterator.hasNext()) {
            ((LinkBinding)linksIterator.next()).closeDown();
        }
    }
}

