/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpCharset;
import swim.http.HttpParser;
import swim.http.header.AcceptCharset;
import swim.util.Builder;

final class AcceptCharsetParser
extends Parser<AcceptCharset> {
    final HttpParser http;
    final Parser<HttpCharset> charset;
    final Builder<HttpCharset, FingerTrieSeq<HttpCharset>> charsets;
    final int step;

    AcceptCharsetParser(HttpParser http, Parser<HttpCharset> charset, Builder<HttpCharset, FingerTrieSeq<HttpCharset>> charsets, int step) {
        this.http = http;
        this.charset = charset;
        this.charsets = charsets;
        this.step = step;
    }

    AcceptCharsetParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<AcceptCharset> feed(Input input) {
        return AcceptCharsetParser.parse(input, this.http, this.charset, this.charsets, this.step);
    }

    static Parser<AcceptCharset> parse(Input input, HttpParser http, Parser<HttpCharset> charset, Builder<HttpCharset, FingerTrieSeq<HttpCharset>> charsets, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((charset = charset == null ? http.parseCharset(input) : charset.feed(input)).isDone()) {
                    if (charsets == null) {
                        charsets = FingerTrieSeq.builder();
                    }
                    charsets.add((Object)((HttpCharset)charset.bind()));
                    charset = null;
                    step = 2;
                } else if (charset.isError()) {
                    return charset.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return AcceptCharsetParser.done((Object)AcceptCharset.from((FingerTrieSeq<HttpCharset>)((FingerTrieSeq)charsets.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return AcceptCharsetParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(charset = charset == null ? http.parseCharset(input) : charset.feed(input)).isDone()) break;
                charsets.add((Object)((HttpCharset)charset.bind()));
                charset = null;
                step = 2;
            }
            if (charset.isError()) {
                return charset.asError();
            }
        }
        if (input.isError()) {
            return AcceptCharsetParser.error((Throwable)input.trap());
        }
        return new AcceptCharsetParser(http, (Parser<HttpCharset>)charset, (Builder<HttpCharset, FingerTrieSeq<HttpCharset>>)charsets, step);
    }

    static Parser<AcceptCharset> parse(Input input, HttpParser http) {
        return AcceptCharsetParser.parse(input, http, null, null, 1);
    }
}

