/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.TransferCoding;
import swim.http.header.TransferEncodingParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class TransferEncoding
extends HttpHeader {
    final FingerTrieSeq<TransferCoding> codings;
    private static int hashSeed;
    private static TransferEncoding chunked;

    TransferEncoding(FingerTrieSeq<TransferCoding> codings) {
        this.codings = codings;
    }

    @Override
    public boolean isBlank() {
        return this.codings.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "transfer-encoding";
    }

    @Override
    public String name() {
        return "Transfer-Encoding";
    }

    public FingerTrieSeq<TransferCoding> codings() {
        return this.codings;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(this.codings.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TransferEncoding) {
            TransferEncoding that = (TransferEncoding)other;
            return this.codings.equals(that.codings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(TransferEncoding.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.codings.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("TransferEncoding").write(46).write("from").write(40);
        int n = this.codings.size();
        if (n != 0) {
            output.debug(this.codings.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.codings.get(i));
            }
        }
        output = output.write(41);
    }

    public static TransferEncoding chunked() {
        if (chunked == null) {
            chunked = new TransferEncoding((FingerTrieSeq<TransferCoding>)FingerTrieSeq.of((Object[])new TransferCoding[]{TransferCoding.chunked()}));
        }
        return chunked;
    }

    public static TransferEncoding from(FingerTrieSeq<TransferCoding> codings) {
        return new TransferEncoding(codings);
    }

    public static TransferEncoding from(TransferCoding ... codings) {
        return TransferEncoding.from((FingerTrieSeq<TransferCoding>)FingerTrieSeq.of((Object[])codings));
    }

    public static TransferEncoding from(String ... codingStrings) {
        Builder codings = FingerTrieSeq.builder();
        int n = codingStrings.length;
        for (int i = 0; i < n; ++i) {
            codings.add((Object)TransferCoding.parse(codingStrings[i]));
        }
        return TransferEncoding.from((FingerTrieSeq<TransferCoding>)((FingerTrieSeq)codings.bind()));
    }

    public static Parser<TransferEncoding> parseHttpValue(Input input, HttpParser http) {
        return TransferEncodingParser.parse(input, http);
    }
}

