/*
 * Decompiled with CFR 0.152.
 */
package swim.xml;

import swim.codec.Base10;
import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.xml.Xml;
import swim.xml.XmlParser;

final class ReferenceParser
extends Parser<Object> {
    final XmlParser<?, ?> xml;
    final Output<?> output;
    final Parser<String> nameParser;
    final int code;
    final int step;

    ReferenceParser(XmlParser<?, ?> xml, Output<?> output, Parser<String> nameParser, int code, int step) {
        this.xml = xml;
        this.output = output;
        this.nameParser = nameParser;
        this.code = code;
        this.step = step;
    }

    public Parser<Object> feed(Input input) {
        return ReferenceParser.parse(input, this.xml, this.output, this.nameParser, this.code, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<Object> parse(Input input, XmlParser<?, ?> xml, Output<?> output, Parser<String> nameParser22222, int code, int step) {
        void nameParser22222;
        int c;
        block46: {
            block45: {
                c = 0;
                if (step == 1) {
                    if (input.isCont()) {
                        c = input.head();
                        if (c != 38) return ReferenceParser.error((Diagnostic)Diagnostic.expected((int)38, (Input)input));
                        input = input.step();
                        step = 2;
                    } else if (input.isDone()) {
                        return ReferenceParser.error((Diagnostic)Diagnostic.expected((int)38, (Input)input));
                    }
                }
                if (step == 2) {
                    if (input.isCont()) {
                        c = input.head();
                        if (c == 35) {
                            input = input.step();
                            step = 5;
                        } else {
                            step = 3;
                        }
                    } else if (input.isDone()) {
                        return ReferenceParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step == 3) {
                    void nameParser22222;
                    if (nameParser22222 == null) {
                        Parser<String> nameParser22222 = xml.parseEntityName(input);
                    } else {
                        Object nameParser22222;
                        Parser nameParser22222 = nameParser22222.feed(input);
                    }
                    if (nameParser22222.isDone()) {
                        step = 4;
                    } else if (nameParser22222.isError()) {
                        return nameParser22222.asError();
                    }
                }
                if (step == 4) {
                    if (input.isCont()) {
                        c = input.head();
                        if (c != 59) return ReferenceParser.error((Diagnostic)Diagnostic.expected((int)59, (Input)input));
                        input = input.step();
                        boolean expanded = xml.expandEntityRef((String)nameParser22222.bind(), output);
                        if (!expanded) return ReferenceParser.error((Diagnostic)Diagnostic.message((String)("unrecognized entity: " + (String)nameParser22222.bind()), (Input)input));
                        return ReferenceParser.done();
                    }
                    if (input.isDone()) {
                        return ReferenceParser.error((Diagnostic)Diagnostic.expected((int)59, (Input)input));
                    }
                }
                if (step == 5) {
                    if (input.isCont()) {
                        c = input.head();
                        if (c == 120) {
                            input = input.step();
                            step = 6;
                        } else {
                            step = 8;
                        }
                    } else if (input.isDone()) {
                        return ReferenceParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step == 6) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Base16.isDigit((int)c)) return ReferenceParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                        input = input.step();
                        code = Base16.decodeDigit((int)c);
                        step = 7;
                    } else if (input.isDone()) {
                        return ReferenceParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    }
                }
                if (step == 7) {
                    while (input.isCont()) {
                        c = input.head();
                        if (Base16.isDigit((int)c)) {
                            input = input.step();
                            code = 16 * code + Base16.decodeDigit((int)c);
                            continue;
                        }
                        step = 10;
                        break block45;
                    }
                    if (input.isDone()) {
                        return ReferenceParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
            }
            if (step == 8) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Base10.isDigit((int)c)) return ReferenceParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
                    input = input.step();
                    code = Base10.decodeDigit((int)c);
                    step = 9;
                } else if (input.isDone()) {
                    return ReferenceParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
                }
            }
            if (step == 9) {
                while (input.isCont()) {
                    c = input.head();
                    if (Base10.isDigit((int)c)) {
                        input = input.step();
                        code = 10 * code + Base10.decodeDigit((int)c);
                        continue;
                    }
                    step = 10;
                    break block46;
                }
                if (input.isDone()) {
                    return ReferenceParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                }
            }
        }
        if (step == 10) {
            if (input.isCont()) {
                c = input.head();
                if (c != 59) return ReferenceParser.error((Diagnostic)Diagnostic.expected((int)59, (Input)input));
                input = input.step();
                if (!Xml.isChar(code)) {
                    return ReferenceParser.error((Diagnostic)Diagnostic.message((String)("illegal character reference: " + code), (Input)input));
                }
                output = output.write(code);
                return ReferenceParser.done();
            }
            if (input.isDone()) {
                return ReferenceParser.error((Diagnostic)Diagnostic.expected((int)59, (Input)input));
            }
        }
        if (!input.isError()) return new ReferenceParser(xml, output, (Parser<String>)nameParser22222, code, step);
        return ReferenceParser.error((Throwable)input.trap());
    }

    static Parser<Object> parse(Input input, XmlParser<?, ?> xml, Output<?> output) {
        return ReferenceParser.parse(input, xml, output, null, 0, 1);
    }
}

