/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.codec.Encoder;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.warp.Envelope;

final class EnvelopeEncoder
extends Encoder<Envelope, Envelope> {
    final Envelope envelope;
    final Encoder<?, ?> input;

    EnvelopeEncoder(Envelope envelope, Encoder<?, ?> input) {
        this.envelope = envelope;
        this.input = input;
    }

    EnvelopeEncoder(Envelope envelope) {
        this(envelope, null);
    }

    EnvelopeEncoder() {
        this(null, null);
    }

    public Encoder<Envelope, Envelope> pull(OutputBuffer<?> output) {
        return EnvelopeEncoder.encode(output, this.envelope, this.input);
    }

    public Encoder<Envelope, Envelope> feed(Envelope envelope) {
        return new EnvelopeEncoder(envelope);
    }

    static Encoder<Envelope, Envelope> encode(OutputBuffer<?> output, Envelope envelope, Encoder<?, ?> input) {
        if ((input = input == null ? Utf8.writeEncoded(envelope.reconWriter(), output) : input.pull(output)).isDone()) {
            return EnvelopeEncoder.done((Object)envelope);
        }
        if (input.isError()) {
            return EnvelopeEncoder.error((Throwable)input.trap());
        }
        if (output.isError()) {
            return EnvelopeEncoder.error((Throwable)output.trap());
        }
        return new EnvelopeEncoder(envelope, (Encoder<?, ?>)input);
    }
}

