/*
 * Decompiled with CFR 0.152.
 */
package swim.decipher;

import swim.codec.Input;
import swim.codec.Parser;
import swim.decipher.DecipherParser;

final class AnyParser<I, V>
extends Parser<V> {
    final DecipherParser<I, V> decipher;
    final Parser<V> xmlParser;
    final Parser<V> jsonParser;
    final Parser<V> reconParser;

    AnyParser(DecipherParser<I, V> decipher, Parser<V> xmlParser, Parser<V> jsonParser, Parser<V> reconParser) {
        this.decipher = decipher;
        this.xmlParser = xmlParser;
        this.jsonParser = jsonParser;
        this.reconParser = reconParser;
    }

    AnyParser(DecipherParser<I, V> decipher) {
        this(decipher, null, null, null);
    }

    public Parser<V> feed(Input input) {
        return AnyParser.parse(input, this.decipher, this.xmlParser, this.jsonParser, this.reconParser);
    }

    static <I, V> Parser<V> parse(Input input, DecipherParser<I, V> decipher, Parser<V> xmlParser, Parser<V> jsonParser, Parser<V> reconParser) {
        if (xmlParser == null || xmlParser.isCont()) {
            Input xmlInput = input.clone();
            xmlParser = xmlParser == null ? decipher.parseXml(xmlInput) : xmlParser.feed(xmlInput);
            if (xmlInput.isDone() && xmlParser.isDone()) {
                return xmlParser;
            }
        }
        if (jsonParser == null || jsonParser.isCont()) {
            Input jsonInput = input.clone();
            jsonParser = jsonParser == null ? decipher.parseJson(jsonInput) : jsonParser.feed(jsonInput);
            if (jsonInput.isDone() && jsonParser.isDone()) {
                return jsonParser;
            }
        }
        if (reconParser == null || reconParser.isCont()) {
            Input reconInput = input.clone();
            reconParser = reconParser == null ? decipher.parseRecon(reconInput) : reconParser.feed(reconInput);
            if (reconInput.isDone() && reconParser.isDone()) {
                return reconParser;
            }
        }
        if (jsonParser.isError() && reconParser.isError()) {
            return xmlParser;
        }
        if (xmlParser.isError() && reconParser.isError()) {
            return jsonParser;
        }
        if (xmlParser.isError() && jsonParser.isError()) {
            return reconParser;
        }
        if (input.isError()) {
            return AnyParser.error((Throwable)input.trap());
        }
        return new AnyParser<I, V>(decipher, xmlParser, jsonParser, reconParser);
    }

    static <I, V> Parser<V> parse(Input input, DecipherParser<I, V> decipher) {
        return AnyParser.parse(input, decipher, null, null, null);
    }
}

