/*
 * Decompiled with CFR 0.152.
 */
package swim.fabric;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.SwimContext;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.agent.AgentRoute;
import swim.api.agent.AgentRouteContext;
import swim.api.auth.Authenticator;
import swim.api.auth.AuthenticatorContext;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.plane.Plane;
import swim.api.plane.PlaneContext;
import swim.api.plane.PlaneFactory;
import swim.api.policy.PlanePolicy;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.api.space.Space;
import swim.collections.HashTrieMap;
import swim.concurrent.MainStage;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.fabric.FabricAgentRoute;
import swim.fabric.FabricAuthenticator;
import swim.fabric.FabricDef;
import swim.fabric.FabricIdentity;
import swim.fabric.FabricMesh;
import swim.kernel.KernelContext;
import swim.runtime.AbstractTierBinding;
import swim.runtime.EdgeBinding;
import swim.runtime.EdgeContext;
import swim.runtime.HostBinding;
import swim.runtime.HostDef;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.LogDef;
import swim.runtime.MeshBinding;
import swim.runtime.MeshDef;
import swim.runtime.NodeBinding;
import swim.runtime.NodeDef;
import swim.runtime.PartBinding;
import swim.runtime.PartDef;
import swim.runtime.PolicyDef;
import swim.runtime.PushRequest;
import swim.runtime.TierContext;
import swim.runtime.agent.AgentModel;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriMapper;
import swim.uri.UriPattern;
import swim.util.Log;

public class Fabric
extends AbstractTierBinding
implements EdgeContext,
PlaneContext,
Space {
    final String spaceName;
    final FabricDef fabricDef;
    final KernelContext kernel;
    final EdgeBinding edge;
    Log log;
    PlanePolicy policy;
    Stage stage;
    StoreBinding store;
    volatile HashTrieMap<String, Plane> planes;
    volatile HashTrieMap<String, AgentRoute<?>> agentRoutes;
    volatile UriMapper<AgentFactory<?>> agentFactories;
    volatile HashTrieMap<String, Authenticator> authenticators;
    static final AtomicReferenceFieldUpdater<Fabric, HashTrieMap<String, Plane>> PLANES = AtomicReferenceFieldUpdater.newUpdater(Fabric.class, HashTrieMap.class, "planes");
    static final AtomicReferenceFieldUpdater<Fabric, HashTrieMap<String, AgentRoute<?>>> AGENT_ROUTES = AtomicReferenceFieldUpdater.newUpdater(Fabric.class, HashTrieMap.class, "agentRoutes");
    static final AtomicReferenceFieldUpdater<Fabric, UriMapper<AgentFactory<?>>> AGENT_FACTORIES = AtomicReferenceFieldUpdater.newUpdater(Fabric.class, UriMapper.class, "agentFactories");
    static final AtomicReferenceFieldUpdater<Fabric, HashTrieMap<String, Authenticator>> AUTHENTICATORS = AtomicReferenceFieldUpdater.newUpdater(Fabric.class, HashTrieMap.class, "authenticators");

    public Fabric(String spaceName, FabricDef fabricDef, KernelContext kernel) {
        this.spaceName = spaceName;
        this.fabricDef = fabricDef;
        this.kernel = kernel;
        EdgeBinding edge = this.createEdge();
        edge = this.injectEdge(edge);
        edge.setEdgeContext((EdgeContext)this);
        this.edge = edge = edge.edgeWrapper();
        this.planes = HashTrieMap.empty();
        this.agentRoutes = HashTrieMap.empty();
        this.agentFactories = UriMapper.empty();
        this.authenticators = HashTrieMap.empty();
        this.openEdge(this.edge);
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final FabricDef fabricDef() {
        return this.fabricDef;
    }

    public final TierContext tierContext() {
        return null;
    }

    public final EdgeBinding edgeWrapper() {
        return this.edge.edgeWrapper();
    }

    public <T> T unwrapEdge(Class<T> edgeClass) {
        if (edgeClass.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return (T)((Object)this);
        }
        return null;
    }

    public final Uri meshUri() {
        return Uri.empty();
    }

    public final PlanePolicy policy() {
        return this.policy;
    }

    public void setPolicy(PlanePolicy policy) {
        this.policy = policy;
    }

    public Schedule schedule() {
        return this.stage;
    }

    public final Stage stage() {
        return this.stage;
    }

    public final StoreBinding store() {
        return this.store;
    }

    public final KernelContext kernel() {
        return this.kernel;
    }

    public final EdgeBinding edge() {
        return this.edge;
    }

    public Authenticator getAuthenticator(String authenticatorName) {
        return (Authenticator)this.authenticators.get((Object)authenticatorName);
    }

    public void addAuthenticator(String authenticatorName, Authenticator authenticator) {
        HashTrieMap newAuthenticators;
        HashTrieMap<String, Authenticator> oldAuthenticators;
        FabricAuthenticator authenticatorContext = new FabricAuthenticator(authenticatorName, this.kernel);
        authenticator.setAuthenticatorContext((AuthenticatorContext)authenticatorContext);
        while (!AUTHENTICATORS.compareAndSet(this, oldAuthenticators = this.authenticators, (HashTrieMap<String, Authenticator>)(newAuthenticators = oldAuthenticators.updated((Object)authenticatorName, (Object)authenticator)))) {
        }
    }

    public Collection<? extends Plane> planes() {
        return this.planes.values();
    }

    public Plane getPlane(String planeName) {
        return (Plane)this.planes.get((Object)planeName);
    }

    public <P extends Plane> P getPlane(Class<? extends P> planeClass) {
        for (Plane plane : this.planes.values()) {
            if (!planeClass.isAssignableFrom(plane.getClass())) continue;
            return (P)plane;
        }
        return null;
    }

    public <P extends Plane> P openPlane(String planeName, PlaneFactory<P> planeFactory) {
        Object plane;
        block2: {
            HashTrieMap<String, Plane> oldPlanes;
            Plane oldPlane;
            plane = null;
            while ((oldPlane = (Plane)(oldPlanes = this.planes).get((Object)planeName)) == null) {
                HashTrieMap newPlanes;
                if (plane == null) {
                    plane = this.createPlane(planeFactory);
                    plane = this.kernel.injectPlane(plane);
                }
                if (!PLANES.compareAndSet(this, oldPlanes, (HashTrieMap<String, Plane>)(newPlanes = oldPlanes.updated((Object)planeName, plane)))) continue;
                break block2;
            }
            plane = oldPlane;
        }
        return (P)plane;
    }

    public <P extends Plane> P openPlane(String planeName, Class<? extends P> planeClass) {
        PlaneFactory planeFactory;
        Object plane = this.getPlane(planeName);
        if (plane == null && (planeFactory = this.kernel.createPlaneFactory(planeClass)) != null) {
            plane = this.openPlane(planeName, planeFactory);
        }
        return (P)plane;
    }

    protected <P extends Plane> P createPlane(PlaneFactory<P> planeFactory) {
        try {
            SwimContext.setPlaneContext((PlaneContext)this);
            Plane plane = planeFactory.createPlane((PlaneContext)this);
            return (P)plane;
        }
        finally {
            SwimContext.clear();
        }
    }

    public <A extends Agent> AgentRoute<A> getAgentRoute(String routeName) {
        return (AgentRoute)this.agentRoutes.get((Object)routeName);
    }

    public <A extends Agent> AgentRoute<A> createAgentRoute(Class<? extends A> agentClass) {
        return this.kernel.createAgentRoute(this.spaceName, agentClass);
    }

    public void addAgentRoute(String routeName, UriPattern pattern, AgentRoute<?> agentRoute) {
        UriMapper newAgentFactories;
        UriMapper<AgentFactory<?>> oldAgentFactories;
        HashTrieMap newAgentRoutes;
        HashTrieMap<String, AgentRoute<?>> oldAgentRoutes;
        FabricAgentRoute agentRouteContext = new FabricAgentRoute(routeName, pattern);
        agentRoute.setAgentRouteContext((AgentRouteContext)agentRouteContext);
        while ((oldAgentRoutes = this.agentRoutes) != (newAgentRoutes = oldAgentRoutes.updated((Object)routeName, agentRoute)) && !AGENT_ROUTES.compareAndSet(this, oldAgentRoutes, newAgentRoutes)) {
        }
        while ((oldAgentFactories = this.agentFactories) != (newAgentFactories = oldAgentFactories.updated(pattern, agentRoute)) && !AGENT_FACTORIES.compareAndSet(this, oldAgentFactories, newAgentFactories)) {
        }
    }

    public void addAgentRoute(String routeName, String pattern, AgentRoute<?> agentRoute) {
        this.addAgentRoute(routeName, UriPattern.parse((String)pattern), agentRoute);
    }

    public void removeAgentRoute(String routeName) {
        HashTrieMap newAgentRoutes;
        HashTrieMap<String, AgentRoute<?>> oldAgentRoutes;
        while ((oldAgentRoutes = this.agentRoutes) != (newAgentRoutes = oldAgentRoutes.removed((Object)routeName)) && !AGENT_ROUTES.compareAndSet(this, oldAgentRoutes, newAgentRoutes)) {
        }
        AgentRoute agentRoute = (AgentRoute)oldAgentRoutes.get((Object)routeName);
        if (agentRoute != null) {
            UriMapper newAgentFactories;
            UriMapper<AgentFactory<?>> oldAgentFactories;
            while ((oldAgentFactories = this.agentFactories) != (newAgentFactories = oldAgentFactories.removed(agentRoute.pattern())) && !AGENT_FACTORIES.compareAndSet(this, oldAgentFactories, newAgentFactories)) {
            }
        }
    }

    public AgentFactory<?> getAgentFactory(Uri nodeUri) {
        return (AgentFactory)this.agentFactories.get(nodeUri);
    }

    public AgentFactory<?> createAgentFactory(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, AgentDef agentDef) {
        return this.kernel.createAgentFactory(this.spaceName, meshUri, partKey, hostUri, nodeUri, agentDef);
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Class<? extends A> agentClass) {
        return this.kernel.createAgentFactory(this.spaceName, meshUri, partKey, hostUri, nodeUri, agentClass);
    }

    public void openAgents(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, NodeBinding node) {
        this.kernel.openAgents(this.spaceName, meshUri, partKey, hostUri, nodeUri, node);
        if (!meshUri.isDefined()) {
            AgentFactory agentFactory;
            NodeDef nodeDef = this.fabricDef.getNodeDef(nodeUri);
            if (nodeDef != null && node instanceof AgentModel) {
                AgentModel agentModel = (AgentModel)node;
                for (AgentDef agentDef : nodeDef.agentDefs()) {
                    AgentFactory<?> agentFactory2 = this.createAgentFactory(meshUri, partKey, hostUri, nodeUri, agentDef);
                    if (agentDef == null) continue;
                    Value props = agentDef.props();
                    if (!props.isDefined()) {
                        props = agentModel.props();
                    }
                    agentModel.addAgentView(agentModel.createAgent(agentFactory2, props));
                }
            }
            if ((agentFactory = (AgentFactory)this.agentFactories.get(nodeUri)) != null && node instanceof AgentModel) {
                AgentModel agentModel = (AgentModel)node;
                agentModel.addAgentView(agentModel.createAgent(agentFactory, agentModel.props()));
            }
        }
    }

    public Log createLog(LogDef logDef) {
        return this.kernel.createLog(logDef);
    }

    public Log injectLog(Log log) {
        return this.kernel.injectLog(log);
    }

    protected Log openLog() {
        Log log = this.fabricDef.logDef != null ? this.createLog(this.fabricDef.logDef) : this.openEdgeLog();
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    protected void closeLog() {
        this.log = null;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        return this.kernel.createPolicy(policyDef);
    }

    public Policy injectPolicy(Policy policy) {
        return this.kernel.injectPolicy(policy);
    }

    protected PlanePolicy openPolicy() {
        Policy policy = this.fabricDef.policyDef != null ? this.createPolicy(this.fabricDef.policyDef) : this.openEdgePolicy();
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return (PlanePolicy)policy;
    }

    protected void closePolicy() {
        this.policy = null;
    }

    public Stage createStage(StageDef stageDef) {
        return this.kernel.createStage(stageDef);
    }

    public Stage injectStage(Stage stage) {
        return this.kernel.injectStage(stage);
    }

    protected Stage openStage() {
        Stage stage = this.fabricDef.stageDef != null ? this.createStage(this.fabricDef.stageDef) : this.openEdgeStage();
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    protected void closeStage() {
        Stage stage = this.stage;
        if (stage instanceof MainStage) {
            ((MainStage)stage).stop();
        }
        this.stage = null;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        return this.kernel.createStore(storeDef, null);
    }

    public StoreBinding injectStore(StoreBinding store) {
        return this.kernel.injectStore(store);
    }

    protected StoreBinding openStore() {
        StoreBinding store = null;
        store = this.fabricDef.storeDef != null ? this.createStore(this.fabricDef.storeDef) : this.openEdgeStore();
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    protected void closeStore() {
        StoreBinding store = this.store;
        if (store != null) {
            store.close();
        }
        this.store = null;
    }

    protected EdgeBinding createEdge() {
        EdgeBinding edge = this.kernel.createEdge(this.spaceName);
        if (edge != null) {
            edge = this.kernel.injectEdge(this.spaceName, edge);
        }
        return edge;
    }

    protected void openEdge(EdgeBinding edge) {
        for (MeshDef meshDef : this.fabricDef.meshDefs()) {
            this.createMesh(edge, meshDef);
        }
        if (edge.network() == null) {
            MeshBinding network = edge.openMesh(Uri.empty());
            edge.setNetwork(network);
            PartBinding partBinding = network.openGateway();
            HostBinding localHost = partBinding.openHost(Uri.empty());
            partBinding.setMaster(localHost);
        }
    }

    protected MeshBinding createMesh(EdgeBinding edge, MeshDef meshDef) {
        Uri meshUri = meshDef.meshUri();
        MeshBinding mesh = this.kernel.createMesh(this.spaceName, meshDef);
        if (mesh != null && (mesh = edge.openMesh(meshUri, mesh)) != null) {
            if (!meshUri.isDefined()) {
                edge.setNetwork(mesh);
            }
            for (PartDef partDef : meshDef.partDefs()) {
                this.createPart(edge, mesh, partDef);
            }
        }
        return mesh;
    }

    protected PartBinding createPart(EdgeBinding edge, MeshBinding mesh, PartDef partDef) {
        Uri meshUri = mesh.meshUri();
        Value partKey = partDef.partKey();
        PartBinding part = this.kernel.createPart(this.spaceName, meshUri, partDef);
        if (part != null && (part = mesh.addPart(partKey, part)) != null) {
            if (partDef.isGateway()) {
                mesh.setGateway(part);
            }
            for (HostDef hostDef : partDef.hostDefs()) {
                this.createHost(edge, mesh, part, hostDef);
            }
        }
        return part;
    }

    protected HostBinding createHost(EdgeBinding edge, MeshBinding mesh, PartBinding part, HostDef hostDef) {
        Uri meshUri = mesh.meshUri();
        Value partKey = part.partKey();
        Uri hostUri = hostDef.hostUri();
        HostBinding host = null;
        if (hostUri != null && (host = this.kernel.createHost(this.spaceName, meshUri, partKey, hostDef)) != null && (host = part.openHost(hostUri, host)) != null) {
            host.setReplica(hostDef.isReplica());
            if (hostDef.isPrimary()) {
                host.setPrimary(true);
                part.setMaster(host);
                host.didBecomeMaster();
            } else if (hostDef.isReplica()) {
                host.didBecomeSlave();
            }
            for (NodeDef nodeDef : hostDef.nodeDefs()) {
                this.createNode(edge, mesh, part, host, nodeDef);
            }
        }
        return host;
    }

    protected NodeBinding createNode(EdgeBinding edge, MeshBinding mesh, PartBinding part, HostBinding host, NodeDef nodeDef) {
        Uri meshUri = mesh.meshUri();
        Value partKey = part.partKey();
        Uri hostUri = host.hostUri();
        Uri nodeUri = nodeDef.nodeUri();
        NodeBinding node = null;
        if (nodeUri != null && (node = this.kernel.createNode(this.spaceName, meshUri, partKey, hostUri, nodeDef)) != null && (node = host.openNode(nodeUri, node)) != null) {
            for (LaneDef laneDef : nodeDef.laneDefs()) {
                this.createLane(edge, mesh, part, host, node, laneDef);
            }
        }
        return node;
    }

    protected LaneBinding createLane(EdgeBinding edge, MeshBinding mesh, PartBinding part, HostBinding host, NodeBinding node, LaneDef laneDef) {
        Uri meshUri = mesh.meshUri();
        Value partKey = part.partKey();
        Uri hostUri = host.hostUri();
        Uri nodeUri = node.nodeUri();
        Uri laneUri = laneDef.laneUri();
        LaneBinding lane = null;
        if (laneUri != null && (lane = this.kernel.createLane(this.spaceName, meshUri, partKey, hostUri, nodeUri, laneDef)) != null) {
            lane = node.openLane(laneUri, lane);
        }
        return lane;
    }

    protected EdgeBinding injectEdge(EdgeBinding edge) {
        return this.kernel.injectEdge(this.spaceName, edge);
    }

    protected Log openEdgeLog() {
        return this.kernel.openEdgeLog(this.spaceName);
    }

    protected Policy openEdgePolicy() {
        return this.kernel.openEdgePolicy(this.spaceName);
    }

    protected Stage openEdgeStage() {
        return this.kernel.openEdgeStage(this.spaceName);
    }

    protected StoreBinding openEdgeStore() {
        return this.kernel.openEdgeStore(this.spaceName);
    }

    public MeshDef getMeshDef(Uri meshUri) {
        MeshDef meshDef = this.fabricDef.getMeshDef(meshUri);
        if (meshDef == null) {
            meshDef = this.kernel.getMeshDef(this.spaceName, meshUri);
        }
        return meshDef;
    }

    public MeshBinding createMesh(Uri meshUri) {
        return this.kernel.createMesh(this.spaceName, meshUri);
    }

    public MeshBinding injectMesh(Uri meshUri, MeshBinding mesh) {
        MeshDef meshDef = this.getMeshDef(meshUri);
        return new FabricMesh(this.kernel.injectMesh(this.spaceName, meshUri, mesh), meshDef);
    }

    public Log openMeshLog(Uri meshUri) {
        return this.kernel.openMeshLog(this.spaceName, meshUri);
    }

    public Policy openMeshPolicy(Uri meshUri) {
        return this.kernel.openMeshPolicy(this.spaceName, meshUri);
    }

    public Stage openMeshStage(Uri meshUri) {
        return this.kernel.openMeshStage(this.spaceName, meshUri);
    }

    public StoreBinding openMeshStore(Uri meshUri) {
        return this.kernel.openMeshStore(this.spaceName, meshUri);
    }

    public PartDef getPartDef(Uri meshUri, Value partKey) {
        PartDef partDef = this.fabricDef.getPartDef(partKey);
        if (partDef == null) {
            partDef = this.kernel.getPartDef(this.spaceName, meshUri, partKey);
        }
        return partDef;
    }

    public PartBinding createPart(Uri meshUri, Value partKey) {
        return this.kernel.createPart(this.spaceName, meshUri, partKey);
    }

    public PartBinding injectPart(Uri meshUri, Value partKey, PartBinding part) {
        return this.kernel.injectPart(this.spaceName, meshUri, partKey, part);
    }

    public Log openPartLog(Uri meshUri, Value partKey) {
        return this.kernel.openPartLog(this.spaceName, meshUri, partKey);
    }

    public Policy openPartPolicy(Uri meshUri, Value partKey) {
        return this.kernel.openPartPolicy(this.spaceName, meshUri, partKey);
    }

    public Stage openPartStage(Uri meshUri, Value partKey) {
        return this.kernel.openPartStage(this.spaceName, meshUri, partKey);
    }

    public StoreBinding openPartStore(Uri meshUri, Value partKey) {
        return this.kernel.openPartStore(this.spaceName, meshUri, partKey);
    }

    public HostDef getHostDef(Uri meshUri, Value partKey, Uri hostUri) {
        HostDef hostDef = this.fabricDef.getHostDef(hostUri);
        if (hostDef == null) {
            hostDef = this.kernel.getHostDef(this.spaceName, meshUri, partKey, hostUri);
        }
        return hostDef;
    }

    public HostBinding createHost(Uri meshUri, Value partKey, Uri hostUri) {
        return this.kernel.createHost(this.spaceName, meshUri, partKey, hostUri);
    }

    public HostBinding injectHost(Uri meshUri, Value partKey, Uri hostUri, HostBinding host) {
        return this.kernel.injectHost(this.spaceName, meshUri, partKey, hostUri, host);
    }

    public Log openHostLog(Uri meshUri, Value partKey, Uri hostUri) {
        return this.kernel.openHostLog(this.spaceName, meshUri, partKey, hostUri);
    }

    public Policy openHostPolicy(Uri meshUri, Value partKey, Uri hostUri) {
        return this.kernel.openHostPolicy(this.spaceName, meshUri, partKey, hostUri);
    }

    public Stage openHostStage(Uri meshUri, Value partKey, Uri hostUri) {
        return this.kernel.openHostStage(this.spaceName, meshUri, partKey, hostUri);
    }

    public StoreBinding openHostStore(Uri meshUri, Value partKey, Uri hostUri) {
        return this.kernel.openHostStore(this.spaceName, meshUri, partKey, hostUri);
    }

    public NodeDef getNodeDef(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        NodeDef nodeDef = this.fabricDef.getNodeDef(nodeUri);
        if (nodeDef == null) {
            nodeDef = this.kernel.getNodeDef(this.spaceName, meshUri, partKey, hostUri, nodeUri);
        }
        return nodeDef;
    }

    public NodeBinding createNode(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        NodeDef nodeDef;
        Value props;
        AgentFactory agentFactory;
        NodeBinding node = null;
        if (!meshUri.isDefined() && (agentFactory = (AgentFactory)this.agentFactories.get(nodeUri)) != null) {
            props = agentFactory.props(nodeUri);
            node = new AgentModel(props);
        }
        if (node == null) {
            node = this.kernel.createNode(this.spaceName, meshUri, partKey, hostUri, nodeUri);
        }
        if (node == null && !meshUri.isDefined() && (nodeDef = this.fabricDef.getNodeDef(nodeUri)) != null) {
            props = nodeDef.props(nodeUri);
            node = new AgentModel(props);
        }
        return node;
    }

    public NodeBinding injectNode(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, NodeBinding node) {
        return this.kernel.injectNode(this.spaceName, meshUri, partKey, hostUri, nodeUri, node);
    }

    public Log openNodeLog(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        return this.kernel.openNodeLog(this.spaceName, meshUri, partKey, hostUri, nodeUri);
    }

    public Policy openNodePolicy(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        return this.kernel.openNodePolicy(this.spaceName, meshUri, partKey, hostUri, nodeUri);
    }

    public Stage openNodeStage(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        return this.kernel.openNodeStage(this.spaceName, meshUri, partKey, hostUri, nodeUri);
    }

    public StoreBinding openNodeStore(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        return this.kernel.openNodeStore(this.spaceName, meshUri, partKey, hostUri, nodeUri);
    }

    public LaneDef getLaneDef(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        LaneDef laneDef = this.fabricDef.getLaneDef(laneUri);
        if (laneDef == null) {
            laneDef = this.kernel.getLaneDef(this.spaceName, meshUri, partKey, hostUri, nodeUri, laneUri);
        }
        return laneDef;
    }

    public LaneBinding createLane(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, LaneDef laneDef) {
        return this.kernel.createLane(this.spaceName, meshUri, partKey, hostUri, nodeUri, laneDef);
    }

    public LaneBinding createLane(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        return this.kernel.createLane(this.spaceName, meshUri, partKey, hostUri, nodeUri, laneUri);
    }

    public LaneBinding injectLane(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri, LaneBinding lane) {
        return this.kernel.injectLane(this.spaceName, meshUri, partKey, hostUri, nodeUri, laneUri, lane);
    }

    public void openLanes(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, NodeBinding node) {
        this.kernel.openLanes(this.spaceName, meshUri, partKey, hostUri, nodeUri, node);
    }

    public Log openLaneLog(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        return this.kernel.openLaneLog(this.spaceName, meshUri, partKey, hostUri, nodeUri, laneUri);
    }

    public Policy openLanePolicy(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        return this.kernel.openLanePolicy(this.spaceName, meshUri, partKey, hostUri, nodeUri, laneUri);
    }

    public Stage openLaneStage(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        return this.kernel.openLaneStage(this.spaceName, meshUri, partKey, hostUri, nodeUri, laneUri);
    }

    public StoreBinding openLaneStore(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        return this.kernel.openLaneStore(this.spaceName, meshUri, partKey, hostUri, nodeUri, laneUri);
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        PolicyDirective directive = null;
        HashTrieMap<String, Authenticator> authenticators = this.authenticators;
        if (!authenticators.isEmpty()) {
            Authenticator authenticator;
            Iterator iterator = authenticators.values().iterator();
            while (iterator.hasNext() && (directive = (authenticator = (Authenticator)iterator.next()).authenticate(credentials)) == null) {
            }
        } else {
            FabricIdentity identity = new FabricIdentity(credentials.requestUri(), credentials.fromUri(), Value.absent());
            directive = PolicyDirective.allow((Object)identity);
        }
        return directive;
    }

    public LinkBinding bindDownlink(Downlink downlink) {
        return this.edge.bindDownlink(downlink);
    }

    public void openDownlink(LinkBinding link) {
        this.edge.openDownlink(link);
    }

    public void closeDownlink(LinkBinding link) {
    }

    public void pushDown(PushRequest pushRequest) {
        this.edge.pushDown(pushRequest);
    }

    public void trace(Object message) {
        Log log = this.log;
        if (log != null) {
            log.trace(message);
        } else {
            this.kernel.trace(message);
        }
    }

    public void debug(Object message) {
        Log log = this.log;
        if (log != null) {
            log.debug(message);
        } else {
            this.kernel.debug(message);
        }
    }

    public void info(Object message) {
        Log log = this.log;
        if (log != null) {
            log.info(message);
        } else {
            this.kernel.info(message);
        }
    }

    public void warn(Object message) {
        Log log = this.log;
        if (log != null) {
            log.warn(message);
        } else {
            this.kernel.warn(message);
        }
    }

    public void error(Object message) {
        Log log = this.log;
        if (log != null) {
            log.error(message);
        } else {
            this.kernel.error(message);
        }
    }

    public void open() {
        this.edge.open();
    }

    public void load() {
        this.edge.load();
    }

    public void start() {
        this.edge.start();
    }

    public void stop() {
        this.edge.stop();
    }

    public void unload() {
        this.edge.unload();
    }

    public void close() {
        this.edge.close();
    }

    public void willOpen() {
        if (this.log == null) {
            this.log = this.openLog();
        }
        if (this.policy == null) {
            this.policy = this.openPolicy();
        }
        if (this.stage == null) {
            this.stage = this.openStage();
        }
        if (this.store == null) {
            this.store = this.openStore();
        }
        this.open();
    }

    public void didOpen() {
    }

    public void willLoad() {
        this.load();
    }

    public void didLoad() {
    }

    public void willStart() {
        for (Plane plane : this.planes.values()) {
            plane.willStart();
        }
        this.start();
    }

    public void didStart() {
        for (Plane plane : this.planes.values()) {
            plane.didStart();
        }
    }

    public void willStop() {
        for (Plane plane : this.planes.values()) {
            plane.willStop();
        }
        this.stop();
    }

    public void didStop() {
        for (Plane plane : this.planes.values()) {
            plane.didStop();
        }
    }

    public void willUnload() {
        this.unload();
    }

    public void didUnload() {
    }

    public void willClose() {
        for (Plane plane : this.planes.values()) {
            plane.willClose();
        }
        this.close();
    }

    public void didClose() {
        for (Plane plane : this.planes.values()) {
            plane.didClose();
        }
        this.closeStore();
        this.closeStage();
        this.closePolicy();
        this.closeLog();
    }

    public void didFail(Throwable error) {
        for (Plane plane : this.planes.values()) {
            plane.didFail(error);
        }
    }
}

